EESchema Schematic File Version 2
LIBS:Gigatron-parts
LIBS:Gigatron-rescue
LIBS:power
LIBS:device
LIBS:transistors
LIBS:conn
LIBS:linear
LIBS:regul
LIBS:74xx
LIBS:cmos4000
LIBS:adc-dac
LIBS:memory
LIBS:xilinx
LIBS:microcontrollers
LIBS:dsp
LIBS:microchip
LIBS:analog_switches
LIBS:motorola
LIBS:texas
LIBS:intel
LIBS:audio
LIBS:interface
LIBS:digital-audio
LIBS:philips
LIBS:display
LIBS:cypress
LIBS:siliconi
LIBS:opto
LIBS:atmel
LIBS:contrib
LIBS:valves
LIBS:MJ-3536N
LIBS:54819-0519
LIBS:wickerlib
LIBS:Gigatron-cache
EELAYER 25 0
EELAYER END
$Descr A4 11693 8268
encoding utf-8
Sheet 8 8
Title "Gigatron Peripherals"
Date "2020-03-20"
Rev "Release"
Comp "Marcel van Kervinck and Walter Belgers"
Comment1 "/HSYNC and /VSYNC double as clocks for the game controller and receiving shift register."
Comment2 "XOUT drives 4 blinkenlights and simple 4-bits audio. The waveform comes from software."
Comment3 "XOUT is controlled indirectly through /HSYNC and AC. On a positive edge it clocks in AC."
Comment4 "OUT gives 6 color bits and 2 sync bits for VGA. XOUT is the extended output register."
$EndDescr
$Comp
L 74LS273 U38
U 1 1 597C3B56
P 3600 4100
F 0 "U38" H 3600 3950 50  0000 C CNN
F 1 "74HCT273" H 3600 3750 50  0000 C CNN
F 2 "Kicad:DIP-20-MvK" H 3600 4100 50  0001 C CNN
F 3 "" H 3600 4100 50  0001 C CNN
	1    3600 4100
	1    0    0    -1  
$EndComp
Text Notes 3200 3450 0    60   ~ 0
Extended output
Text GLabel 2900 4600 0    60   Input ~ 0
H
Text GLabel 2900 3600 0    60   Input ~ 0
AC3
Text GLabel 2900 3700 0    60   Input ~ 0
AC2
Text GLabel 2900 3800 0    60   Input ~ 0
AC1
Text GLabel 2900 3900 0    60   Input ~ 0
AC0
Text GLabel 2900 4000 0    60   Input ~ 0
AC4
Text GLabel 2900 4100 0    60   Input ~ 0
AC5
Text GLabel 2900 4200 0    60   Input ~ 0
AC6
Text GLabel 2900 4300 0    60   Input ~ 0
AC7
Text GLabel 1400 1300 0    60   Input ~ 0
OUT0
$Comp
L DB15_FEMALE_HighDensity_MountingHoles J3
U 1 1 597C4B2F
P 3600 1800
F 0 "J3" H 3600 2650 50  0000 C CNN
F 1 "DB15_FEMALE_HighDensity_MountingHoles" H 3600 2550 50  0000 C CNN
F 2 "DB15:DB15_1734344_MvK" H 2650 2200 50  0001 C CNN
F 3 "" H 2650 2200 50  0001 C CNN
	1    3600 1800
	1    0    0    -1  
$EndComp
Text GLabel 1400 1500 0    60   Input ~ 0
OUT1
Text GLabel 1400 1700 0    60   Input ~ 0
OUT2
Text GLabel 1400 1900 0    60   Input ~ 0
OUT3
Text GLabel 1400 2100 0    60   Input ~ 0
OUT4
Text GLabel 1400 2300 0    60   Input ~ 0
OUT5
Text GLabel 1400 2500 0    60   Input ~ 0
OUT6
Text GLabel 1400 2700 0    60   Input ~ 0
OUT7
$Comp
L R R15
U 1 1 597C4C46
P 1800 2100
F 0 "R15" V 1880 2100 50  0000 C CNN
F 1 "1k5" V 1800 2100 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 2100 50  0001 C CNN
F 3 "" H 1800 2100 50  0001 C CNN
	1    1800 2100
	0    1    1    0   
$EndComp
$Comp
L R R16
U 1 1 597C4CAE
P 1800 2300
F 0 "R16" V 1880 2300 50  0000 C CNN
F 1 "750" V 1800 2300 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 2300 50  0001 C CNN
F 3 "" H 1800 2300 50  0001 C CNN
	1    1800 2300
	0    1    1    0   
$EndComp
$Comp
L R R14
U 1 1 597C4EB8
P 1800 1900
F 0 "R14" V 1880 1900 50  0000 C CNN
F 1 "750" V 1800 1900 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 1900 50  0001 C CNN
F 3 "" H 1800 1900 50  0001 C CNN
	1    1800 1900
	0    1    1    0   
$EndComp
$Comp
L R R13
U 1 1 597C4ED7
P 1800 1700
F 0 "R13" V 1880 1700 50  0000 C CNN
F 1 "1k5" V 1800 1700 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 1700 50  0001 C CNN
F 3 "" H 1800 1700 50  0001 C CNN
	1    1800 1700
	0    1    1    0   
$EndComp
$Comp
L R R12
U 1 1 597C4EFB
P 1800 1500
F 0 "R12" V 1880 1500 50  0000 C CNN
F 1 "750" V 1800 1500 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 1500 50  0001 C CNN
F 3 "" H 1800 1500 50  0001 C CNN
	1    1800 1500
	0    1    1    0   
$EndComp
$Comp
L R R11
U 1 1 597C4F23
P 1800 1300
F 0 "R11" V 1880 1300 50  0000 C CNN
F 1 "1k5" V 1800 1300 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 1300 50  0001 C CNN
F 3 "" H 1800 1300 50  0001 C CNN
	1    1800 1300
	0    1    1    0   
$EndComp
$Comp
L R R17
U 1 1 597C4F4D
P 1800 2500
F 0 "R17" V 1880 2500 50  0000 C CNN
F 1 "68" V 1800 2500 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 2500 50  0001 C CNN
F 3 "" H 1800 2500 50  0001 C CNN
	1    1800 2500
	0    1    1    0   
$EndComp
$Comp
L R R18
U 1 1 597C4F78
P 1800 2700
F 0 "R18" V 1880 2700 50  0000 C CNN
F 1 "68" V 1800 2700 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 1730 2700 50  0001 C CNN
F 3 "" H 1800 2700 50  0001 C CNN
	1    1800 2700
	0    1    1    0   
$EndComp
Text Label 2250 1400 0    60   ~ 0
RED
Text Label 2250 1800 0    60   ~ 0
GREEN
Text Label 2250 2200 0    60   ~ 0
BLUE
$Comp
L GND #PWR014
U 1 1 597C58DF
P 3350 2650
F 0 "#PWR014" H 3350 2400 50  0001 C CNN
F 1 "GND" H 3350 2500 50  0000 C CNN
F 2 "" H 3350 2650 50  0001 C CNN
F 3 "" H 3350 2650 50  0001 C CNN
	1    3350 2650
	1    0    0    -1  
$EndComp
Text Label 2000 2500 0    60   ~ 0
~HSYNC
Text Label 2000 2700 0    60   ~ 0
~VSYNC
Text Notes 950  950  0    60   ~ 0
The RGB resistor values depend on the 74xx sub-family of the OUT register:\n 7400/74LS: 390Ω / 820Ω\n 74HCT/HC: 750Ω / 1500Ω
NoConn ~ 3900 2200
NoConn ~ 3900 1600
NoConn ~ 3900 1400
NoConn ~ 3300 1900
NoConn ~ 3300 2000
$Comp
L LED D8
U 1 1 597C7048
P 5350 3000
F 0 "D8" H 5350 3100 50  0000 C CNN
F 1 "LED" H 5350 2900 50  0000 C CNN
F 2 "LEDs:LED_D3.0mm" H 5350 3000 50  0001 C CNN
F 3 "" H 5350 3000 50  0001 C CNN
	1    5350 3000
	-1   0    0    1   
$EndComp
$Comp
L LED D7
U 1 1 597C71BF
P 5350 3300
F 0 "D7" H 5350 3400 50  0000 C CNN
F 1 "LED" H 5350 3200 50  0000 C CNN
F 2 "LEDs:LED_D3.0mm" H 5350 3300 50  0001 C CNN
F 3 "" H 5350 3300 50  0001 C CNN
	1    5350 3300
	-1   0    0    1   
$EndComp
$Comp
L LED D6
U 1 1 597C71F6
P 5350 3600
F 0 "D6" H 5350 3700 50  0000 C CNN
F 1 "LED" H 5350 3500 50  0000 C CNN
F 2 "LEDs:LED_D3.0mm" H 5350 3600 50  0001 C CNN
F 3 "" H 5350 3600 50  0001 C CNN
	1    5350 3600
	-1   0    0    1   
$EndComp
Text Notes 5650 2550 0    60   ~ 0
Blinkenlights\n
Text Notes 3100 5700 0    60   ~ 0
Game controller input
Text Notes 4300 1850 0    60   ~ 0
DB15 connector for 64 colors analog\nRGB video out (VGA compatible)
$Comp
L GND #PWR015
U 1 1 598080EB
P 9500 4900
F 0 "#PWR015" H 9500 4650 50  0001 C CNN
F 1 "GND" H 9500 4750 50  0000 C CNN
F 2 "" H 9500 4900 50  0001 C CNN
F 3 "" H 9500 4900 50  0001 C CNN
	1    9500 4900
	1    0    0    -1  
$EndComp
Text Notes 7250 4000 0    60   ~ 0
DAC\n
$Comp
L C C43
U 1 1 59858D0F
P 8200 4600
F 0 "C43" H 8225 4700 50  0000 L CNN
F 1 "0.1µ" H 8225 4500 50  0000 L CNN
F 2 "Capacitors_THT:C_Disc_D4.3mm_W1.9mm_P5.00mm" H 8238 4450 50  0001 C CNN
F 3 "" H 8200 4600 50  0001 C CNN
	1    8200 4600
	1    0    0    -1  
$EndComp
$Comp
L C C44
U 1 1 59858E78
P 8650 4300
F 0 "C44" V 8600 4100 50  0000 L CNN
F 1 "0.1µ" V 8800 4200 50  0000 L CNN
F 2 "Capacitors_THT:C_Disc_D4.3mm_W1.9mm_P5.00mm" H 8688 4150 50  0001 C CNN
F 3 "" H 8650 4300 50  0001 C CNN
	1    8650 4300
	0    1    1    0   
$EndComp
$Comp
L R R10
U 1 1 598590D5
P 8900 4600
F 0 "R10" V 8980 4600 50  0000 C CNN
F 1 "2.2k" V 8900 4600 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 8830 4600 50  0001 C CNN
F 3 "" H 8900 4600 50  0001 C CNN
	1    8900 4600
	1    0    0    -1  
$EndComp
Text Notes 8050 4650 2    60   ~ 0
Low\npass
Text Notes 8400 4100 0    60   ~ 0
AC coupling\nHigh pass
Text Notes 8350 1950 0    60   ~ 0
Attenuation from 74HCT output to audio\nline level by two overlapping filter slopes:\nf_L = 160 Hz; f_H = 700 Hz
Text Notes 9600 4000 0    60   ~ 0
Line out
Text Notes 8350 5400 0    60   ~ 0
Audio
$Bitmap
Pos 9300 2850
Scale 1.000000
Data
89 50 4E 47 0D 0A 1A 0A 00 00 00 0D 49 48 44 52 00 00 02 FD 00 00 01 C5 08 06 00 00 00 61 07 46 
49 00 00 00 04 73 42 49 54 08 08 08 08 7C 08 64 88 00 00 00 09 70 48 59 73 00 00 17 0C 00 00 17 
0C 01 8A 02 8E 66 00 00 20 00 49 44 41 54 78 9C EC DD 7B 78 14 E5 A1 3F F0 EF EC 7D B3 B9 91 0D 
81 84 40 42 AE 84 04 A1 80 28 D5 62 3D DA 5A 69 B5 28 58 F8 79 2A 68 5B 6A 8F F6 D8 12 45 A4 55 
AB A7 D5 2A 5E AA D5 56 A5 88 22 E2 29 3D 28 1C 6C AB 01 39 56 41 45 50 10 B9 06 12 09 90 0B B9 
42 2E 9B 64 77 E7 F2 FB 63 77 26 BB D9 64 37 1B 92 0D 64 BF 9F E7 99 67 92 D9 77 26 EF FA E0 CC 
77 DF 7D 2F 02 00 3C F6 D8 63 93 75 3A 5D 3C 88 88 88 88 88 68 58 31 18 0C 5F 09 8F 3F FE 78 BE 
24 49 47 86 BA 32 44 44 44 44 44 34 F0 04 41 38 60 10 04 C1 06 00 17 5F 7C 31 C6 8D 1B 37 D4 75 
22 22 22 22 22 A2 01 F2 F1 C7 1F A3 B6 B6 36 D6 A0 1E 18 3D 7A 34 F2 F2 F2 86 B2 4E 44 44 44 44 
44 34 80 BE FC F2 4B D4 D6 D6 42 37 D4 15 21 22 22 22 22 A2 C1 C5 D0 4F 44 44 44 44 34 CC 31 F4 
13 11 11 11 11 0D 73 0C FD 44 44 44 44 44 C3 1C 43 3F 11 11 11 11 D1 30 C7 D0 4F 44 44 44 44 34 
CC 31 F4 13 11 11 11 11 0D 73 0C FD 44 44 44 44 44 C3 1C 43 3F 11 11 11 11 D1 30 C7 D0 4F 44 44 
44 44 34 CC 31 F4 13 11 11 11 11 0D 73 0C FD 44 44 44 44 44 C3 1C 43 3F 11 11 11 11 D1 30 C7 D0 
4F 44 44 44 44 34 CC 31 F4 13 11 11 11 11 0D 73 0C FD 44 44 44 44 44 C3 1C 43 3F 11 11 11 11 D1 
30 C7 D0 4F 44 44 44 44 34 CC 31 F4 13 11 11 11 11 0D 73 86 A1 AE C0 50 39 76 EC 18 44 51 0C 38 
9E 9E 9E 8E B8 B8 B8 3E 5D A3 B5 B5 15 BB 76 ED 82 C5 62 C1 D4 A9 53 61 B5 5A 07 A4 2C 11 11 11 
11 D1 40 8A CA 96 FE 6D DB B6 21 2F 2F 0F 13 27 4E 0C D8 9E 7D F6 D9 90 E7 8B A2 88 5B 6F BD 15 
89 89 89 B8 FA EA AB 71 F9 E5 97 23 3E 3E 1E 4F 3D F5 D4 39 95 25 22 22 22 22 1A 0C 51 D9 D2 DF 
DE DE 0E 00 78 F0 C1 07 91 9B 9B EB F7 DA E5 97 5F 1E F2 FC C5 8B 17 63 CD 9A 35 58 BA 74 29 16 
2E 5C 08 97 CB 85 E2 E2 62 DC 73 CF 3D 18 39 72 24 16 2E 5C D8 AF B2 44 44 44 44 44 83 21 2A 43 
BF EA 3B DF F9 0E 66 CE 9C 19 D6 39 35 35 35 58 BB 76 2D E6 CE 9D 8B 15 2B 56 68 C7 37 6C D8 80 
F4 F4 74 AC 5C B9 52 0B F2 E1 94 25 22 22 22 22 1A 2C 51 1D FA FB 63 FD FA F5 90 24 09 0B 16 2C 
F0 3B 9E 9C 9C 8C 2B AE B8 02 5B B7 6E 45 5D 5D 1D 52 52 52 C2 2A 1B 2E 87 C3 81 33 67 CE 04 1C 
D7 E9 74 90 65 39 EC EB 11 11 11 0D 77 29 29 29 30 99 4C 43 5D 0D A2 21 11 F5 A1 5F 96 65 E8 74 
7D 1F DA 70 E4 C8 11 00 C0 B4 69 D3 02 5E 2B 28 28 C0 96 2D 5B 50 55 55 85 94 94 94 B0 CA 86 AB 
B4 B4 14 25 25 25 01 C7 47 8E 1C 89 FA FA FA B0 AF 47 44 44 34 DC 2D 5A B4 08 69 69 69 43 5D 0D 
A2 21 11 95 A1 5F 10 04 00 C0 AC 59 B3 20 8A 22 92 93 93 91 9B 9B 8B 3B EF BC 13 37 DF 7C B3 F6 
7A 4F 6A 6B 6B 01 00 89 89 89 01 AF 25 25 25 01 00 1A 1B 1B C3 2E 1B AE AC AC 2C CC 9D 3B 37 E0 
F8 B6 6D DB 30 72 E4 48 CC 9A 35 AB 5F D7 25 22 22 1A AE D4 67 2F 51 34 8A CA D0 3F 63 C6 0C FC 
FE F7 BF 47 42 42 02 14 45 C1 F1 E3 C7 F1 FA EB AF E3 87 3F FC 21 F6 ED DB E7 D7 FF BE BB B3 67 
CF 02 00 CC 66 73 C0 6B 16 8B 05 00 D0 D6 D6 16 76 D9 70 25 26 26 F6 F8 61 62 FB F6 ED B0 5A AD 
C8 CB CB EB D7 75 89 88 88 88 68 F8 89 CA D0 9F 92 92 82 FB EE BB CF EF D8 F2 E5 CB 31 79 F2 64 
3C F9 E4 93 28 2E 2E C6 E8 D1 A3 7B 3C 37 21 21 01 00 D0 D2 D2 82 98 98 18 BF D7 5C 2E 17 00 C0 
6E B7 87 5D 96 88 88 88 88 68 B0 44 E5 3C FD 3D 49 4A 4A C2 F7 BE F7 3D 28 8A 82 7D FB F6 F5 5A 
2E 39 39 19 40 57 2B BE 2F B5 3B 8F DA 47 3F 9C B2 44 44 44 44 44 83 85 A1 DF 87 D3 E9 04 D0 15 
D6 7B 92 9D 9D 0D 00 D8 BD 7B 77 C0 6B 7B F6 EC 41 42 42 02 32 33 33 C3 2E 4B 44 44 44 44 34 58 
A2 32 F4 F7 34 A5 65 63 63 23 DE 7D F7 5D C4 C5 C5 A1 A8 A8 48 3B 5E 53 53 83 03 07 0E 68 BF DF 
74 D3 4D 00 80 75 EB D6 41 51 14 ED F8 FE FD FB B1 73 E7 4E CC 9F 3F 5F EB C3 1F 4E 59 22 22 22 
22 A2 C1 12 95 7D FA 33 32 32 30 67 CE 1C 5C 76 D9 65 48 4C 4C 44 59 59 19 FE F8 C7 3F A2 A6 A6 
06 AF BD F6 9A 5F 10 9F 35 6B 16 CA CA CA 50 51 51 81 8C 8C 0C E4 E4 E4 60 CE 9C 39 D8 B4 69 13 
6E B9 E5 16 CC 9B 37 0F 0D 0D 0D 78 F8 E1 87 61 B7 DB 51 5C 5C AC 9D 1B 4E 59 22 22 A2 E1 C0 B7 
91 6B A0 04 9B 55 8F 88 FA 26 2A 43 FF 82 05 0B B0 7A F5 6A 3C FF FC F3 00 3C 37 93 49 93 26 61 
F3 E6 CD B8 EE BA EB FC CA DA ED 76 54 57 57 23 36 36 56 3B B6 7E FD 7A DC 7E FB ED 78 EB AD B7 
B0 6E DD 3A 98 4C 26 4C 9F 3E 1D AB 56 AD 42 7E 7E BE DF F9 E1 94 25 22 22 BA 50 A9 61 BF B9 F4 
08 4E 97 94 40 81 72 4E 1F 00 D4 A0 9F 3C E3 12 24 5F 3A D3 EF 18 11 85 2F 2A 43 FF 13 4F 3C 81 
15 2B 56 E0 D4 A9 53 70 38 1C C8 C8 C8 08 98 5D 47 F5 C9 27 9F C0 ED 76 FB AD E0 67 32 99 F0 CA 
2B AF 60 F5 EA D5 38 7E FC 38 C6 8C 19 D3 6B 37 9D 70 CA 5E 48 D4 1B B9 A3 53 C4 DF B6 57 E0 DA 
E9 63 30 7A 84 15 00 6F CA 44 44 D1 46 51 14 6D AB 7D FF 7D D4 6C 2D 81 61 00 56 BE 95 DC 6E 38 
EB EA 90 34 E3 12 ED D9 C2 67 0C 51 FF 44 65 E8 07 3C 37 8D 71 E3 C6 F5 A9 5C 6F 4B 76 0B 82 80 
AC AC AC 3E FF BD BE 96 3D 9F A9 61 5F 51 14 B4 75 B8 F1 E0 EB FB 70 AC BA 05 1F EC AF C5 A3 8B 
A6 20 35 A9 EB C3 13 6F CC 44 44 C3 9F 1A F6 65 59 D6 36 41 10 30 F3 CA AB 3C 05 04 00 8A 77 0F 
40 80 00 05 0A 04 F4 FC 8C 50 14 05 82 20 40 51 14 EC F9 F8 23 48 92 04 51 14 A1 D7 EB A1 D3 79 
86 22 F2 F9 42 14 BE A8 1C C8 4B FD A3 06 7E 59 96 D1 E2 70 E2 C1 D7 F7 A1 EC 74 2B B2 C7 8E 43 
73 87 88 E5 AF EE 45 75 A3 03 B2 2C 6B 0F 01 22 22 1A FE D4 D0 EF 76 BB 21 49 92 E7 98 2C 41 91 
25 C8 62 D7 5E 16 25 48 A2 A8 ED 7B DA 14 59 D2 F6 00 FC AE CB E7 0A 51 FF 31 F4 53 9F 74 0F FC 
BF 59 F7 25 CA 4E B7 A2 30 3B 1F D9 E3 32 F1 B5 09 85 68 E9 94 F0 AB 35 5F 30 F8 13 11 45 09 DF 
6E 3D 92 24 C1 ED 76 43 14 45 00 80 E4 72 41 72 B9 20 BB BB F6 B2 DB 05 D9 E5 B3 77 75 3B E6 76 
41 74 76 ED D5 0F 13 2E 97 0B 92 24 F1 D9 42 74 0E 18 FA 29 24 DF AF 6E 9B DB 3A F1 D0 1B FB 51 
5E DB 86 FC CC 5C 8C 4C B2 C3 25 4A 88 89 89 45 51 6E 01 5A 3A 25 FC FA B5 7D 0C FE 44 44 51 44 
96 65 48 92 A4 85 73 00 90 45 D1 BB 49 3E 7B 09 B2 EC B3 97 BD AF A9 7B 6F 0B BF BA 87 CF 37 08 
A2 28 F2 99 42 74 0E 18 FA 29 28 DF 56 9C E6 B6 4E 3C FC DF 07 50 5E DB 86 DC 8C 1C 8C B4 DB 21 
CA 32 24 EF 16 6B 8B C5 C4 EC 7C B4 74 4A B8 7F ED 97 0C FE 44 44 51 C0 B7 61 48 92 24 2D F4 4B 
6E B7 67 73 39 BB F6 2E A7 F7 1B 00 A7 F6 4D 80 E7 35 57 57 79 A7 53 DB AB D7 15 45 51 1B 2F 40 
44 FD C3 D0 4F BD EA 31 F0 9F 6E C3 F8 F4 F1 18 91 90 08 97 28 C1 E5 16 3D 7B EF 66 B1 DA 90 9B 
99 8B 96 0E 06 7F 22 A2 68 A2 86 7E F5 5E DF 97 50 DF E3 E6 53 06 3E 5D 87 D4 C0 CF 67 09 51 FF 
30 F4 53 8F BA 07 FE 87 BC 81 7F DC 98 4C 24 24 8C 80 4B 92 3D 81 5F DD FB 6C 66 B3 15 E3 C7 65 
A1 99 C1 9F 88 28 2A A8 F7 77 77 53 13 A4 C6 06 00 BE DD 7B BA 6D 92 D4 B5 97 BC 5D 7C A4 AE EE 
3E 8A D4 B5 F7 4C FB E3 3F 73 1C 11 F5 4F D4 4E D9 49 BD EB 29 F0 7F 75 BA 0D E9 A9 E3 90 10 9F 
08 49 F2 B6 B6 78 A7 5C 53 BC 37 65 DF 69 D8 2C 16 1B 32 D2 C7 A3 E2 D4 57 58 BE 66 1F 7E BF 68 
32 D2 EC 36 4E B7 46 44 34 4C 88 6D 6D 68 39 76 14 CD A5 47 D0 5C 7A 04 6D 47 8F C1 DD 7C 16 EA 
D3 40 72 BB 00 F4 34 45 A7 3A 7F A7 1A E4 01 41 F0 EC BB F3 0D FB 0C FC 44 E7 86 A1 9F FC F8 DE 
60 5B 1C 4E 2D F0 8F 1E 35 16 B6 D8 04 B8 44 29 D8 D9 F0 BD 91 1B 8C 16 A4 A7 65 E0 54 D5 09 FC 
FC C5 CF 31 AB 68 24 AE BC 68 34 26 65 26 C1 68 D0 31 F8 13 11 5D 20 64 B7 1B 6D 5F 95 A3 E5 E8 
51 B4 1E 3D 8A 96 A3 A5 E8 A8 AE 0A 1A C4 15 75 EA 4E EF A3 41 2D EA FF A4 F0 04 7E D9 1B FC BD 
47 BA 4A 31 E7 13 0D 18 86 7E 0A A0 F6 CB DC FC E9 29 94 D7 B4 22 31 D1 8E D8 D8 78 88 92 DC AD 
35 C6 FF D6 ED 59 4C 45 F6 0B F3 26 73 0C 92 93 47 A1 AE AE 1A EF EF AF C3 FB 5F D6 C2 62 D2 63 
6A 76 12 2E 99 90 82 E9 B9 76 24 DA CE 7D D5 46 22 A2 0B C1 60 B4 56 0F 78 03 8A A2 A0 BD F2 14 
5A BC E1 BE A5 B4 14 8E 8A E3 90 BD 53 71 F6 95 E4 72 79 AF 87 6E 29 DF E7 58 A8 D7 D9 BA 4F 34 
60 18 FA 49 D3 7D BE E5 6F 16 DA F1 C1 81 3A D4 B7 9C 81 C9 14 03 8B D5 A6 AD 92 08 04 7E 65 DB 
BD BB 0F 20 C0 ED EA 44 43 43 AD A7 8C E2 79 A5 D3 25 E1 E3 C3 F5 F8 F8 70 3D 04 41 40 7E 7A 3C 
66 E4 8D C4 C5 79 C9 C8 1A 1D 3B 34 6F 9E 88 68 10 A9 F7 CD E6 D2 23 38 5D 52 02 05 E7 D6 5D 45 
0D FA C9 33 2E 41 F2 A5 33 FD 8E 85 CB D9 D0 80 96 A3 A5 68 3D 5A EA 69 C9 2F 3B 06 B1 BD BD DF 
75 53 89 4E A7 56 2F 75 95 5D C0 7F C5 DD 50 AF B3 4B 0F D1 C0 61 E8 27 3F BE D3 AE C5 18 15 FC 
E2 9A 54 3C FD CF 4A 34 34 54 21 71 C4 68 98 2C B6 AE 90 DF ED C6 DD BD F5 46 74 3B D1 D4 50 E5 
59 92 DD E7 A3 40 F7 BF 77 E4 54 33 8E 9C 6A C6 6B DB CA 90 9C 60 C1 8C BC 64 5C 92 3F 12 93 C7 
8F 80 D1 C0 B1 E6 44 74 61 F3 6D 50 A9 7D FF 7D D4 6C 2D 81 C1 74 EE DF 70 4A 6E 37 9C 75 75 48 
9A 71 89 16 98 43 05 7F B1 AD 0D AD C7 8E A2 E5 98 A7 15 BF B5 F4 28 9C 67 9A CE B9 2E 3D D1 BA 
F7 A8 BF 6B AF A8 4F 04 41 FD 55 EB 02 14 58 9E A1 9F 68 A0 30 F4 53 00 B5 A5 5F 14 45 58 0D 32 
6E 9B 69 C3 AA 1D 2D 38 D3 54 83 F8 C4 51 30 59 6C 3E 85 BB 7E 14 14 6F CB BF 22 40 74 3B 71 B6 
B1 1A B2 D2 7B E0 EF 49 43 73 27 FE B9 BB 12 FF DC 5D 09 8B 49 8F 29 59 49 B8 38 2F 19 33 F2 46 
22 29 8E DD 80 88 E8 C2 E2 3B 87 BD BA 09 82 80 99 57 5E E5 29 D0 AD B1 24 70 D0 6B E0 F5 D4 C6 
96 3D 1F 7F A4 DD AB F5 7A 7D C0 44 09 FE FD F0 4B BD FD F0 AB 23 D6 7A 2E B9 DD 6A AD 11 B4 7F 
4F 90 91 BC 6C E9 27 1A 38 0C FD 14 C0 77 30 AF 2C CB 88 31 2A 98 3F 59 C0 5F BF 90 D1 7C B6 16 
31 71 23 61 30 C5 F4 DA 2F 53 72 BB E0 68 AE F5 F4 EF 0F 23 F0 77 D7 E9 92 B0 F3 48 3D 76 1E A9 
07 70 18 39 69 F1 B8 24 DF F3 01 20 27 2D EE 9C DF 27 11 51 24 A8 F7 52 B7 DB AD 2D 5C A5 C8 5D 
83 5C 7B 9B B9 A6 27 DD 07 BD AA D7 85 A2 A0 A3 A6 06 6D E5 65 9E 96 FC 7E F6 C3 1F 48 5D 03 79 
BB 7D 2B DC 8D FA FE 85 9E 3E 03 30 F3 13 0D 18 86 7E 0A 20 08 02 04 41 80 4E A7 83 5E AF 87 C1 
60 40 BC 55 8F 1B 27 BA F0 E6 41 1D 5A 5A EB 61 89 4D 86 DE 68 ED 7E 26 64 C9 89 8E D6 FA 73 0E 
FC 3D 29 AB 6E 41 59 75 0B D6 BD FF 15 92 E2 CC 9E 6F 00 F2 93 F1 B5 2C 3B CC 46 76 03 22 A2 F3 
4B F7 71 52 6E B7 1B A2 37 84 6B 83 5C 03 4E 42 9F 1B C5 15 59 86 AB F6 34 0E 3F FC 20 3A 2A 2A 
20 75 74 0C EE 1B EA 03 63 72 32 64 08 90 1B 1B 7C FA F4 07 09 F5 21 5E 67 4B 3F D1 C0 61 E8 27 
3F DD C3 BE C9 64 82 D9 6C 86 CB E5 42 A2 4D C4 0D 05 4E 6C 3C 0C B4 B4 D5 C3 60 B5 43 30 58 B4 
73 15 49 84 D4 D1 00 93 4E C6 77 F2 5C 68 97 8C 38 D9 6C C0 F1 26 09 2E 71 60 6F DC 4D AD 4E 94 
7C 5E 85 92 CF AB 60 34 E8 30 79 7C 12 66 E4 27 63 46 5E 32 46 26 58 42 5F 80 88 28 42 D4 71 52 
2E 97 4B 6B E9 EF 6A 81 0F E8 DF D3 ED 1B D4 C0 84 AC 78 8F 29 8A 02 77 63 13 DC 8D 8D 11 7B 2F 
BE 4C 09 09 88 CD C9 45 5C 6E 1E 62 B2 B2 A0 4F 1F 8B 0E 00 D5 AF AF 45 E7 27 0D 90 BD F3 F4 07 
8E FF EA 9E F2 E1 F7 41 C7 EF 65 41 1F E1 77 45 34 7C 31 F4 93 C6 77 20 98 5E AF 87 C9 64 82 24 
49 DA 26 CB 32 46 28 0A 6E 28 70 61 E3 61 03 5A 3A 1A A1 18 13 01 83 05 90 DD 10 9C 67 60 D2 2B 
98 33 C1 89 D4 44 23 62 62 AC F8 A6 CD 06 8B D5 86 53 CD C0 C1 CA 0E 7C 71 BC 19 F5 2D CE 01 AD 
B7 5B 94 F1 D9 B1 06 7C 76 AC 01 7F 06 30 7E 74 1C 66 78 BF 05 C8 1F 93 80 10 E3 DA 7A A5 3E A0 
1C 9D 22 FE B6 BD 02 D7 4E 1F 83 D1 23 3C DF 6E 70 8D 01 22 EA 0B DF 3E FD EA BD 14 F0 E9 EF 1E 
AA D9 3B F0 82 5A 99 48 B6 82 EB 2D 16 C4 65 E7 20 3E 2F 0F 71 79 F9 88 CF CD 83 65 F4 68 BF AE 
4B 1D 1D 1D 40 6B AB 76 8E AC AE EB D2 6D A0 6E 28 7E F3 FA F3 5B 5C A2 01 C3 D0 4F 01 D4 96 7E 
A3 D1 08 59 96 FD BE A2 56 69 C1 DF 79 16 92 1C 0B BD D4 EE 17 F8 AD 56 2B 62 62 62 60 B3 D9 60 
B3 D9 30 3D C5 8A CB 8A CC 30 1A 8D A8 6C EC C0 AE A3 8D D8 7D B4 11 A5 55 CD 90 E5 81 7D 70 1D 
3F DD 8A E3 A7 5B B1 FE C3 E3 48 B0 99 BC 03 81 93 31 35 DB 0E AB 39 74 AB 91 EF 98 86 B6 0E 37 
1E 7C 7D 1F 8E 55 B7 E0 83 FD B5 78 74 D1 14 A4 26 C5 68 65 19 FE 89 A8 2F D4 D0 AF DE 5F 7A EF 
DE 13 A2 93 BF EF 87 82 41 0A FD 82 5E 0F 5B 46 06 E2 73 F3 10 9F 3F 01 F1 79 79 B0 8D CB 00 74 
7D 0F E0 8A A2 A0 DE 70 EE 11 43 01 83 0A D1 40 E1 FF 4B 00 1C 0E 07 0E 1D 3A 84 D8 D8 58 14 14 
14 84 2C 7F E6 CC 19 9C 3E 7D 3A E0 B8 C5 62 C1 F8 F1 E3 7B 3C A7 B5 B5 15 BB 76 ED 82 C5 62 C1 
D4 A9 53 61 B5 76 EF 0F 7F 7E 50 43 AC 5E EF 09 C7 BE 01 B8 7B 39 4F 57 1F 03 9A 3B DB 60 32 00 
73 26 B8 BC 2D FC 31 88 89 89 41 6C 6C 2C 62 62 62 60 B5 5A 61 32 99 60 30 18 A0 D3 E9 90 39 2A 
0E E3 47 C7 63 FE AC F1 68 69 77 63 F7 D1 06 EC 3A DA 80 3D E5 8D 68 EF 1C D8 41 67 CD 0E 17 DE 
DB 5B 8D F7 F6 56 C3 A0 D7 61 52 E6 08 ED 5B 00 B5 D5 DE 97 FA 3E 65 59 46 6B BB 0B 0F BD B1 1F 
65 A7 5B 91 3D 76 1C 4E 9E AE C6 F2 57 F7 6A C1 BF AF 53 E4 11 51 74 F3 6D 38 D1 EE 31 7D 1D 60 
1B 74 76 9F 81 09 FD D6 D1 A3 11 9F 97 EF 69 C1 CF CB 43 5C 76 0E 74 66 73 D8 D7 51 C7 83 99 0B 
0B E1 6C A8 83 24 4A DA 07 9D 70 BE 95 F0 1D 57 66 30 18 60 9E 3C 45 3B 46 44 FD C7 D0 0F 60 F6 
EC D9 F8 F0 C3 0F 01 00 75 75 75 18 39 72 64 D0 F2 D7 5F 7F 3D 76 EC D8 11 70 DC 60 30 C0 E5 72 
F9 DD 98 44 51 C4 4F 7E F2 13 AC 5D BB 16 B2 2C 6B E5 1E 7B EC 31 DC 7D F7 DD 03 F8 2E 06 8E 5A 
7F 9D 4E 07 A3 D1 D8 6B 19 41 10 30 AF C8 8D 8F 4F C8 98 92 2A 23 35 D1 0C 8B C5 A2 B5 EE FB 06 
7E A3 D1 A8 4D 29 E7 FB DF 27 3E C6 88 AB A6 A4 E2 AA 29 A9 90 64 05 07 4E 9C C5 A7 A5 F5 D8 7D 
B4 01 D5 8D E7 BE 38 8C 2F 51 92 B1 B7 BC 11 7B CB 1B F1 D2 3B A5 18 37 D2 86 19 F9 23 31 23 3F 
19 05 63 13 21 A0 2B F0 B7 38 9C 78 E8 8D FD 28 AF 6D 43 61 76 3E D2 52 52 60 4F 1C 81 BD 47 0E 
E2 57 6B BE C0 23 0B 27 23 35 29 26 60 8A 3C 22 A2 DE F8 06 5F C9 DB DF 3D 70 8A 4E FF 0E EE C1 
1A F5 FB D3 BD C7 94 90 A0 75 CF 51 BB EA 18 E3 E3 C3 BE 4E 77 BE 41 DD 92 97 0F D7 E8 54 38 1C 
0E B8 3B 3B 21 8A A2 F6 AD 71 5F AF 63 30 18 60 36 9B 61 B2 D9 60 8D 8B D3 9E 1D BC D7 12 F5 5F 
D4 87 FE 37 DE 78 03 1F 7E F8 21 F2 F3 F3 51 5A 5A DA A7 9B 52 7B 7B 3B 26 4D 9A 84 7B EF BD D7 
EF 78 7C 7C 7C C0 0D 69 F1 E2 C5 58 B3 66 0D 96 2E 5D 8A 85 0B 17 C2 E5 72 A1 B8 B8 18 F7 DC 73 
0F 46 8E 1C 89 85 0B 17 0E E8 FB 19 28 EA CD 1B 40 8F C1 BF AB 15 C6 89 EF 16 4A D0 E9 74 30 99 
4C 5A 2B BF 1A F8 CD 66 B3 5F E0 0F 46 AF 13 30 79 FC 08 4C 1E 3F 02 3F FD 4E 1E 2A 1B DA B5 0F 
00 87 4E 35 43 92 E4 01 7D 8F 27 EB 1D 38 59 EF C0 86 1D 15 88 B5 18 30 2D D7 8E 8B 73 93 91 93 
6A C3 93 6F 1D 46 79 6D 1B F2 33 73 31 32 C9 0E 97 28 21 26 26 16 45 B9 05 38 70 EC 30 7E FD DA 
3E FC EE 96 8B 90 66 B7 31 F8 13 51 D8 BA A6 B3 44 57 FF 75 F4 30 79 4F B7 29 3A FD 9A FE 43 3C 
AE 02 FA E1 E7 E5 C3 32 6A D4 00 BF 93 AE A0 AE 8E 07 33 1A 8D 30 99 4C DA 4C 45 A2 28 F6 B9 B5 
5F BD 8F AA 13 49 F4 D4 68 C4 7B 2D 51 FF 44 75 E8 6F 6B 6B C3 D2 A5 4B F1 83 1F FC 00 71 71 71 
28 2D 2D ED F3 B9 A9 A9 A9 F8 E1 0F 7F 18 B4 4C 4D 4D 0D D6 AE 5D 8B B9 73 E7 62 C5 8A 15 DA F1 
0D 1B 36 20 3D 3D 1D 2B 57 AE EC 77 E8 77 38 1C 38 73 E6 4C C0 71 B7 DB 0D 41 10 50 59 59 D9 AF 
EB 76 A7 0E D2 52 14 05 6E B7 1B 6E B7 1B 4E A7 13 1D 1D 1D E8 EC EC 84 D3 E9 D4 66 66 50 5B 73 
44 51 84 CB E5 82 C3 E1 80 D1 68 84 4E A7 EB 77 30 BE 24 43 8F 4B 32 46 C1 E1 4C C6 C1 53 6D D8 
7F CA 81 83 A7 1C 70 38 A5 01 79 7F AA B6 4E 11 1F EC AF C5 07 FB 6B 3D B3 4C 08 40 5E 46 0E 46 
DA ED 10 E5 AE 0F 1B B1 B6 58 4C CC CE C7 C1 B2 23 58 FE EA 5E FC F2 DA 34 8C 8C 37 F1 61 44 44 
01 D4 FB A7 28 8A E8 EC EC 44 5B 5B 1B DA DB DB A1 83 4F 9F FE 10 53 74 06 7D DD 37 44 EB 74 30 
A6 A6 C2 92 39 1E D6 F1 59 B0 66 8E 87 29 2D 4D EB 87 EF 02 D0 E0 76 03 03 F4 6C F0 7D 8F EA FB 
74 B9 5C E8 EC EC 44 47 47 07 3A 3A 3A E0 74 3A B5 B5 09 64 B9 EF 8D 36 EA 87 07 97 CB 05 51 14 
E1 76 BB D1 D9 D9 89 D6 D6 56 98 4C 26 ED 99 D2 9F FB 6D 4A 4A 0A 4C 03 B0 1A 32 D1 85 28 AA 43 
FF 6F 7F FB 5B 34 37 37 E3 C9 27 9F C4 C3 0F 3F 3C E0 D7 5F BF 7E 3D 24 49 C2 82 05 0B FC 8E 27 
27 27 E3 8A 2B AE C0 D6 AD 5B 51 57 57 87 94 94 94 B0 AF 5D 5A 5A 8A 92 92 92 80 E3 46 A3 11 6E 
B7 1B 6B D7 AE ED 77 BD BB F3 ED 8B AA 0E 46 13 45 11 A2 28 6A FD 35 D5 9B B4 3A D5 A7 DA 7F DF 
37 08 0F 44 20 36 01 98 22 08 68 31 C5 E2 8C 9C 88 26 39 11 ED F2 C0 4D D1 E9 99 56 0E C8 1A 3B 
1E 23 12 12 E1 12 A5 80 99 34 2C 56 1B F2 C6 E7 A1 B4 BC 14 8F BE 59 86 42 C3 41 58 75 AE 01 7D 
9F 44 74 E1 F3 BD 6F AA 0D 26 17 7F 55 86 64 45 F1 99 C3 5E D0 EE A1 EA 39 BE D3 5B 06 7B 5D 51 
14 38 8C 46 EC 1F 93 0E 67 42 22 74 66 33 F4 32 20 7C 75 1C C2 F1 8A 21 79 9F BE EB 11 A8 61 3F 
DC 3E FD 00 7A 7C A6 A8 BF 9F 4B 03 CB A2 45 8B 90 96 96 D6 AF 73 89 2E 74 51 1B FA 4B 4B 4B F1 
87 3F FC 01 0F 3D F4 10 C6 8E 1D DB AF 6B F8 DE 94 7B 72 E4 C8 11 00 C0 B4 69 D3 02 5E 2B 28 28 
C0 96 2D 5B 50 55 55 D5 AF D0 9F 95 95 85 B9 73 E7 06 1C DF B6 6D 1B 8C 46 23 66 CD 9A 15 F6 35 
83 F1 6D F1 57 03 BF BA F9 86 7E F5 E6 AC 86 FE 48 74 7D 69 6C 13 71 B0 B2 03 07 AB 3A 50 5E E7 
84 D4 DF D9 80 BC 81 3F 23 3D 13 09 09 23 E0 92 E4 5E 3B D4 9A CD 56 64 67 E6 A0 FC 44 39 BE 32 
4E C7 CF AE 4C C2 C8 78 93 DF D7 DC 44 14 DD FC 5A FA 4F D7 A0 ED CD 0D 80 77 01 2D AD 7B 8F 5A 
56 3B 4B 5D D6 B0 6B DE 7E DF E9 2E FD CB 2B B0 A4 8C C2 A5 73 E7 C1 66 B3 C1 62 B1 68 DF AE 46 
F2 1E E4 1B FA BB 3F 1F FA 1B FA D5 E7 47 6F CF 95 FE BE BF A4 A4 A4 7E 9D 47 34 1C 44 6D E8 BF 
EB AE BB 90 91 91 D1 AF C1 B4 82 20 60 DB B6 6D DA CD 28 33 33 13 DF F8 C6 37 F0 9B DF FC 06 E3 
C6 8D D3 CA D5 D6 D6 02 00 12 13 13 03 AE A1 DE 78 1A FB B9 A8 4A 62 62 62 8F D7 DD BE 7D 3B AC 
56 2B F2 F2 F2 FA 75 DD 60 D4 9B BA BA 75 1F 9C A5 B6 C2 A8 7D 2F 23 D9 D7 7D E6 54 CF BE C3 29 
E1 F3 B2 46 EC 3A EA 99 B7 BF D9 D1 CB B4 78 DD 09 9E FE B1 63 D3 C6 21 21 3E 51 1B 3F A0 0E B0 
53 D7 16 F6 1D 74 67 B1 D8 90 39 36 0B 27 2A 8F 63 D5 F6 16 BF 3E FE 0C FE 44 A4 DE 33 4F 6D DE 
84 A6 D7 D7 02 4E 27 D4 F4 AE CD D3 1F CE 12 BC 3D B0 58 2C 48 1F 3F 1E 71 71 71 88 89 89 D1 FA 
BF 47 FA FE E3 FB 7C F0 5D DB 45 ED D6 D3 9F 96 7E DF E0 EF BB 57 5F 27 A2 F0 44 65 E8 DF B8 71 
23 B6 6C D9 82 7F FC E3 1F 30 F7 63 5A B2 E5 CB 97 E3 E4 C9 93 88 8D 8D 45 53 53 13 B6 6F DF 8E 
57 5E 79 05 9B 36 6D C2 BE 7D FB 90 9E 9E 0E 00 38 7B F6 2C 00 F4 F8 37 2C 16 4F 97 94 B6 B6 B6 
73 78 27 91 A5 DE 84 7D 6F C6 BE FD 34 7D 5F 1B AA AE 2E 56 B3 1E 97 17 A6 E0 F2 C2 14 28 0A 70 
A4 B2 19 BB 8E 36 60 57 69 3D 2A 6A 7B F9 6F ED 0D FC A9 A3 C7 C2 16 9B E0 E9 D2 D3 2B FF 07 B4 
C1 68 C1 98 D4 71 A8 AA 39 89 FB D7 7E C9 C1 BD 44 A4 E9 3C 5D 83 23 CF 3E 83 B3 07 F6 07 BC D6 
35 90 B7 DB 6A B5 DD 04 2C 5E EB FB 19 20 72 6B 73 F5 89 6F 83 87 5E AF 0F 68 E1 EF 6B F0 F7 7D 
7E F8 6E BC AF 12 9D 9B A8 0B FD 1D 1D 1D 28 2E 2E C6 75 D7 5D 87 D9 B3 67 F7 EB 1A DD BB D5 2C 
5B B6 0C 2B 56 AC C0 B2 65 CB F0 C8 23 8F E0 85 17 5E 00 00 24 24 24 00 00 5A 5A 5A 10 13 13 E3 
77 8E CB 3B 88 CB 6E B7 F7 AB 0E 43 A5 FB CD D8 77 46 9E EE AF 0D 35 41 00 0A C6 26 A0 60 6C 02 
16 5D 95 8D BA E6 4E EC 2E 6D C0 A7 A5 F5 D8 77 BC 09 A2 A4 78 1F 9E 0A 12 13 ED 88 8D 8D 87 28 
C9 DD 1A D5 FC 43 BE E7 E1 2C FB BD 3F 93 39 06 49 49 29 A8 AB AB C6 9A 6D 5F 61 D9 BC C2 F3 E6 
BF 01 11 0D 8D AA BF BF 8D B2 57 5E 86 EC EC 79 05 F2 AE 3E FD 41 42 7D 88 D7 23 B9 22 6F 28 BE 
63 0F D4 C0 0F 9C 5B 1D 7D EF A1 1C 33 45 74 EE A2 2E F4 AF 59 B3 06 15 15 15 B8 E6 9A 6B F0 F8 
E3 8F 6B C7 BF FC F2 4B 00 C0 73 CF 3D 87 AC AC 2C DC 76 DB 6D 61 5D 77 D1 A2 45 58 B6 6C 19 BE 
F8 E2 0B ED 58 72 72 32 00 4F 8B FF E8 D1 A3 FD CA AB 5D 7F FA D3 9F 7F A8 F5 74 23 EE ED F7 F3 
49 4A 82 05 B3 2F 1E 83 6B A7 A7 A1 C3 29 E2 B3 A3 75 D8 71 A8 1E 3B 8F 36 A1 B9 B9 09 26 53 0C 
2C 56 9B FF 20 BA 6E 73 68 77 EF EE 03 08 70 BB 3A D1 D8 58 07 9B D9 80 EB A7 A7 40 14 C5 01 1F 
C0 4C 44 17 86 CE D3 35 38 FC CC 1F 7A 6C DD F7 25 7B E7 E9 0F 68 E9 0F 48 F9 F0 EB FD E3 F7 B2 
10 7A 85 F1 48 EA E9 5E 37 10 F7 3F DE 43 89 06 46 D4 85 FE F6 F6 76 18 8D 46 AC 5E BD DA EF B8 
E4 FD AA F5 B1 C7 1E 43 66 66 66 D8 A1 DF E9 6D B5 51 83 3E 00 64 67 67 03 00 76 EF DE 8D 09 13 
26 F8 95 DF B3 67 0F 12 12 12 90 99 99 19 EE 5B 38 6F 5C A8 37 62 45 51 60 D4 03 D3 B2 13 31 31 
CD 8C EF 4D 8E C3 8A BF 9F 42 7D 7D 25 46 24 A5 C2 64 B1 75 85 FC 80 07 32 FC BA DB 8A 6E 27 9A 
1A AA A0 28 0A 7E 70 49 32 46 27 18 20 8A 62 8F 0B 91 11 D1 F0 56 F5 F7 B7 51 FE EA 6A 48 9D 9D 
21 CB CA 6A 37 C2 6E 03 75 43 F1 9B D7 DF 18 7C ED 93 A1 C4 7B 1F D1 F9 E7 FC BD 63 0C 92 E2 E2 
62 B8 5C AE 80 4D 0D F9 55 55 55 38 76 EC 98 56 BE A6 A6 06 07 0E 1C D0 7E EF 6D AE E1 75 EB D6 
01 00 66 CE 9C A9 1D BB E9 A6 9B B4 D7 7C BF E2 DC BF 7F 3F 76 EE DC 89 F9 F3 E7 F7 6B 4C 01 9D 
3B 45 51 B4 A9 47 AD 06 19 8B 2F 8B 45 A2 15 38 D3 54 83 8E F6 56 88 B2 04 51 96 20 29 B2 B6 97 
14 19 B2 AC 68 7B 97 B3 13 4D F5 55 9E 7F 13 8A 8C D7 3F AA C7 C7 47 9A FA 3D 5B 05 11 5D 98 3A 
4F D7 60 EF 7D F7 E2 E8 8B 7F EE 53 E0 57 00 D4 EB F5 DE CD 80 7A 83 C1 B3 EF CB 66 E8 DA 8B 83 
FF D6 88 68 18 89 BA 96 FE 70 CD 9A 35 0B 65 65 65 A8 A8 A8 40 46 46 06 9E 79 E6 19 BC F9 E6 9B 
98 3F 7F 3E 72 72 72 E0 70 38 50 52 52 82 57 5F 7D 15 85 85 85 58 B2 64 89 76 6E 4E 4E 0E E6 CC 
99 83 4D 9B 36 E1 96 5B 6E C1 BC 79 F3 D0 D0 D0 80 87 1F 7E 18 76 BB 1D C5 C5 C5 43 F8 CE A2 9B 
6F 7F 53 59 96 11 63 54 30 7F B2 80 BF 7E 21 A3 F9 6C 2D 62 E2 46 C2 60 8A E9 75 A1 1C C9 ED 82 
A3 B9 D6 D3 BF DF DB D9 C7 2D 29 58 F5 7F 55 A8 6B 95 B0 F0 AA 6C ED FA 6C F1 22 1A BE C2 69 DD 
F7 50 00 01 90 E3 E2 21 26 8E 80 12 64 10 6F 4F 7C C7 53 19 0C 06 98 27 4F E1 18 22 22 EA 13 86 
7E 2F 83 C1 A0 0D 40 F2 65 B7 DB 51 5D 5D 8D D8 D8 58 00 C0 95 57 5E 89 F5 EB D7 63 C9 92 25 5A 
AB BF CD 66 C3 CF 7E F6 33 3C F4 D0 43 B0 5A AD 7E E7 AF 5F BF 1E B7 DF 7E 3B DE 7A EB 2D AC 5B 
B7 0E 26 93 09 D3 A7 4F C7 AA 55 AB 90 9F 9F 1F 99 37 47 01 7C 1F 9C EA D4 AB F1 56 3D 6E 9C E8 
C2 9B 07 75 68 69 AD 87 25 36 19 7A A3 B5 FB 99 90 25 27 3A 5A EA FD 02 BF AF CD BB 4F E3 F4 59 
37 EE 99 5B 88 18 CB F9 D5 E7 96 88 06 46 5F FB EE 77 A7 8B 8F 87 F1 BB D7 A1 33 35 0D EE CE CE 
80 A9 8F 83 51 EF 5B 06 83 01 66 B3 19 26 9B 0D D6 B8 38 4E 13 4C 44 7D 22 AC 58 B1 62 AA 28 8A 
9F 5F 77 DD 75 28 2A 2A 1A EA FA 0C 19 59 96 E1 74 3A 03 42 BB A2 28 70 BB DD 01 CB 76 B7 B6 B6 
A2 B2 B2 12 F1 F1 F1 48 4B 4B 0B 79 B3 55 14 05 C7 8F 1F C7 98 31 63 06 B5 4B CF CB 2F BF 0C AB 
D5 8A 9B 6F BE 79 D0 FE C6 85 4C ED 76 23 49 12 5C 2E 17 3A 3A 3A E0 70 38 D0 D6 D6 86 D6 D6 56 
38 1C 0E 34 B5 3A B1 F1 B0 01 2D 4E 1D 0C 56 3B 04 43 D7 8A BF 8A 24 42 6C 6F E8 35 F0 FB CA 48 
B1 E1 37 37 4F C1 A8 11 DD 3F 38 10 D1 85 2C FC D6 7D 8F 84 AF 5F 86 D8 EB BE 0F 87 28 A2 BD BD 
1D 4E A7 53 5B E0 B0 AF A1 1F F0 34 52 99 4C 26 C4 C4 C4 20 36 36 16 71 71 71 DA E2 5C BE AB A1 
13 11 01 C0 86 0D 1B 50 5E 5E 5E C1 96 7E 2F 9D 4E 17 10 F8 01 CF 4D B6 7B E0 07 80 B8 B8 38 14 
14 14 F4 F9 FA 82 20 20 2B 2B EB 9C EA 48 E7 CE 77 46 1D BD 5E 0F 93 C9 A4 2D 24 A3 2E 26 33 42 
51 70 43 81 CB 13 FC 3B 1A A1 18 13 01 83 05 90 DD 10 9C 67 00 28 21 03 3F 00 9C A8 73 E0 97 2B 
77 E1 D7 0B 26 A3 28 23 70 21 35 22 BA B0 F4 B7 75 DF 94 94 84 CC 9F FE 0C E6 09 05 68 6F 6F 87 
DC DE 0E 41 10 60 34 1A B5 FB 4E 5F A9 F7 2E A3 D1 08 8B C5 02 B3 D9 3C 64 0B 72 11 D1 85 85 A1 
9F A2 92 DA AD C7 68 34 FA 0D BC F5 6D 6D D3 82 BF F3 2C 24 39 16 7A A9 1D 26 BD 82 6B 72 5C F8 
B4 D2 88 DE D6 FA F2 D5 D2 EE C6 AF D7 EC C1 1D DF 9D 80 6B A6 A5 0D E2 3B 22 A2 C1 D4 DF D6 FD 
51 FF 76 15 B2 7E BC 18 30 9B E1 72 B9 B4 80 6F 30 18 FC BA F6 84 D3 D2 AF F6 E7 37 99 4C B0 58 
2C 30 99 4C 7E 33 86 31 FC 13 51 4F 18 FA 29 EA A8 0F 44 75 FC 46 6F 8B C8 08 82 80 1B 0A 3C 5D 
7D 9A 3B DB 60 32 00 73 26 B8 90 9A 68 C4 84 74 2B DE 3D 22 E3 CB CA 9E 17 DE F1 25 4A 32 FE B8 
F9 10 4E D4 B5 E1 27 DF C9 83 8E CF 63 A2 0B 46 7F 5B F7 CD 76 3B F2 FF F3 17 48 9A 36 5D EB 52 
68 34 1A 01 78 EE 3D 66 B3 19 92 24 F5 6B A6 2F 75 45 74 83 C1 00 A3 D1 E8 D7 D2 CF C0 4F 44 BD 
61 E8 A7 A8 E4 DB 62 A6 3E 88 7B 2A 23 08 02 E6 15 B9 F1 F1 09 19 53 52 65 A4 26 9A 61 B1 58 60 
B3 D9 F0 A3 6F DA F0 7E 69 3B FE 77 77 7D 9F FE E6 FF EE 3C 89 93 F5 0E DC F7 83 49 88 B5 F0 7F 
3D A2 F3 5D D5 DF 37 A3 FC D5 57 C2 6E DD 1F 7D D5 D5 C8 FD E9 CF 60 B0 D9 B4 63 6A 48 57 BB E7 
C8 B2 AC B5 FA 87 1B FA D5 49 08 D4 6F 2C 7D F7 44 44 BD 61 F2 A0 A8 A5 3E 38 01 F4 18 FC BB A6 
C5 73 E2 BB 85 12 74 3A 9D 36 78 4E DD E6 7D DD 8E BC F4 24 3C F7 8F 32 74 BA A4 90 7F 73 6F 79 
23 8A 57 EE C2 83 37 4F 41 7A 72 CC 80 BF 27 22 3A 77 E7 DA BA 6F 9F 7E 71 C0 6B BE 5D 6F F4 7A 
7D 40 0B 7F 5F 83 BF EF B8 24 DF 4D BD 97 B1 A5 9F 88 7A C3 D0 4F 51 AD B7 E0 EF FB 70 56 FB FD 
AB A1 DF 6A B5 6A 9B C9 64 C2 D7 27 C6 62 6C 4A 3C 7E B7 7E 3F EA CE 86 6E 11 AC 6A 6C 47 F1 5F 
76 61 D9 4D 93 30 2D C7 3E 68 EF 8D 88 C2 37 90 AD FB 2A 75 55 6F DF C0 0F 84 DF C2 DF FD 9A DD 
7F 66 E0 27 A2 60 18 FA 29 EA 05 0B FE EA 7C D8 B2 2C 6B 33 39 99 CD 66 6D 33 18 0C D0 EB F5 C8 
4A 8D C7 33 3F 9D 81 47 D7 EF C7 81 13 67 42 FE 4D 47 A7 88 87 D6 7D 81 1F 7F 3B 17 73 66 8E 1B 
B4 F7 46 44 7D 33 18 AD FB BE 7A 0A E4 03 11 D2 19 F4 89 A8 AF 18 FA 89 10 18 FC FD 56 BC F4 09 
FD BE 03 E7 D4 C0 AF 9E 97 60 33 E1 D1 5B A7 E2 4F 7F 3F 82 92 CF AB 42 FE 4D 59 56 F0 97 77 8F 
A2 A2 B6 0D 3F BF AE 00 06 3D 1F DE 44 43 61 30 5A F7 83 61 50 27 A2 A1 C0 D0 4F E4 E5 1B FC D5 
05 6E D4 01 77 EA D7 F0 7A BD 5E DB D4 81 74 EA B9 00 A0 D7 09 B8 EB FA 02 64 A6 C4 62 55 C9 51 
48 72 E8 AF EF B7 EE AD 46 55 63 3B 7E BD E0 22 24 DA 02 D7 84 20 A2 C1 31 D8 AD FB 44 44 E7 13 
86 7E 22 1F 6A F0 F7 9D 1D C3 77 E1 1C DF D7 82 F5 A3 BD FE D2 B1 18 97 62 C3 63 7F DB 8F D6 0E 
77 C8 BF 7B E8 E4 59 FC F2 A5 5D 78 F0 E6 C9 C8 1A 1D 37 70 6F 88 88 7A 14 E9 D6 7D 22 A2 A1 C6 
F9 BD 88 BA F1 9D 0D 43 AF D7 C3 60 30 68 5B F7 05 70 82 7D 4D 3F 25 2B 09 4F FF 74 06 C6 8E EC 
5B 38 A8 6F EE C4 D2 97 3F C3 47 87 EA 06 EA AD 10 51 37 9D A7 6B B0 F7 BE 7B 71 F4 C5 17 C2 0A 
FC 66 BB 1D 17 3D F4 5F 28 58 72 37 03 3F 11 5D 90 18 FA 89 7A D0 7D 2A 3C 75 EB DE CA 1F 4A 5A 
92 15 4F 2F BE 18 D3 73 93 FB 54 BE D3 25 E1 F7 7F DB 8F 37 FE 75 FC 5C AA 4F 44 3D A8 FA FB 66 
EC FA F9 1D 61 77 E7 19 7D D5 D5 98 F1 E7 FF 78 7E 88 00 00 20 00 49 44 41 54 97 D8 9D 87 88 2E 
68 EC DE 43 14 C4 40 0C B8 8B 31 1B F0 9B 7F 9F 82 D5 5B 8E 61 E3 C7 27 42 96 57 14 05 EB DE 2F 
47 45 6D 1B EE BE B1 10 66 23 3F 9B 13 9D 0B F6 DD 27 22 62 E8 27 8A 08 9D 00 FC E4 9A 5C 64 8E 
8A C5 F3 6F 1F 86 5B 94 43 9E F3 D1 A1 5A 9C 3E D3 8E 07 FE DF 64 8C 4C B0 44 A0 96 44 C3 0F FB 
EE 13 11 79 30 F4 13 45 D0 D5 53 52 31 C6 1E 83 47 FE FA 25 CE B4 39 43 96 2F AF 69 C5 2F 57 EE 
C2 FD 0B 26 A3 60 6C 42 04 6A 48 34 74 CE 65 B1 AA EE D4 D6 FD E6 83 07 C2 3A 8F AD FB 44 34 5C 
31 F4 13 45 58 C1 D8 04 3C 73 FB 0C FC D7 1B 5F A0 BC A6 35 64 F9 B3 6D 2E 2C 7F F5 73 FC FC 7B 
05 B8 FA 6B A9 11 A8 21 51 64 A9 61 BF B9 F4 08 4E 97 94 40 81 72 4E 1F 00 3A 2A 4F A1 B5 EC 18 
14 51 0A EB BC D4 AB BF 85 9C C5 B7 B3 75 9F 88 86 25 86 7E A2 21 90 1C 6F C6 13 3F BE 18 4F 6F 
3C 88 1D 07 6B 43 96 77 8B 32 FE B0 E9 20 2A EA DA F0 A3 6F E7 42 C7 B5 7D 68 98 50 14 45 DB 6A 
DF 7F 1F 35 5B 4B 60 30 F5 7F BD 0A 45 9D 62 57 94 20 08 42 9F 3E 3C B0 75 9F 88 A2 01 43 3F 00 
87 C3 81 43 87 0E 21 36 36 16 05 05 05 7D 3E AF B5 B5 15 BB 76 ED 82 C5 62 C1 D4 A9 53 61 B5 5A 
07 A4 2C 45 07 B3 51 87 E5 3F 98 84 37 FE 65 C3 1B FF 3A DE A7 70 B2 F1 E3 13 38 55 EF C0 B2 9B 
8A 10 63 E6 FF BE 74 61 53 C3 BE 2C CB DA 26 08 02 66 5E 79 95 A7 80 00 40 F1 EE 01 08 10 A0 40 
81 80 9E 3F F5 2A 8A A2 05 FD CF 3F DA 81 F6 B6 B6 90 75 60 EB 3E 11 45 0B 4E 0B 02 60 F6 EC D9 
98 31 63 06 26 4E 9C 88 FA FA FA 90 E5 45 51 C4 AD B7 DE 8A C4 C4 44 5C 7D F5 D5 B8 FC F2 CB 11 
1F 1F 8F A7 9E 7A EA 9C CA 52 74 BA F9 9B 59 58 FE 83 49 B0 98 F4 7D 2A FF D9 B1 06 2C 59 B9 1B 
D5 4D 1D 83 5C 33 A2 C1 A7 86 7E B7 DB 0D 49 F2 74 C7 51 64 09 8A 2C 41 16 BB F6 B2 28 41 12 45 
6D DF D3 A6 C8 92 B6 0F 45 9D 77 7F C2 2F 8B 19 F8 89 28 2A 44 7D E8 7F E3 8D 37 F0 E1 87 1F 22 
3F 3F 1F 40 DF 06 92 2D 5E BC 18 6B D6 AC C1 DD 77 DF 8D FD FB F7 E3 F3 CF 3F C7 65 97 5D 86 7B 
EE B9 07 AF BD F6 5A BF CB 52 F4 BA 6C 62 0A 9E F8 F1 F4 3E CF D2 53 D9 E0 40 F1 CA 5D F8 E2 AB 
A6 41 AE 19 D1 E0 F0 ED D6 23 49 12 DC 6E 37 44 51 04 00 48 2E 17 24 97 0B B2 BB 6B 2F BB 5D 90 
5D 3E 7B 57 B7 63 6E 17 44 67 D7 3E D8 BD 3C F5 EA 6F 71 DE 7D 22 8A 3A 51 1D FA DB DA DA B0 74 
E9 52 FC E0 07 3F C0 E5 97 5F DE A7 73 6A 6A 6A B0 76 ED 5A CC 9D 3B 17 2B 56 AC 40 51 51 11 A6 
4E 9D 8A 0D 1B 36 C0 6C 36 63 E5 CA 95 FD 2A 4B 94 35 3A 0E CF DC 3E 03 13 C7 25 F6 A9 7C 6B 87 
1B 0F AE DD 8B CD 9F 9E 1A E4 9A 11 0D 1E 59 96 21 49 12 5C 2E 97 D6 D2 2F 8B A2 77 93 7C F6 12 
64 D9 67 2F 7B 5F 53 F7 DE 16 7E 75 8F 1E 42 BF 29 29 09 93 7E F3 30 5B F7 89 28 2A 45 75 A7 E0 
DF FE F6 B7 68 6E 6E C6 93 4F 3E 89 87 1F 7E B8 4F E7 AC 5F BF 1E 92 24 61 C1 82 05 7E C7 93 93 
93 71 C5 15 57 60 EB D6 AD A8 AB AB 43 4A 4A 4A 58 65 C3 E5 70 38 70 E6 CC 99 80 E3 6E B7 1B 82 
20 A0 B2 B2 32 EC 6B D2 F9 E1 CE AB 47 61 DD 0E 05 1F 1F 6D 0E 59 56 92 15 BC F4 CF 52 1C FC AA 
16 37 5F 36 0A 7A 8E F0 A5 0B 84 DA AD 47 0D FC ED ED ED 68 6D F5 CC 66 25 B9 DD 6A 21 40 10 BA 
02 BC FA 73 6F 8B E6 F9 94 EF DE D2 6F 9B 71 09 92 6F 9A 8F 8E D8 58 DE 1F A3 58 4A 4A 0A 4C E7 
30 50 9C E8 42 16 B5 A1 BF B4 B4 14 7F F8 C3 1F F0 D0 43 0F 61 EC D8 B1 7D 3E EF C8 91 23 00 80 
69 D3 A6 05 BC 56 50 50 80 2D 5B B6 A0 AA AA 0A 29 29 29 61 95 ED 4F FD 4B 4A 4A 02 8E 1B 8D 46 
B8 DD 6E AC 5D BB 36 EC 6B D2 F9 43 07 60 BC 61 34 2A C4 74 28 BD 0C 5A F4 B5 E3 C8 59 EC 3F 5A 
89 09 C6 63 30 0A E2 E0 57 90 E8 1C F9 0E E2 15 45 11 4E A7 13 79 95 A7 30 5E 51 20 B9 5C BD 9D 
E4 FF 21 A0 3B DF 0F 05 DE 32 4E A3 11 A5 19 E3 D1 22 E8 A1 7B EB 2D 08 82 30 20 2B 6D D3 85 69 
D1 A2 45 48 4B 4B 1B EA 6A 10 0D 89 A8 0D FD 77 DD 75 17 32 32 32 70 F7 DD 77 87 75 5E 6D AD 67 
7A C5 C4 C4 C0 2E 18 49 49 49 00 80 C6 C6 C6 B0 CB 86 2B 2B 2B 0B 73 E7 CE 0D 38 BE 6D DB 36 18 
8D 46 CC 9A 35 AB 5F D7 A5 F3 CB E1 EA 0E BC B6 A3 01 9D EE D0 63 4D 9A E5 58 1C 33 5E 8C 1F CF 
4A 46 DA 08 B6 64 D1 F9 AD 7B E0 77 38 1C 70 BD FB 0E 84 E6 33 90 C5 3E 7E 70 0D 3A BB 8F 02 25 
26 06 96 1F 2F C6 D7 93 92 60 36 9B 61 34 1A A1 D3 E9 18 FA A3 98 FA EC 25 8A 46 51 19 FA 37 6E 
DC 88 2D 5B B6 E0 1F FF F8 07 CC 66 73 58 E7 9E 3D 7B 16 00 7A 3C CF 62 F1 0C C2 6C F3 4E 13 17 
4E D9 70 25 26 26 F6 F8 61 62 FB F6 ED B0 5A AD C8 CB CB EB D7 75 E9 FC 92 97 07 4C 2B 6A C7 7F 
BD F1 05 AA 1A DB 43 96 6F 6A 13 F1 FC B6 06 DC 73 63 21 2E 9D 30 32 02 35 24 EA 1F DF 59 7B 3A 
3A 3A D0 DA DA 8A EA B8 38 74 02 90 DC 9E 96 FE C0 29 3A D5 84 AF 78 AF D1 7B C3 BF A2 28 30 A5 
A6 22 3D 3F 1F 71 71 71 88 89 89 81 D1 68 84 5E AF 67 E8 27 A2 A8 14 75 03 79 3B 3A 3A 50 5C 5C 
8C EB AE BB 0E B3 67 CF 0E FB FC 84 84 04 00 40 4B 4B 4B C0 6B 2E EF 57 D2 76 BB 3D EC B2 44 BD 
49 4F 8E C1 D3 3F 9D 81 AF 65 F7 ED DF 4A 87 53 C4 EF FE FA 25 D6 7F 58 31 B8 15 23 1A 24 8A 24 
41 91 BC 83 72 A5 AE 81 BA 92 77 60 AF 24 4A 90 BC D3 79 AA 7B CF 26 6B FB DE E6 F2 27 22 8A 56 
51 D7 D2 BF 66 CD 1A 54 54 54 E0 9A 6B AE C1 E3 8F 3F AE 1D FF F2 CB 2F 01 00 CF 3D F7 1C B2 B2 
B2 70 DB 6D B7 F5 78 7E 72 72 32 00 4F 2B FE E8 D1 A3 FD 5E 53 BB F3 A8 7D F4 C3 29 4B 14 4C AC 
C5 80 FF BA E5 6B F8 CB BB 47 B1 79 E7 C9 90 E5 15 45 C1 6B DB CA 50 51 D7 86 25 73 26 C2 64 88 
BA CF F7 74 01 D3 FA F4 FB 37 EC 07 74 E7 09 FA 7A 1F A6 5F 26 22 8A 26 51 17 FA DB DB DB 61 34 
1A B1 7A F5 6A BF E3 EA 54 71 8F 3D F6 18 32 33 33 7B 0D FD D9 D9 D9 00 80 DD BB 77 63 C2 84 09 
7E AF ED D9 B3 07 09 09 09 C8 CC CC 0C BB 2C 51 28 3A 01 B8 FD DA 3C 64 A6 C4 E2 CF FF 38 02 51 
92 43 9E F3 E1 FE D3 A8 69 6C C7 03 37 4F 86 3D 2E BC AE 6C 44 43 45 74 3A 01 40 5B 5D 57 ED 8E 
E3 BB E2 6E A8 D7 FB B2 E6 0A 11 51 34 89 BA E6 BF E2 E2 62 B8 5C AE 80 4D 0D F9 55 55 55 38 76 
EC 98 56 BE A6 A6 06 07 0E 1C D0 7E BF E9 A6 9B 00 00 EB D6 AD F3 7B A8 EC DF BF 1F 3B 77 EE C4 
FC F9 F3 B5 3E FC E1 94 25 EA AB 6B A6 A5 E1 91 45 53 91 60 EB DB 60 DD 63 D5 2D F8 E5 4B BB 50 
5A 15 D8 CD 8C E8 7C D4 5B F7 1E 45 92 B5 BD 67 93 7C F6 DE EE 3D DE 7D 57 F3 3F 11 11 01 51 18 
FA C3 35 6B D6 2C 4C 9A 34 09 27 4E 9C 00 00 E4 E4 E4 60 CE 9C 39 28 29 29 C1 2D B7 DC 82 4D 9B 
36 61 D5 AA 55 98 3D 7B 36 EC 76 3B 8A 8B 8B B5 73 C3 29 4B 14 8E A2 8C 44 3C F3 D3 19 C8 1C 15 
DB A7 F2 4D AD 4E 2C 5B FD 19 DE FF F2 F4 20 D7 8C E8 DC 49 6E B7 77 73 F9 EC 03 37 D1 E9 D4 F6 
A2 D3 09 C9 67 CF 96 7E 22 22 7F 0C FD 5E 06 83 01 82 20 40 AF D7 FB 1D B7 DB ED 88 89 89 41 6C 
6C 57 B8 5A BF 7E 3D 6E BD F5 56 BC FD F6 DB B8 E1 86 1B 70 E7 9D 77 62 DC B8 71 F8 E0 83 0F 90 
9F 9F EF 77 7E 38 65 89 C2 91 92 68 C1 53 3F B9 18 33 0B FA 36 2E C4 2D CA 78 F2 CD 03 78 65 6B 
99 D6 DD 59 ED 06 D1 D6 E1 C6 EA 2D C7 50 D3 D4 CE AE 11 34 E4 BA 5A FA BB F6 FE AB F3 06 AE C0 
AB C8 12 64 A9 6B CF 86 7E 22 22 7F 0C FD 5E 7F FE F3 9F E1 70 38 02 66 D3 F9 E4 93 4F 70 E6 CC 
19 BF E3 26 93 09 AF BC F2 0A CE 9E 3D 8B F2 F2 72 B4 B4 B4 E0 A3 8F 3E 42 41 41 41 C0 75 C3 29 
4B 14 2E 8B 49 8F FB 17 5C 84 F9 B3 C6 F7 F9 9C 0D 3B 2A F0 F0 BA BD 68 77 8A 50 14 05 AD ED 2E 
DC FF DA 5E BC F9 D1 09 DC F7 CA 1E 54 37 3A B4 E0 CF F0 4F 91 24 3B 9D 80 A2 68 2D F7 B2 B7 15 
5F 76 BB 20 BB 5D 90 5C 5D FB 50 1B FF ED 12 11 F9 63 E8 F7 D2 E9 74 B0 5A AD 01 C7 05 41 E8 75 
C9 6E 41 10 90 95 95 D5 A7 7E F9 E1 94 25 0A D7 C2 AB B2 B1 EC A6 49 30 1B F5 A1 0B 03 D8 7D AC 
11 C5 7F D9 8D B2 AA 66 3C F8 FA 3E 94 9D 6E 45 F6 D8 71 68 EE 10 B1 FC D5 BD A8 6E 74 40 96 65 
06 7F 8A 18 45 14 E1 3E 5A 0A 00 5A C8 F7 0D FE BE 5D 79 BA BA F7 74 ED 45 A7 7A 8E 67 CF D9 7B 
88 88 FC 31 F4 13 0D 13 B3 8A 46 61 C5 8F A6 23 39 DE D2 A7 F2 A7 EA 1D 58 FA CA 5E 94 9D 6E 45 
61 76 3E B2 C7 65 E2 6B 13 0A D1 D2 29 E1 57 6B BE 60 F0 A7 88 6A F8 9F F5 90 5B 5B 01 40 EB CE 
A3 C8 B2 B6 F7 1D A4 DB 35 70 D7 67 2F AB E7 78 F6 EC DF 43 44 E4 8F A1 9F 68 18 C9 49 8B C3 33 
B7 CF C0 84 F4 84 90 65 05 41 80 28 2B C8 CF CC C5 C8 24 3B 5C A2 84 98 98 58 14 E5 16 A0 A5 53 
C2 AF 5F DB C7 E0 4F 11 71 E6 A3 1D 68 D9 FE 21 00 4F 54 AF D7 EB 3D 9B CE 67 AF 6E 7A 43 EF 9B 
A1 6B 2F 0E ED 5B 22 22 3A EF 44 DD 3C FD 44 C3 DD 88 58 13 1E BB 6D 1A FE B8 F9 30 FE 6F 5F 4D 
8F 65 04 41 80 02 20 2F 33 07 23 ED 76 88 72 D7 9C FF B1 B6 58 4C CC CE C7 A1 F2 52 DC BF F6 4B 
FC EE 96 8B 90 66 B7 41 A7 D3 69 E7 12 0D 94 F6 8A 0A 9C 5A BD CA FB 9B 02 08 80 2C 04 B6 47 29 
66 33 DC 23 83 0F 5A 17 04 01 82 20 40 A7 D3 C1 60 30 C0 3C 79 8A 76 8C 88 28 DA 31 F4 13 0D 43 
46 83 0E 77 DF 58 88 8C 94 58 BC FA DE 31 BF EE CD 9E C5 8B 80 AC 71 E3 31 22 21 11 2E 51 F2 F4 
7F F6 09 46 16 AB 0D B9 99 B9 38 76 FC 18 83 3F 0D 1A D1 E1 40 E9 93 2B 20 AB 2B F0 02 DE 5E 39 
FE DF 2A C9 36 1B DA BE 7F 23 E4 1E C6 5D A9 D4 70 6F 30 18 60 36 9B 61 B2 D9 60 8D 8B 83 4E A7 
63 F0 27 22 02 BB F7 10 0D 6B 73 2F 1B 87 07 16 5C 04 AB C9 3B C0 D7 1B F8 33 D2 33 91 90 30 02 
2E 49 86 CB 2D 76 ED 7D 36 B3 D9 8A F1 E3 B2 D0 DC 21 E1 FE B5 5F B2 AB 0F 0D B8 D2 3F 3C 85 CE 
D3 3D 7F 1B A5 D1 E9 20 5D FB 3D 98 93 92 60 B5 5A 83 6E 16 8B 05 16 8B C5 13 FA 4D 26 18 8D 46 
E8 F5 7A 06 7F 22 22 30 F4 13 0D 5B 6A 38 9F 9E 6B C7 6F 6E 9E 04 A3 41 0F 28 C0 D8 B4 71 48 88 
4F 84 24 C9 90 24 19 A2 DC B5 17 65 19 92 AC 68 7B 8B C5 86 8C F4 F1 0C FE 34 E0 2A FE FA 06 1A 
77 EF 0A 59 4E FF AD 6F C3 96 9B 8B B8 B8 B8 A0 5B 6C 6C AC B6 B7 D9 6C B0 5A AD 30 9B CD 5A F0 
67 E0 27 A2 68 C7 EE 3D 44 C3 90 1A C8 15 45 41 8B C3 89 BF 94 94 43 94 64 A4 8E 1E 0B 5B 6C 82 
A7 4B 4F EF 67 03 10 A0 76 B1 30 18 2D 18 93 3A 0E 55 35 27 D9 D5 87 06 44 D3 9E 3D 38 F1 DF 6F 
84 2C 67 9D 3A 0D 71 FF 76 75 9F 3E 60 AA FF 0E D5 FE FC 26 93 09 16 8B 05 26 93 89 AD FD 44 44 
60 E8 27 1A B6 64 59 86 24 49 D8 FC E9 29 94 D7 B4 22 31 D1 8E D8 D8 78 88 92 0C 41 F0 9D C6 DC 
3F E4 7B FA FC CB 7E E1 C8 64 8E 41 52 52 0A EA EA AA B1 66 DB 57 58 36 AF 90 01 8A FA C5 59 5F 
87 43 4F 3C 06 C5 67 F0 78 4F CC 63 D2 91 7E DB 8F 01 A3 31 AC EB EB 74 3A 2D F8 1B 8D 46 BF 96 
7E FE 7B 25 A2 68 C6 D0 4F 34 CC F8 AE A6 2B 49 12 BE 59 68 C7 07 07 EA 50 DF 72 06 26 53 0C 2C 
56 9B 37 D8 7B 43 3E 04 28 50 20 C0 13 88 D4 9F 15 6D 30 A5 00 B7 AB 13 4D 4D 75 B0 99 0D B8 7E 
7A 0A 44 51 F4 0B 51 0C 53 D4 17 B2 DB 8D FD 8F FC 0E 6E EF 7C FC BD D1 C7 C4 20 E7 EE A5 30 27 
25 85 DD 8D 4C 9D BD 47 A7 D3 69 2D FC EA 9E 88 28 9A 31 F4 13 0D 43 8A A2 68 2D FD 31 46 05 BF 
B8 26 15 4F FF B3 12 0D 0D 55 48 1C 31 1A 26 8B AD 2B E4 2B 8A DF 87 00 AD D1 DF 9B E3 45 B7 13 
67 1A AB 60 D2 03 FF F9 ED D1 18 9D 60 80 28 8A 7E 5D 26 88 FA E2 D8 0B 7F 46 6B D9 B1 90 E5 F2 
7E B1 04 09 19 19 DA EF 7D 0D FE BE 1F 42 7D 37 76 45 23 22 62 E8 27 1A B6 D4 96 7E 51 14 61 35 
C8 B8 6D A6 0D AB 76 B4 E0 4C 53 0D E2 13 47 C1 64 B1 F9 14 EE FA 51 50 BC 2D FF 8A 00 D1 ED C4 
D9 C6 6A 08 82 82 5B 2F 8D 41 B2 0D 10 45 91 83 79 29 6C 35 25 EF A2 7A CB BB 21 CB 65 CC 5F 80 
94 99 5F 3F A7 7F 5B BE E1 9E DF 46 11 11 79 30 F4 13 0D 53 BE 83 79 65 59 46 8C 51 C1 FC C9 02 
FE FA 85 8C E6 B3 B5 88 89 1B 09 83 29 26 A0 65 5F FD 59 72 BB E0 68 AE F5 F4 EF 57 14 B4 74 88 
DA B5 7C 03 BF FA 4D 01 51 6F 5A CB 8E E1 E8 8B 2F 84 2C 97 F4 B5 A9 18 FF EF B7 00 03 D4 FF 9E 
FF 2E 89 88 BA B0 93 23 D1 30 E5 DB B5 41 AF D7 C3 60 30 20 DE AA C7 8D 13 45 C4 9B 25 B4 B7 D6 
C3 E5 74 78 A6 EE F4 4E DB E9 F9 59 81 DB D5 D9 15 F8 BD BD FB 37 EF 77 A2 53 14 02 66 42 61 B0 
A2 60 C4 D6 56 1C 78 F4 11 C8 6E 57 D0 72 96 94 14 14 DE 7B 1F 84 6E FF B6 CE 65 23 22 A2 2E 0C 
FD 44 C3 50 F7 B0 6F 32 99 60 36 9B 61 36 9B 91 68 33 E2 86 02 4F F0 EF 6C AB 87 B3 D3 01 97 28 
69 9B D3 D9 89 8E 96 7A BF C0 0F 00 AD 9D 0A FE B6 EB AC DF 82 47 44 41 29 0A 0E 3E F1 38 3A EB 
6A 83 16 D3 19 4D 28 FA D5 FD 30 C4 C5 45 A8 62 44 44 D1 87 4F 6D A2 61 C6 B7 A5 53 AF D7 6B F3 
95 5B AD 56 C4 C4 C4 C0 6A B5 62 44 AC C9 1B FC 65 88 1D 8D 70 A9 C1 DF D5 09 B7 23 30 F0 AB F6 
9F 72 E0 FF 0E 34 71 10 2F F5 C9 F1 D7 5F 43 D3 9E CF 43 96 CB BB E3 0E C4 E5 E4 46 A0 46 44 44 
D1 8B A1 9F 68 98 52 5B FA 8D 46 23 CC 66 33 62 62 62 60 B3 D9 60 B3 D9 10 13 13 E3 17 FC 05 F7 
59 C8 AE 36 C0 79 06 80 D2 63 E0 57 FD F7 8E 2A 54 35 39 B9 D8 11 05 D5 B8 EB 53 9C F8 DB FA 90 
E5 D2 BE FD 1D A4 7E EB 9A 08 D4 88 88 28 BA 45 F5 40 DE B2 B2 32 1C 3A 74 08 26 93 09 85 85 85 
18 3B 76 6C 9F CE 3B 73 E6 0C 4E 9F 3E 1D 70 DC 62 B1 60 FC F8 F1 3D 9E D3 DA DA 8A 5D BB 76 C1 
62 B1 60 EA D4 A9 B0 5A AD E7 54 77 A2 60 D4 20 AE D7 EB 01 F8 0F EA ED 5E EE 86 02 27 36 1E 36 
A0 B9 B3 0D 66 03 10 6F 52 50 DF DE 7B 90 77 8B 32 9E DA 78 18 CF DE 3E 03 26 23 DB 0D 28 50 47 
4D 0D 0E 3D F5 44 C8 19 78 E2 72 72 90 FB 1F 77 44 A8 56 44 44 D1 2D 2A 43 FF A1 43 87 F0 A3 1F 
FD 08 9F 7E FA A9 76 4C A7 D3 E1 F6 DB 6F C7 9F FE F4 A7 90 2D 97 D7 5F 7F 3D 76 EC D8 11 70 DC 
60 30 C0 E5 72 F9 9D 2F 8A 22 7E F2 93 9F 60 ED DA B5 90 BD 2B 50 1A 0C 06 3C F6 D8 63 B8 FB EE 
BB 07 E8 1D 11 05 52 FF 1D EA 74 3A 18 7B 59 D5 54 6D A9 9F 57 E4 C6 C7 27 64 4C 49 95 11 6B 35 
E2 F5 3D 40 87 BB F7 C0 76 B2 DE 81 BF 94 1C C3 9D DF 9B 30 28 75 A7 0B 97 EC 74 E2 C0 A3 BF 83 
E8 70 04 2D 67 8C 8B 43 D1 AF 1E 80 2E CC 15 77 89 88 A8 7F A2 32 F4 BF F4 D2 4B 30 18 0C 78 F3 
CD 37 31 65 CA 14 1C 3F 7E 1C 77 DC 71 07 5E 78 E1 05 5C 7A E9 A5 58 B8 70 61 D0 F3 DB DB DB 31 
69 D2 24 DC 7B EF BD 7E C7 E3 E3 E3 03 3E 30 2C 5E BC 18 6B D6 AC C1 D2 A5 4B B1 70 E1 42 B8 5C 
2E 14 17 17 E3 9E 7B EE C1 C8 91 23 43 FE 2D A2 73 E1 BB 30 51 4F C1 5F 7D DD 60 70 E2 BB 85 12 
74 3A 1D 4C 26 13 6E 98 AA C7 1B 9F B6 04 BD F6 3F 77 57 62 7A 6E 32 2E C9 4F 1E 94 BA D3 85 A9 
F4 F9 E7 D0 76 FC AB A0 65 04 9D 0E 13 97 DE 07 4B 4A 4A 84 6A 45 44 44 51 19 FA 1F 7C F0 41 D8 
ED 76 ED F7 AC AC 2C AC 58 B1 02 73 E6 CC C1 BF FE F5 AF 3E 05 F1 D4 D4 54 FC F0 87 3F 0C 5A A6 
A6 A6 06 6B D7 AE C5 DC B9 73 B1 62 C5 0A ED F8 86 0D 1B 90 9E 9E 8E 95 2B 57 32 F4 D3 A0 EB 2D 
F8 FB 0E F6 35 1A 8D 90 65 59 0B FD 97 A6 58 51 D9 A2 C7 87 87 CF 04 BD F6 33 9B 0E E1 4F 77 5C 
8A A4 38 D3 A0 BE 07 BA 30 54 FD FD 6D 9C 7E 7F 5B C8 72 E3 FF FD 16 24 4D 9D 1A 81 1A 11 11 91 
2A 2A 43 BF 6F E0 57 C5 C6 C6 02 E8 B9 35 B4 BF D6 AF 5F 0F 49 92 B0 60 C1 02 BF E3 C9 C9 C9 B8 
E2 8A 2B B0 75 EB 56 D4 D5 D5 21 A5 1F AD 5D 0E 87 03 67 CE 04 06 32 B7 DB 0D 41 10 50 59 59 D9 
EF 7A D3 F0 E4 BB B0 96 DB ED 86 DB ED 86 CB E5 82 D3 E9 84 DB ED 86 2C CB 10 04 01 2E 97 0B 6E 
B7 1B DF 2E 30 A3 B4 DA 88 DA 66 77 AF D7 6C 69 77 E1 77 6F 7C 86 25 B3 C7 81 E3 79 A3 5B E7 57 
5F A1 F2 2F 2F 85 2C 67 2B 9A 04 FD 65 97 F3 1E 45 43 22 25 25 05 26 13 1B 29 28 3A 45 65 E8 EF 
4E 51 14 BC F8 E2 8B 00 80 39 73 E6 84 75 1E D0 FB AA 8F 47 8E 1C 01 00 4C 9B 36 2D E0 B5 82 82 
02 6C D9 B2 05 55 55 55 FD 0A FD A5 A5 A5 28 29 29 09 38 6E 34 1A E1 76 BB B1 76 ED DA B0 AF 49 
C3 9F BA 92 AE FA 01 40 96 65 48 92 A4 7D 18 00 BA 66 FD D1 EB F5 18 25 C4 A1 5E 28 82 AC F4 9E 
E8 4B AB DB F1 FB 57 DF C3 58 43 4D A4 DE 06 9D 67 8C 6E 37 26 ED DB 03 93 24 05 2D D7 69 B6 60 
B7 2D 0E 12 EF 4F 34 44 16 2D 5A 84 B4 B4 B4 A1 AE 06 D1 90 88 DA D0 BF 73 E7 4E 7C FA E9 A7 A8 
AF AF C7 3B EF BC 83 F2 F2 72 3C F1 C4 13 B8 F6 DA 6B 43 9E 2B 08 02 B6 6D DB A6 2D 7C 94 99 99 
89 6F 7C E3 1B F8 CD 6F 7E 83 71 E3 C6 69 E5 6A 6B 3D 0B D2 24 26 26 06 5C 23 29 29 09 00 D0 D8 
D8 D8 AF FA 67 65 65 61 EE DC B9 01 C7 B7 6D DB 06 A3 D1 88 59 B3 66 F5 EB BA 34 FC F9 B6 F8 F7 
14 FA D5 39 F8 F5 7A 3D 04 41 C0 8E A3 0E 6C DA 73 36 E8 35 2B E5 B1 B8 F1 9B D3 31 CE CE 16 B4 
A8 23 CB 68 78 F1 4F 70 3A 9D 41 8B 09 46 23 32 FE F3 17 C8 66 E0 A2 21 A4 3E 7B 89 A2 51 D4 86 
FE CD 9B 37 E3 F9 E7 9F 47 7B 7B 3B 24 49 C2 84 09 13 D0 D9 D9 09 97 CB 15 F2 AB BF E5 CB 97 E3 
E4 C9 93 88 8D 8D 45 53 53 13 B6 6F DF 8E 57 5E 79 05 9B 36 6D C2 BE 7D FB 90 9E 9E 0E 00 38 7B 
D6 13 94 CC 66 73 C0 35 2C 16 0B 00 A0 AD AD AD 5F F5 4F 4C 4C EC F1 C3 C4 F6 ED DB 61 B5 5A 91 
97 97 D7 AF EB 52 74 E8 A9 C5 5F A5 CE BF AF EE 27 4C 00 2A 5B F7 E1 B3 63 0D BD 5E 4F 92 15 FC 
75 57 0B 9E FB 8F 4B 60 35 E9 23 F1 16 E8 3C 51 BE 7A 15 9C 65 65 21 CB 15 FC E7 2F 30 EA 9B DF 
1C FC 0A 11 11 51 8F A2 76 92 ED 47 1F 7D 14 2D 2D 2D E8 EC EC C4 BE 7D FB 90 9B 9B 8B 07 1E 78 
20 A0 FF 7D 4F E6 CE 9D 8B 25 4B 96 60 F1 E2 C5 58 B6 6C 19 FE FE F7 BF E3 B1 C7 1E 43 53 53 13 
1E 79 E4 11 AD 5C 42 42 02 00 A0 A5 25 70 16 14 97 CB 05 A0 E7 F1 05 44 83 4D 1D C4 AB B6 E8 1B 
0C 06 6D F3 5D 6D 57 DD 8A 6F 28 C4 88 D8 C0 0F AF BE 6A 9A DA F1 C2 3F 8E 44 E8 1D D0 F9 A0 FE 
E3 8F 70 F2 AD 37 43 96 4B FF EE 75 18 F5 6F 57 45 A0 46 44 44 D4 9B A8 0D FD 2A 83 C1 80 8B 2E 
BA 08 1B 36 6C 40 66 66 26 36 6E DC 88 A3 47 8F 86 7D 9D 45 8B 16 01 00 BE F8 E2 0B ED 58 72 B2 
67 2A 43 B5 C5 DF 97 DA F5 A7 3F FD F9 89 06 82 6F A8 D7 E9 74 DA E6 DB CA AF 4A B0 19 B1 E4 86 
89 21 D7 B0 D8 F6 45 0D DE FF 32 70 E1 3A 1A 7E DA 2B 2B 71 E4 99 A7 43 96 4B 98 50 80 9C C5 3F 
8D 40 8D 88 88 28 98 A8 0F FD 2A 75 55 5E 00 A8 AB AB 0B FB 7C B5 3F AB 1A F4 01 20 3B 3B 1B 00 
B0 7B F7 EE 80 F2 7B F6 EC 41 42 42 02 32 33 33 FB 51 5B A2 81 E3 1B FE D5 AD 27 D3 72 EC B8 E1 
EB E3 7A 7C CD D7 9F FF 71 04 A7 CF 74 0C 74 35 E9 3C 22 75 76 E2 C0 23 BF 85 D8 DE 1E B4 9C 29 
21 11 85 CB 7F 05 C1 10 B5 3D 49 89 88 CE 1B 51 19 FA 2B 2A 2A 02 8E 35 37 37 E3 B3 CF 3E 83 4E 
A7 C3 A4 49 93 B4 E3 35 35 35 38 70 E0 80 F6 BB 6F DF 67 5F EB D6 AD 03 00 CC 9C 39 53 3B 76 D3 
4D 37 69 AF F9 2E 47 BF 7F FF 7E EC DC B9 13 F3 E7 CF EF B1 BF 3F D1 F9 6A D1 55 39 C8 4E 8D 0F 
5A A6 BD 53 C4 13 1B 0E 40 96 7B 5F D1 97 2E 6C 47 9E 79 1A 8E 53 27 83 96 11 F4 7A 14 DE B7 1C 
66 3B 17 6F 23 22 3A 1F 44 65 F3 CB B4 69 D3 30 75 EA 54 DC 78 E3 8D C8 CC CC 44 75 75 35 FE F8 
C7 3F A2 B6 B6 16 CB 97 2F D7 FA E2 03 C0 AC 59 B3 50 56 56 86 8A 8A 0A 64 64 64 E0 99 67 9E C1 
9B 6F BE 89 F9 F3 E7 23 27 27 07 0E 87 03 25 25 25 78 F5 D5 57 51 58 58 88 25 4B 96 68 E7 E6 E4 
E4 60 CE 9C 39 D8 B4 69 13 6E B9 E5 16 CC 9B 37 0F 0D 0D 0D 78 F8 E1 87 61 B7 DB 51 5C 5C 3C 14 
6F 9F A8 DF 0C 7A 01 CB 6E 2A C2 5D 2F 7E 8A 4E 57 EF D3 33 1E A9 6C C6 DA F7 BF C2 A2 AB B2 23 
58 3B 8A 84 53 1B DF 42 DD 8E ED 21 CB 65 2F BA 0D 89 93 2E 8A 40 8D 88 88 A8 2F A2 32 F4 3F F9 
E4 93 58 B1 62 05 EE B8 E3 0E ED 58 6A 6A 2A 9E 7D F6 59 DC 79 E7 9D 7E 65 ED 76 3B AA AB AB B5 
C5 BB AE BC F2 4A AC 5F BF 1E 4B 96 2C D1 5A FD 6D 36 1B 7E F6 B3 9F E1 A1 87 1E 82 D5 6A F5 3B 
7F FD FA F5 B8 FD F6 DB F1 D6 5B 6F 61 DD BA 75 30 99 4C 98 3E 7D 3A 56 AD 5A 85 FC FC FC 41 7E 
A7 44 03 6F 8C 3D 06 3F 9B 9D 8F 67 36 1D 0A 5A 6E C3 8E 0A 4C CD 4E C2 A4 CC 11 11 AA 19 0D B6 
B3 07 F6 E3 AB 57 57 87 2C 37 F2 EB 97 61 EC 8D 81 53 0A 13 11 D1 D0 11 56 AC 58 31 55 14 C5 CF 
AF BB EE 3A 14 15 15 0D 75 7D 22 AA B1 B1 11 B5 B5 B5 18 35 6A 54 AF B3 E8 A8 AB 97 76 9F C6 B3 
B5 B5 15 95 95 95 88 8F 8F 47 5A 5A 5A C8 01 8E 8A A2 E0 F8 F1 E3 18 33 66 CC A0 76 E9 79 F9 E5 
97 61 B5 5A 71 F3 CD 37 0F DA DF 20 02 80 DF FF 6D 3F 76 1C AC 0D 5A 26 39 DE 82 3F DD 71 29 62 
AD 51 D9 BE 30 AC B8 9A 9A B0 FB 17 3F 87 AB 87 95 C0 7D C5 A4 A7 63 FA 1F FE 08 7D B7 06 10 22 
22 1A 1A 1B 36 6C 40 79 79 79 45 54 F6 E9 57 D9 ED 76 4C 9C 38 31 E8 B4 99 82 20 F4 38 6F 7F 5C 
5C 1C 0A 0A 0A 30 66 CC 98 90 81 5F BD 4E 56 56 16 FB F0 D3 B0 71 D7 F5 05 48 49 B4 04 2D D3 D0 
D2 89 67 FE 37 F8 37 02 74 FE 53 24 09 07 7E FF 48 C8 C0 AF B7 58 30 E9 D7 0F 30 F0 13 11 9D 87 
A2 3A F4 13 51 FF D9 2C 06 DC 33 B7 08 7A 5D F0 0F BD 9F 1C AE C3 3F 77 57 46 A8 56 34 18 CA 56 
AD 44 F3 E1 D0 1F DE 26 FC 62 09 62 C6 86 9E E1 89 88 88 22 8F A1 9F 88 FA AD 70 5C 22 16 5C 91 
15 B2 DC AA 92 63 38 55 EF 88 40 8D 68 A0 D5 7D F0 2F 54 BE BD 39 64 B9 B1 73 6E 44 CA 37 66 45 
A0 46 44 44 D4 1F 0C FD 44 74 4E 16 5C 31 1E 13 C7 25 06 2D E3 74 4B 78 7C C3 01 88 12 A7 F1 BC 
90 38 4E 54 E0 C8 73 CF 86 2C 97 58 54 84 EC 1F FD 38 02 35 22 22 A2 FE 62 E8 27 A2 73 A2 13 80 
A5 F3 8A 60 B3 04 1F AC 7B FC 74 2B 56 95 84 BF DA 35 0D 0D A9 BD 1D 07 1E FD 1D A4 CE CE A0 E5 
CC 49 49 28 BC EF 57 10 74 7C 9C 10 11 9D CF 78 97 26 A2 73 96 92 60 C1 7F 5E 57 10 B2 DC DB 9F 
9E C2 EE 63 0D 11 A8 11 9D AB C3 4F 3F 89 F6 AA AA A0 65 74 7A 3D 0A EF FB 15 4C 89 9C 96 95 88 
E8 7C C7 D0 4F 44 03 E2 1B 45 A3 F0 ED A9 63 42 96 FB C3 C6 43 38 D3 E6 8A 40 8D A8 BF 4E FC 6D 
3D EA 77 7E 12 B2 5C F6 4F 7E 8A 84 89 85 11 A8 11 11 11 9D 2B 86 7E 22 1A 30 3F 9B 9D 8F 31 C9 
B6 A0 65 9A 1D 2E 3C F5 D6 C1 08 D5 88 C2 75 E6 8B 2F 70 FC F5 D7 42 96 1B 75 C5 37 91 7E DD F5 
11 A8 11 11 11 0D 04 86 7E 22 1A 30 66 A3 0E F7 CE 2B 82 D1 10 FC D6 B2 B7 BC 11 6F 7E 74 22 42 
B5 A2 BE 72 D6 D7 E3 D0 13 8F 41 F1 AE 36 DE 1B 5B 46 06 26 DC F5 CB 08 D5 8A 88 88 06 02 43 3F 
11 0D A8 9C D4 38 2C BA 2A 27 64 B9 D7 B6 95 A3 AC A6 35 02 35 A2 BE 50 44 B7 67 01 AE E6 E6 A0 
E5 0C 31 36 4C FA F5 03 D0 71 A1 41 22 A2 0B 0A 43 3F 11 0D B8 1B BE 3E 0E 5F CB EE 7D A5 6B 00 
10 25 19 2B FE 67 3F 3A 5D 52 84 6A 45 C1 1C 7D F1 05 B4 1C 2D 0D 5A 46 10 04 14 14 DF 0D 6B 5A 
E8 B1 1B 44 44 74 7E 61 E8 27 A2 41 71 F7 8D 85 48 B0 99 82 96 A9 6A 6C C7 0B FF 0C 1E 34 69 F0 
9D 7E 6F 2B AA DF 7D 27 64 B9 71 F3 7E 80 E4 4B 67 46 A0 46 44 44 34 D0 18 FA 89 68 50 8C 88 35 
61 C9 0D 13 43 96 7B 6F 6F 35 3E 3C 50 1B 81 1A 51 4F DA BE 2A C7 D1 3F 3F 1F B2 5C D2 94 AF 21 
EB 96 85 11 A8 11 11 11 0D 06 86 7E 22 1A 34 17 E7 26 E3 FB 33 C7 85 2C F7 FC DB 87 51 77 36 F8 
22 50 34 F0 C4 B6 36 1C 78 E4 B7 90 5C C1 A7 50 B5 8C 1C 89 89 F7 2E 03 B8 00 17 11 D1 05 8B 77 
70 22 1A 54 3F FA 56 2E C6 8F 8E 0B 5A C6 D1 29 E2 89 37 0F 40 56 22 54 29 02 14 05 87 9E 78 1C 
1D B5 C1 BF 65 D1 19 8D 28 5A 7E 3F 8C F1 09 11 AA 18 11 11 0D 06 86 7E 22 1A 54 06 BD 80 65 37 
4D 82 D9 A8 0F 5A EE D0 C9 B3 78 E3 FD AF 22 54 2B AA 78 63 1D 1A 3F FF 2C 64 B9 DC DB FF 03 71 
79 79 11 A8 11 11 11 0D 26 86 7E 22 1A 74 63 93 63 F0 D3 6B 43 07 C7 BF 6D 3F 8E 83 27 CF 46 A0 
46 D1 AD E9 B3 DD A8 F8 EB 1B 21 CB A5 5E FD 2D A4 7D E7 DA 08 D4 88 88 88 06 5B 54 87 FE B2 B2 
32 6C DE BC 19 EF BE FB 2E 4E 9D 3A 15 F6 F9 AD AD AD D8 B6 6D 1B 3E FA E8 23 74 74 74 0C 58 59 
A2 E1 E8 3B D3 C6 E0 EB 05 29 41 CB 48 B2 82 27 36 1C 40 5B A7 18 A1 5A 45 9F CE D3 A7 71 E8 C9 
27 A0 28 C1 FB 52 C5 65 65 23 EF 8E 9F 47 A8 56 44 44 34 D8 A2 32 F4 1F 3A 74 08 97 5E 7A 29 72 
73 73 F1 FD EF 7F 1F D7 5E 7B 2D 32 33 33 71 C7 1D 77 84 7C 10 02 80 28 8A B8 F5 D6 5B 91 98 98 
88 AB AF BE 1A 97 5F 7E 39 E2 E3 E3 F1 D4 53 4F 9D 53 59 A2 E1 EE 17 DF 9F 88 E4 04 4B D0 32 F5 
CD 9D F8 E3 FF 1E 8E 50 8D A2 8B EC 72 E1 C0 A3 BF 83 BB 2D F8 A2 68 C6 D8 38 14 FD EA 7E E8 4C 
C1 A7 5C 25 22 A2 0B 47 54 86 FE 97 5E 7A 09 06 83 01 6F BE F9 26 CA CB CB F1 DE 7B EF 21 27 27 
07 2F BC F0 02 D6 AE 5D 1B F2 FC C5 8B 17 63 CD 9A 35 B8 FB EE BB B1 7F FF 7E 7C FE F9 E7 B8 EC 
B2 CB 70 CF 3D F7 E0 B5 D7 5E EB 77 59 A2 E1 2E D6 6A C0 D2 B9 45 D0 E9 84 A0 E5 3E 3A 54 8B 92 
CF AB 23 54 AB E8 71 F4 CF CF A3 F5 AB F2 A0 65 04 41 C0 C4 7B 96 C2 32 7A 74 84 6A 45 44 44 91 
10 95 A1 FF C1 07 1F C4 8E 1D 3B 70 E3 8D 37 22 2B 2B 0B 57 5D 75 15 56 AC 58 01 00 F8 D7 BF FE 
15 F4 DC 9A 9A 1A AC 5D BB 16 73 E7 CE C5 8A 15 2B 50 54 54 84 A9 53 A7 62 C3 86 0D 30 9B CD 58 
B9 72 65 BF CA 12 45 8B A2 8C 44 CC FF C6 F8 90 E5 56 BE 5B 8A CA 86 F6 08 D4 28 3A 54 BF F3 4F 
D4 BC B7 35 64 B9 CC FF F7 EF 48 9A 7E 71 04 6A 44 44 44 91 64 18 EA 0A 0C 05 BB DD 1E 70 2C 36 
36 16 00 60 34 1A 83 9E BB 7E FD 7A 48 92 84 05 0B 16 F8 1D 4F 4E 4E C6 15 57 5C 81 AD 5B B7 A2 
AE AE 0E 29 29 29 61 95 0D 97 C3 E1 C0 99 33 67 02 8E BB DD 6E 08 82 80 CA CA CA B0 AF 49 14 29 
B3 72 8C D8 79 D8 82 E3 75 BD CF CD DF E9 92 F0 BB 37 3E C7 7D DF CF 84 41 1F FC 9B 01 0A AE B3 
E2 38 2A 5F 7A 21 64 B9 98 C2 22 18 BE 31 8B F7 0F 1A B6 52 52 52 60 62 B7 35 8A 52 51 19 FA BB 
53 14 05 2F BE F8 22 00 60 CE 9C 39 41 CB 1E 39 72 04 00 30 6D DA B4 80 D7 0A 0A 0A B0 65 CB 16 
54 55 55 21 25 25 25 AC B2 E1 2A 2D 2D 45 49 49 49 C0 71 A3 D1 08 B7 DB DD A7 6E 4A 44 43 C9 AE 
98 71 52 28 84 A4 F4 3E 95 E7 A9 46 27 1E 79 ED 43 64 19 4E 46 B0 66 C3 8B C1 ED C2 45 5F EC 85 
49 0C 3E 38 DA 69 36 E3 B3 D8 78 88 AF BF 1E A1 9A 11 45 DE A2 45 8B 90 96 96 36 D4 D5 20 1A 12 
51 1B FA 77 EE DC 89 4F 3F FD 14 F5 F5 F5 78 E7 9D 77 50 5E 5E 8E 27 9E 78 02 D7 5E 1B 7C 7A BA 
5A EF 42 36 89 89 89 01 AF 25 25 25 01 00 1A 1B 1B C3 2E 1B AE AC AC 2C CC 9D 3B 37 E0 F8 B6 6D 
DB 60 34 1A 31 6B D6 AC 7E 5D 97 28 92 0A 2A 1C 58 FB 51 F0 FF 07 AA C5 51 F8 DE 37 8A 50 90 66 
8D 50 AD CE 4F 7D 99 64 20 80 2C A3 71 E5 8B 70 BA 9C 41 8B 09 06 03 C6 FE FC 2E 64 8D 49 EF 67 
ED 88 2E 0C EA B3 97 28 1A 45 6D E8 DF BC 79 33 9E 7F FE 79 B4 B7 B7 43 92 24 4C 98 30 01 9D 9D 
9D 70 B9 5C 41 BF FA 3B 7B D6 33 87 B8 D9 6C 0E 78 CD 62 F1 CC 4A D2 D6 D6 16 76 D9 70 25 26 26 
F6 F8 61 62 FB F6 ED B0 5A AD C8 E3 62 3A 74 01 C8 CB 03 6A DA 0F E1 BD BD C1 07 ED FE 6D 77 33 
FE 74 47 01 12 6D D1 F7 B5 BC 1A F6 9B 4B 8F E0 74 49 09 14 28 7D FE 00 D0 56 56 06 E7 89 0A 40 
E8 A1 7B 94 CF 35 26 FC FC 2E 8C BE F2 DF 06 A2 BA 44 44 74 9E 8A DA D0 FF E8 A3 8F E2 D1 47 1F 
85 28 8A 38 74 E8 10 EE BF FF 7E 3C F0 C0 03 D8 B3 67 0F DE 7A EB AD 5E CF 4B 48 F0 2C 45 DF D2 
D2 82 98 98 18 BF D7 5C 2E 17 80 AE 31 03 E1 94 25 8A 56 FF 31 3B 1F 87 4E 9E 45 75 63 EF 83 76 
CF B6 B9 F0 F4 5B 07 F1 5F B7 7C 2D 82 35 1B 7A 8A A2 68 5B ED FB EF A3 66 6B 09 0C 7D ED 8F EC 
3D 4F AF 0F EC 3E 25 8B 22 20 08 50 14 05 A9 D7 5C 8B 51 57 5D 3D C0 35 27 22 A2 F3 4D D4 86 7E 
95 C1 60 C0 45 17 5D 84 0D 1B 36 20 3F 3F 1F 1B 37 6E C4 D1 A3 47 7B 6D 29 4F 4E 4E 06 E0 69 C5 
1F DD 6D 4A 3B B5 3B 8F DA 47 3F 9C B2 44 D1 CA 62 D2 E3 DE 79 45 B8 67 D5 67 C8 D1 C4 24 00 00 
20 00 49 44 41 54 10 25 B9 D7 72 9F 97 35 62 D3 27 27 31 67 E6 B8 08 D6 6E E8 A8 61 5F 96 65 6D 
13 04 01 33 AF BC CA 53 40 00 A0 78 F7 00 04 08 50 A0 40 40 CF 83 9E 15 45 81 E0 0D FA 9F 7F B4 
03 ED 6D 6D 88 CD C9 45 F6 E2 C5 DA 37 07 42 4F DF 08 10 11 D1 B0 10 95 53 76 F6 C4 64 32 A1 B0 
B0 10 00 50 57 57 D7 6B B9 EC EC 6C 00 C0 EE DD BB 03 5E DB B3 67 0F 12 12 12 90 99 99 19 76 59 
A2 68 96 9B 16 8F 85 57 65 87 2C F7 EA 7B 65 F8 EA 74 F0 85 A5 86 13 35 F4 BB DD 6E 48 92 E4 39 
26 4B 50 64 09 B2 D8 B5 97 45 09 92 28 6A FB 9E 36 45 96 B4 3D 00 08 06 3D B2 7F 59 0C 59 D0 F5 
6F BC 00 11 11 5D 50 A2 32 F4 57 54 54 04 1C 6B 6E 6E C6 67 9F 7D 06 9D 4E 87 49 93 26 69 C7 6B 
6A 6A 70 E0 C0 01 ED F7 9B 6E BA 09 00 B0 6E DD 3A BF 07 E5 FE FD FB B1 73 E7 4E CC 9F 3F 5F EB 
C3 1F 4E 59 A2 68 37 F7 B2 0C 4C C9 0A 3E C8 CE 2D CA 78 FC 7F 0E C0 E9 EE FD 1B 81 E1 C0 B7 5B 
8F 24 49 70 BB DD 10 BD B3 EF 48 2E 17 24 97 0B B2 BB 6B 2F BB 5D 90 5D 3E 7B 57 B7 63 6E 17 44 
67 D7 5E 51 14 98 52 D3 80 F8 78 48 92 04 59 96 B5 BF 47 44 44 C3 53 54 86 FE 69 D3 A6 E1 5B DF 
FA 16 5E 78 E1 05 BC F3 CE 3B 78 F9 E5 97 31 6B D6 2C D4 D6 D6 62 D9 B2 65 5A 5F 7C 00 98 35 6B 
16 26 4D 9A 84 13 27 4E 00 00 72 72 72 30 67 CE 1C 94 94 94 E0 96 5B 6E C1 A6 4D 9B B0 6A D5 2A 
CC 9E 3D 1B 76 BB 1D C5 C5 C5 DA B9 E1 94 25 22 E0 EE 1B 8B 90 10 62 B0 6E 65 83 03 2F BD 53 1A 
A1 1A 0D 2D 59 96 21 49 12 5C 2E 97 D6 D2 2F 8B A2 77 93 7C F6 12 64 D9 67 2F 7B 5F 53 F7 DE 16 
7E 75 2F 28 0A 04 AB 55 FB 30 C1 C0 4F 44 34 FC 45 65 9F FE 27 9F 7C 12 2B 56 AC C0 1D 77 DC A1 
1D 4B 4D 4D C5 B3 CF 3E 8B 3B EF BC D3 AF AC DD 6E 47 75 75 B5 B6 78 17 E0 59 A0 EB F6 DB 6F C7 
5B 6F BD 85 75 EB D6 C1 64 32 61 FA F4 E9 58 B5 6A 15 F2 F3 F3 FD CE 0F A7 2C 51 B4 4B 8A 33 E1 
97 73 26 E2 E1 75 5F 04 2D 57 F2 79 15 A6 66 DB 71 79 E1 F0 1D 13 E3 DB A7 5F 92 24 2D F4 4B 6E 
B7 5A C0 33 2B 8F 1A D6 D5 9F 7B EB 97 EF 53 5E 81 E7 03 85 28 8A DA 78 81 9E 06 FC 12 11 D1 F0 
11 95 A1 FF B6 DB 6E C3 6D B7 DD 86 C6 C6 46 D4 D6 D6 62 D4 A8 51 BD CE A2 F3 C9 27 9F C0 ED 76 
FB 4D E3 69 32 99 F0 CA 2B AF 60 F5 EA D5 38 7E FC 38 C6 8C 19 D3 6B 37 9D 70 CA 12 11 30 23 2F 
19 D7 5D 32 16 6F 7F 7A 2A 68 B9 E7 DE 3E 8C FC F4 78 8C 4C B0 44 A8 66 43 43 0D FD 6A 4B BC E4 
9D F9 2B 40 F7 0F 01 DD F9 7E 28 F0 E9 3A 24 CB B2 F7 74 B6 F4 13 11 0D 67 51 D9 BD 47 65 B7 DB 
31 71 E2 C4 A0 D3 66 0A 82 D0 EB BC FD 82 20 20 2B 2B AB 4F 21 3E 9C B2 44 D1 EE C7 DF CE 45 E6 
A8 D8 A0 65 DA 3A DC 78 E2 CD 03 90 87 71 56 F5 ED DB AF 86 F2 AE EE 3D DD 36 49 EA DA 4B DE 2E 
3E 52 57 77 1F 45 EA DA 7B A6 FD E9 0A FA 0C FC 44 44 C3 5F 54 87 7E 22 3A 3F 19 0D 3A DC 3B 6F 
12 4C C6 E0 5D 4E 0E 9E 38 8B BF 7E 70 3C 42 B5 1A 3A BE A1 5C 72 BB 20 B9 5D 90 DD 6E 6D EF D9 
5C 3E 7B 17 24 67 D7 5E 72 BA 20 3A 9D DA DE 37 EC 33 F0 13 11 45 07 86 7E 22 3A 2F 65 A4 D8 B0 
F8 9A DC 90 E5 FE FA C1 57 38 7C AA 39 02 35 3A 3F 28 92 B7 D5 5E 14 B5 BD 2C 8A 90 BC 03 7B 25 
51 82 E4 9D CE 53 DD 7B 36 59 DB 83 39 9F 88 28 EA 30 F4 13 D1 79 6B F6 C5 E9 B8 74 C2 C8 A0 65 
24 59 C1 13 1B 0E A0 DD 29 46 A8 56 43 4B 9D B2 B3 FB D6 7D 0A CF EE 2D FD 92 CB A9 ED 7B ED F7 
4F 44 44 C3 16 43 3F 11 9D D7 7E 39 67 22 EC F1 C1 C7 C2 D4 9E ED C0 73 9B 0F 47 A8 46 43 4B 74 
3A 3D 5D 75 DC 2E 6D EF FB 73 5F 5E 67 97 1E 22 A2 E8 C3 D0 4F 44 E7 B5 38 AB 11 F7 DC 58 04 9D 
AE 97 A9 28 BD 3E 3C 50 8B AD 7B AB 23 54 AB A1 D3 5B F7 1E 45 92 B5 BD 67 93 7C F6 DE EE 3D DE 
3D FB F7 10 11 45 1F 86 7E 22 3A EF 5D 34 7E 04 E6 5D 96 11 B2 DC 8B FF 2C 45 75 63 7B 04 6A 34 
74 24 B7 DB BB B9 7C F6 81 5B 40 CB BF CF 9E 2D FD 44 44 D1 87 A1 9F 88 2E 08 3F FC B7 6C E4 A7 
27 04 2D D3 E9 92 F0 F8 86 03 10 A5 E1 1B 6A BB 5A FA BB F6 FE AB F3 06 AE C0 AB 78 A7 EF 54 F7 
6C E8 27 22 8A 3E 0C FD 44 74 41 D0 EB 04 DC 3B AF 08 31 E6 E0 6B 0A 96 55 B7 60 CD B6 B2 08 D5 
2A 82 14 05 50 14 AD E5 5E F6 B6 E2 6B 03 77 7D 06 F3 86 DA D8 D2 4F 44 14 7D 18 FA 89 E8 82 31 
7A 84 15 FF F1 DD 09 21 CB 6D FC F8 24 F6 96 37 45 A0 46 91 E3 3E 75 12 00 B4 90 EF 1B FC 7B 1E 
B8 DB B5 17 9D EA 39 9E 3D 67 EF 21 22 8A 3E 0C FD 44 74 41 F9 B7 C9 A3 71 E5 E4 D4 A0 65 14 45 
C1 D3 1B 0F A2 A5 DD 1D A1 5A 0D AE 8E C3 87 20 56 56 02 80 D6 9D 47 91 65 6D EF 3B 48 B7 6B E0 
AE CF 5E 56 CF F1 EC D9 BF 87 68 78 3B 55 EF 18 EA 2A D0 79 28 F8 F7 E4 44 44 E7 A1 3B BF 3B 01 
47 4E 35 A3 A6 A9 F7 41 BB 4D AD 4E 3C BD F1 20 1E FA F7 29 11 AC D9 C0 73 9F 39 83 DA 57 56 03 
F0 44 F5 7A 7D 90 55 8A 85 E0 33 1C A9 14 F0 E6 4F 34 5C FD 6D 7B 05 D6 BC 57 86 AB A6 A4 62 C9 
9C C2 BE DE 16 28 0A F0 BE 4F 44 17 1C AB 59 8F A5 F3 8A B0 F4 E5 CF 20 49 F2 FF 67 EF CE E3 A3 
A8 B2 05 8E FF 7A EF 4E 67 4F 08 5B 80 04 08 10 76 02 28 02 22 28 88 86 45 46 10 10 05 1C 1D 07 
18 47 66 40 C4 65 44 45 41 14 61 86 E7 3A F8 10 44 44 45 D9 5C D8 E1 29 82 08 41 10 08 3B 84 B0 
87 35 81 24 9D A5 97 AA F7 47 E8 26 4D B6 0E 24 24 90 F3 FD 7C 6A 2A A9 BA 55 75 DB 21 DD A7 6E 
9F 3A B7 C8 76 5B 0F 5E E0 FB CD 27 E8 DB A1 CE 4D EC 5D 19 52 14 8E 7F FC 21 AE CC 8C BC DF 35 
A0 68 0A F9 82 56 AB C5 51 BD 06 6A 31 37 04 1A 8D 06 8D 46 83 56 AB 45 AF D7 63 6A D5 DA B3 4D 
08 71 7B 70 07 FC 16 B3 99 75 3B 52 00 CA 35 F0 3F 7E FC 38 E9 E9 E9 34 6F DE BC 7C 2E 20 CA 94 
04 FD 42 88 5B 52 E3 DA 81 3C DE AD 3E 73 D7 16 FF D0 EE A7 AB 0F D2 3C 2A 98 88 20 33 DF 6C 38 
CA 83 ED 6A 53 23 C4 02 50 E9 03 DE 13 0B BE 26 63 DF DE AB 1B 54 CF FF 5C A5 D1 90 79 FF 03 38 
6B D5 2E F2 3C EE E0 5E AF D7 63 32 99 30 5A AD 58 02 02 D0 6A B5 12 F8 0B 51 C1 B2 73 5D A4 A4 
65 A3 28 37 96 76 B7 E6 8F D3 FC 98 70 82 B0 E0 10 9A 37 8A 25 E9 F8 51 D6 ED 38 4D 7A 96 83 C7 
BA 36 B8 A1 C0 5F AB 85 88 20 0B FE 16 EF B0 71 F8 F0 E1 FC FC F3 CF 52 1C E0 16 21 41 BF 10 E2 
96 F5 48 E7 28 FE 48 4A 65 57 72 D1 0F ED 3A 5D 2A EF 7C 93 88 D9 A8 E7 70 4A 3A EB 13 CF F2 D6 
F0 D6 D4 0C F5 F3 B4 A9 8C 41 EF A5 1D 7F 70 72 D1 B7 25 B6 73 B6 BF 03 43 83 86 18 8A 69 E3 7E 
7D 7A BD 1E A3 D1 88 D1 68 C4 60 30 A0 D3 E9 24 F0 17 A2 82 38 9C 0A FF BB EA 20 AB B6 9D C6 59 
CC 37 96 A5 11 12 18 4C 4C 74 23 1C 2E 85 BA B5 EB E0 52 14 B6 1E 3C C3 D6 83 17 6E F8 DC 5A AD 
86 CE CD AA F3 6C 9F 26 9E 2A 6A 12 EC DF 5A E4 41 5E 21 C4 2D 4B A3 81 71 FD 9B 11 E0 57 5C C8 
0B A7 52 B3 49 3A 9B 41 83 3A 75 B9 9C ED E4 A5 CF FE E0 F4 45 1B 8A A2 A0 AA 6A A5 FB E0 B2 A7 
A6 B2 6F FA B4 12 DB 69 EA 45 E1 77 6F 77 02 02 02 8A 5D FC FD FD 3D 6B AB D5 8A C5 62 C1 64 32 
79 02 7F 09 F8 85 B8 F9 DE FF 61 1F CB 12 4E 96 59 C0 1F 14 10 44 74 DD FA 38 5C 2E 72 1D 4E EC 
0E 17 B5 6A 44 52 3D 3C A2 4C CE AF 28 2A BF 24 9E 61 D2 57 BB CA E4 7C E2 E6 93 A0 5F 08 71 4B 
0B 0B 30 F1 CF 87 9A 16 B9 5F A3 D1 A0 02 CD 1A 34 A6 41 DD 28 DA 34 69 46 7A 8E 8B 97 E7 EE A8 
9C 81 BF A2 B0 6F DA 54 1C E9 97 8B 6D A6 0B 08 24 6C E8 70 82 82 83 09 0A 0A 2A 76 09 BE D2 26 
30 30 90 80 80 00 4F E0 6F 34 1A 65 B4 5F 88 0A 90 92 9A ED C9 B9 2F 0B 81 FE 81 44 D6 8E C2 A1 
A8 E4 3A 9C 79 8B 33 6F 1D 11 51 8B F0 D0 6A 65 76 AD 9D C9 A9 EC 3E 76 C9 E7 F6 AA AA 32 73 E6 
4C 06 0E 1C 48 CB 96 2D 89 8F 8F E7 CD 37 DF 24 27 27 C7 D3 66 C5 8A 15 C4 C7 C7 B3 6D DB 36 AF 
63 97 2F 5F 4E 7C 7C 3C 7F FC F1 87 D7 F6 CD 9B 37 13 1F 1F CF 96 2D 5B 8A BC EE 63 8F 3D C6 57 
5F 7D 45 4A 4A 0A 23 47 8E A4 65 CB 96 F4 EE DD 9B D9 B3 67 17 68 BB 7F FF 7E C6 8E 1D 4B 87 0E 
1D 68 D6 AC 19 F1 F1 F1 7C F1 C5 17 05 3E 17 92 92 92 78 F2 C9 27 89 8B 8B 23 2E 2E 8E B1 63 C7 
72 F9 F2 65 9F F7 57 34 09 FA 85 10 B7 BC 0E 4D AA 11 DF 3E B2 C0 76 77 C0 DF 24 3A 86 6A A1 61 
D8 9D 2E FC FC FC 69 1E 13 4B 7A 8E 8B 7F 7D BE B3 D2 05 FE C9 F3 BF 20 2D B1 84 91 34 8D 86 9A 
7F 79 9A 90 C8 48 82 83 83 4B 5C F2 DF 00 B8 83 7E B3 D9 EC 35 D2 2F 01 BF 10 37 4F F2 D9 CC 32 
3B 97 5E AF A7 7A 8D 3A 38 5D 0A B9 0E 27 0E A7 0B 87 D3 45 AE E3 EA 3A 34 AC 06 16 8B 5F C9 27 
F3 D1 91 33 19 3E B5 73 38 1C F4 EC D9 93 91 23 47 92 92 92 42 E7 CE 9D B1 D9 6C BC FA EA AB B4 
6D DB D6 13 10 87 86 86 B2 62 C5 0A E6 CD 9B E7 75 FC 9C 39 73 58 B1 62 05 5F 7E F9 A5 D7 F6 79 
F3 E6 B1 62 C5 0A 6A D6 2C BA 7C F3 8F 3F FE C8 E7 9F 7F 4E AB 56 AD D8 B4 69 13 AD 5B B7 66 E7 
CE 9D 3C F5 D4 53 4C 9A 34 C9 D3 2E 2D 2D 8D 56 AD 5A F1 C3 0F 3F 10 17 17 47 7C 7C 3C C7 8F 1F 
67 E8 D0 A1 7C F4 D1 47 9E 76 E7 CE 9D E3 AE BB EE 62 C3 86 0D 3C FC F0 C3 F4 EC D9 93 1F 7E F8 
81 9F 7E FA C9 A7 FD 95 81 66 EA D4 A9 71 4E A7 73 5B 9F 3E 7D 2A F4 E9 6B 97 CB C5 AE 5D BB 70 
38 1C 34 69 D2 84 C0 C0 C0 42 DB 1D 3A 74 88 D4 D4 54 62 62 62 08 0D 0D BD A1 6B 1E 3D 7A 94 C4 
C4 44 4C 26 13 2D 5A B4 28 F6 1F 4F 7E 69 69 69 9C 39 73 A6 C0 76 B3 D9 4C 74 74 74 A1 C7 64 64 
64 90 90 90 80 D9 6C 26 2E 2E 0E 8B C5 72 43 7D 2F CA A7 9F 7E 8A C5 62 61 C8 90 21 E5 72 7E 21 
2A AB 5C 87 8B 7F CC 4C F0 D4 A7 76 07 FC 8D A2 1A 52 3D 3C BC 40 FB F4 8C 74 F6 26 1D 20 D0 AC 
63 D2 D0 96 D4 0A B3 56 F8 88 77 DA 1F DB D9 F9 EA 2B 25 DE 7C D4 EC 3F 80 9A 0F 0F 28 F5 4D 8A 
BB 7A 8F 56 AB F5 8C F0 BB D7 EE FD 42 88 F2 B7 FB D8 25 5E 98 FD 7B 99 9D CF CF 2F 80 A0 E0 9A 
A0 51 01 F7 DF B1 FB 67 95 CC 8C 54 32 D2 2F 96 D9 F5 C6 0F 68 CE 3D 2D 6A D0 B5 6B 57 D6 AF 5F 
5F E4 7B D1 07 1F 7C C0 B3 CF 3E CB 9B 6F BE C9 2B AF BC E2 D9 FE CE 3B EF F0 E2 8B 2F F2 F2 CB 
2F 33 79 F2 64 54 55 A5 76 ED DA F8 FB FB 73 F0 E0 41 00 14 45 A1 5A B5 6A A4 A6 A6 D2 B4 69 53 
F6 EC D9 E3 39 3E 3A 3A 9A 90 90 10 B6 6F DF 5E 64 1F 83 82 82 48 4F 4F 67 EC D8 B1 BC FB EE BB 
68 B5 5A 2E 5E BC 48 5C 5C 1C 17 2F 5E E4 F4 E9 D3 04 06 06 E2 70 38 58 B5 6A 15 BD 7A F5 F2 BC 
07 66 65 65 51 AF 5E 3D 22 23 23 3D DF 32 7C F6 D9 67 FC F9 CF 7F 66 C3 86 0D 74 EE DC 19 C8 8B 
5D 5D 2E 17 46 A3 B1 C4 FD 15 69 E1 C2 85 24 25 25 1D AD 34 23 FD FB F7 EF 27 2E 2E 8E 3B EF BC 
93 91 23 47 16 DA E6 C4 89 13 34 6E DC 98 0E 1D 3A F0 E1 87 1F 5E F7 B5 F6 ED DB C7 DD 77 DF 4D 
74 74 34 7D FB F6 A5 67 CF 9E 44 46 46 32 66 CC 18 9F 3E 44 FB F6 ED 4B D3 A6 4D 0B 2C 8D 1A 35 
2A 70 BC D3 E9 E4 89 27 9E 20 38 38 98 EE DD BB D3 B9 73 67 02 03 03 99 3E 7D FA 75 F7 5F 08 E1 
4D 55 55 0C 3A 0D CF 3F DC 14 BD 2E 2F 68 57 55 A8 5F 27 9A 90 A0 60 EC 4E 17 76 87 33 6F 7D 65 
31 5B AC C4 44 C5 90 9E ED E2 95 79 BB 2A 7C C4 DF 9E 9A CA DE 69 EF 96 78 ED A0 16 2D 89 7E F4 
31 CC 66 33 16 8B 05 B3 D9 EC D3 E2 6E 6B 32 99 30 1A 8D E8 F5 7A 09 F8 85 A8 20 4D EB 04 79 15 
13 B8 51 59 59 19 A4 A6 9D C6 EE 70 61 77 3A AF 2C 79 3F 5F BE 7C B1 4C 03 FE 00 8B 81 76 31 05 
07 52 0A F3 DF FF FE 97 F0 F0 70 C6 8F 1F EF B5 7D CC 98 31 84 86 86 F2 CD 37 DF 00 79 EF 3F 7D 
FA F4 E1 D0 A1 43 1C 3A 74 08 80 ED DB B7 93 9A 9A 4A 7C 7C 3C 7B F7 EE E5 E8 D1 A3 40 5E 0C 77 
F4 E8 51 FA F5 EB 57 E2 F5 DB B7 6F CF F4 E9 D3 3D EF 73 61 61 61 0C 1B 36 0C 9B CD E6 19 81 37 
18 0C F4 EE DD DB EB 3D D0 CF CF 8F 96 2D 5B 72 EC D8 B1 AB AF 3B 20 00 80 95 2B 57 7A B6 E9 74 
3A 4F 40 5F D2 FE CA A0 D2 04 FD CD 9A 35 A3 5E BD 7A 00 2C 5B B6 0C BB DD 5E A0 CD D2 A5 4B 3D 
1F 88 BD 7B F7 BE EE 6B 7D F4 D1 47 5C B8 70 81 0F 3F FC 90 0D 1B 36 F0 E9 A7 9F 12 16 16 C6 8C 
19 33 F8 F4 D3 4F 4B 3C 3E 2B 2B 8B 16 2D 5A 30 6F DE 3C AF 65 D1 A2 45 05 3E 38 9F 7E FA 69 E6 
CE 9D CB 73 CF 3D 47 62 62 22 DB B6 6D A3 53 A7 4E 8C 1B 37 8E CF 3F FF FC BA 5F 83 10 22 8F 3B 
48 57 55 95 10 AB 9E 60 AB 09 55 85 7A 91 51 04 05 85 60 77 29 79 01 BF 7B 9D 6F 31 99 2C 44 D7 
AD CF E5 8A 0E FC 15 85 BD EF BE 83 FD 72 F1 79 B2 C6 E0 10 9A 3D FF 02 7A 83 01 BD 5E 8F 5E AF 
C7 60 30 F8 B4 B8 DB E7 0F F6 25 E0 17 A2 62 68 B5 1A 5E 1C D8 82 20 6B D9 05 84 B9 D9 99 A4 5F 
3E 4B AE DD E9 C9 EB CF C8 48 25 2B B3 E8 EA 66 A5 65 36 EA 18 FF 48 0B AC E6 92 8B 3F 2A 8A C2 
E1 C3 87 69 DE BC 79 81 C0 D7 68 34 12 1B 1B CB B1 63 C7 70 B9 5C 00 3C F4 D0 43 40 5E 0C 08 B0 
66 CD 1A 02 02 02 98 38 71 22 90 97 F7 0F 79 79 FE F9 DB 17 A7 B0 AC 91 66 CD 9A 01 79 03 C9 F9 
25 24 24 30 69 D2 24 9E 79 E6 19 86 0D 1B C6 FE FD FB BD 62 D1 3E 7D FA D0 A9 53 27 26 4F 9E 4C 
5C 5C 1C B3 67 CF 26 37 37 D7 E7 FD 95 41 A5 2A D9 F9 C8 23 8F 30 6D DA 34 D2 D3 D3 59 B7 6E 1D 
0F 3E F8 A0 D7 FE EF BE FB 0E 80 86 0D 1B D2 A6 4D 9B EB BE CE F3 CF 3F CF BF FF FD 6F 0C 86 BC 
8A 1F 9D 3B 77 C6 60 30 30 6C D8 30 BE FB EE 3B FE F2 97 BF 94 78 8E 9A 35 6B F2 F8 E3 8F 17 DB 
26 25 25 85 79 F3 E6 D1 BF 7F 7F A6 4E 9D EA D9 BE 70 E1 42 22 23 23 F9 E4 93 4F 18 36 6C D8 75 
BD 06 9B CD 46 5A 5A 5A 81 ED 0E 87 03 8D 46 C3 C9 93 27 AF EB BC 42 DC 4A F2 07 FC 99 D9 0E DE 
5F 9D C2 C5 0C 3B 75 6A D5 25 28 30 D8 33 71 97 8A 8A 06 0D EA 95 1A F7 EE 9F 35 68 30 9B AD D4 
8B 8C E6 E8 89 23 BC F4 D9 1F FC F3 C1 5A 54 0B 34 DE D4 54 9F 8B DF 2D F5 29 8F BF DA 13 7F E6 
9C CD 06 36 DB 0D 5F 53 02 7D 51 15 45 44 44 54 9A 91 D7 86 35 03 F8 E4 D9 8E AC DB 99 C2 C9 0B 
36 5C 37 58 A7 7F FF 89 4B 1C 3B 67 C3 A5 AA E8 4C 21 28 8E 0C 5C 39 E9 54 0B 32 D1 BA 7E 18 5A 
ED F5 FF CD 6B 35 1A 6A 84 58 E8 D6 AA 06 61 01 26 9F 8E C9 CE CE 26 37 37 B7 C8 74 66 93 C9 84 
A2 28 28 8A 82 4E A7 E3 BE FB EE C3 6A B5 B2 6C D9 32 FE F9 CF 7F B2 66 CD 1A BA 76 ED 4A BB 76 
ED A8 5D BB 36 CB 97 2F 67 D4 A8 51 AC 58 B1 82 A8 A8 28 5A B5 6A 75 5D AF C5 1D FB B9 DF 03 9D 
4E 27 03 07 0E 64 C9 92 25 74 EC D8 91 D8 D8 58 82 82 82 3C ED DC 8C 46 23 3F FD F4 13 B3 66 CD 
E2 C3 0F 3F E4 A9 A7 9E 62 CA 94 29 AC 5E BD 9A E8 E8 E8 12 F7 57 06 95 2A E8 1F 38 70 20 D3 A6 
E5 95 A9 5B BA 74 A9 57 D0 9F 96 96 C6 FA F5 EB 3D ED 6E 44 DD BA 75 0B 6C 73 3F CF 50 96 4F 59 
2F 58 B0 00 97 CB C5 E0 C1 83 BD B6 87 87 87 73 CF 3D F7 B0 66 CD 1A CE 9D 3B 47 44 44 E9 CB 69 
1D 38 70 80 55 AB 56 15 D8 6E 30 18 70 38 1C 05 1E 86 11 E2 76 E3 1E 89 57 55 15 A7 AA 63 8F 33 
16 9B 6A A5 66 8D BA 58 FD 83 B0 3B 5D C5 1D 8D 3B D7 15 40 6F 30 13 59 AB 1E 27 4E 1D E5 AD 45 
87 69 A6 DF 83 45 6B F7 7C 28 94 67 80 1C 7C 29 8D 26 7B 12 4B 6C 77 B2 4E 5D 36 6F FD 1D B6 96 
5D 1E B0 10 55 CD F0 E1 C3 A9 55 AB 56 45 77 C3 C3 DF A2 E7 A1 32 9C 31 FC 7F 57 1E 64 E9 6F C7 
51 9C 76 50 9C B4 6F 14 CE 2B 83 5B A1 D7 DD FC 9B 7C AB D5 4A 78 78 B8 27 2D E7 5A C9 C9 C9 D4 
AB 57 CF 13 5C 9B 4C 26 7A F6 EC C9 8F 3F FE C8 B9 73 E7 D8 B4 69 93 67 C0 F4 C1 07 1F E4 CB 2F 
BF E4 FC F9 F3 6C D8 B0 A1 C8 34 70 5F 1C 39 72 04 B8 1A 0B 7E FB ED B7 2C 59 B2 84 69 D3 A6 F1 
DC 73 CF 79 DA 25 25 25 F1 CB 2F BF 78 1D 6B 30 18 18 35 6A 14 A3 46 8D 62 EE DC B9 3C F1 C4 13 
4C 98 30 81 2F BE F8 C2 A7 FD 15 AD 52 05 FD ED DB B7 27 3A 3A 9A E4 E4 64 BE FB EE 3B 3E FE F8 
63 CF D7 CF CB 97 2F C7 E9 74 02 37 1E F4 17 C6 FD E0 48 A3 46 8D 7C 3E C6 1D 74 14 15 10 EC DF 
BF 1F 80 B6 6D DB 16 D8 17 1B 1B CB EA D5 AB 39 75 EA D4 75 05 FD F5 EB D7 A7 7F FF FE 05 B6 AF 
5B B7 0E 83 C1 40 97 2E 5D 4A 7D 4E 21 6E 25 AA AA 7A 46 89 56 EF 4E C7 B6 D7 46 70 70 18 FE FE 
81 38 5D 0A 1A 0D 5C CD D0 F1 0E F2 F3 72 FE 15 AF BF 5D A3 C9 8F F0 F0 1A 9C 3B 77 1A 47 F5 0E 
3C DA 29 D4 93 02 53 5E 41 BF EB F2 65 CE 4D 9B 4A 49 55 BA 4D 31 8D B8 73 E4 DF B8 53 46 E7 85 
B8 21 37 5A 00 A4 B2 7B FA 81 BC 18 66 E9 6F C7 2B 34 E0 77 EB D8 B1 23 DF 7F FF 3D 9B 37 6F A6 
43 87 0E 9E ED 6B D7 AE 25 39 39 99 D1 A3 47 7B B5 7F E8 A1 87 58 BC 78 31 AF BE FA 2A B9 B9 B9 
F4 E8 D1 03 80 F8 F8 78 66 CD 9A C5 84 09 13 B0 DB ED 3E E5 F3 03 6C DA B4 89 35 6B D6 78 CE E3 
74 3A F9 F2 CB 2F 31 99 4C DC 71 C7 1D 40 DE 33 02 00 71 71 71 9E E3 72 72 72 38 75 EA 54 B1 E7 
1E 3E 7C 38 CF 3F FF 3C 29 29 85 97 5E 2D 69 7F 45 A8 54 41 3F E4 A5 F8 4C 9D 3A 95 B3 67 CF F2 
DB 6F BF D1 A9 53 27 20 6F E4 1F F2 82 F2 EB FD 4A A7 38 EE BA AD 8F 3D F6 58 89 6D 35 1A 0D EB 
D6 AD 43 A7 D3 A1 D7 EB 89 8A 8A E2 EE BB EF E6 B5 D7 5E F3 FA 16 E1 EC D9 B3 00 04 07 07 17 38 
87 FB 8D E7 E2 C5 EB 7B B8 C6 5D 8A EF 5A 1B 36 6C C0 62 B1 94 EA E6 45 88 5B 8D 3B A5 47 51 14 
1C 0E 07 0F 87 D8 48 3C BD 8F F3 E9 69 18 8D 7E 98 2D D6 2B 81 7D C1 74 1E 28 98 EE 03 1A 1C F6 
1C 52 53 CF 61 35 E9 19 D2 B5 3E D1 91 21 E5 5B D2 52 51 D8 F1 AF 97 50 6C C5 97 EE 33 85 84 D2 
FE B5 89 18 0A F9 7B 17 42 88 6B 3D FD 40 23 EE 8A 8D 20 B6 4E 10 BA 1B 48 E9 29 8D FC 95 79 20 
6F C4 FB 95 57 5E E1 8D 37 DE 60 D9 B2 65 F4 EE DD 9B 09 13 26 10 1B 1B CB AE 5D BB 78 E3 8D 37 
08 0F 0F 2F 70 5C AF 5E BD D0 E9 74 CC 9A 35 8B DA B5 6B 13 1B 1B 0B 40 F7 EE DD 31 18 0C CC 9A 
35 8B 90 90 10 EE BE FB 6E 9F FA E5 74 3A E9 DB B7 2F 7F FF FB DF B9 F3 CE 3B 99 37 6F 1E 3B 76 
EC E0 6F 7F FB 1B D5 AB 57 07 A0 5D BB 76 00 4C 9C 38 11 AD 56 8B CD 66 63 F2 E4 C9 EC DD BB 17 
93 E9 6A 2A D3 93 4F 3E 89 D1 68 64 E0 C0 81 84 85 85 B1 68 D1 22 CE 9F 3F 4F F7 EE DD 7D DA 5F 
19 54 BA A0 7F E0 C0 81 9E AF 73 96 2C 59 42 A7 4E 9D C8 CD CD F5 3C 0D 5D 1E A3 FC 8B 17 2F 66 
F5 EA D5 3C FC F0 C3 74 EB D6 AD C4 F6 2F BD F4 12 C7 8F 1F C7 DF DF 9F D4 D4 54 36 6C D8 C0 9C 
39 73 58 BA 74 29 3B 77 EE 24 32 32 AF 5E F8 A5 4B 79 0F E5 E5 FF 47 E3 66 36 9B 01 C8 CC 2C BB 
5A BD 42 54 25 EE A0 DF E5 72 E1 67 50 F9 47 CF 9A FC 7B F9 49 2E 5C 38 45 70 48 0D 8C 66 EB D5 
20 5F 55 BD 6E 02 3C 83 FE 57 3E 0F 9D 8E 5C D2 2E 9E C2 A8 83 67 EF AF 41 8D 20 3D 4E A7 D3 6B 
E2 AA B2 E6 4B 3D 7E 8D 56 4B D3 E7 C7 4B C0 2F 84 28 95 E6 F5 6E CE 7B 46 74 74 34 EB D7 AF 67 
F2 E4 C9 5E DB F5 7A 3D E3 C6 8D A3 55 AB 56 6C D8 B0 81 11 23 46 78 2A 24 9A 4C 26 EE BD F7 5E 
3E F9 E4 13 AA 55 F3 9E 34 2C 2C 2C 8C 6E DD BA B1 76 ED 5A E2 E3 E3 3D DB 03 02 02 B8 EF BE FB 
58 B9 72 25 FD FA F5 43 AF F7 2D 7C ED D2 A5 0B F1 F1 F1 4C 98 30 81 69 D3 A6 61 B1 58 78 E6 99 
67 F8 CF 7F FE E3 69 D3 B7 6F 5F 5E 7C F1 45 A6 4F 9F 4E D7 AE 5D 31 9B CD 3C F9 E4 93 74 EF DE 
9D F7 DE 7B CF D3 AE 57 AF 5E 3C FB EC B3 CC 9C 39 13 C8 8B ED 46 8F 1E ED A9 4C 54 D2 FE CA A0 
D2 D4 E9 CF AF 41 83 06 1C 39 72 84 06 0D 1A 70 F8 F0 61 96 2F 5F 4E AF 5E BD 00 D8 B5 6B 17 2D 
5A B4 28 B3 6B ED DB B7 8F BB EE BA 8B A0 A0 20 12 12 12 3C 77 7E A5 35 75 EA 54 5E 78 E1 05 46 
8E 1C C9 C7 1F 7F 0C 40 BF 7E FD F8 EE BB EF 48 49 49 A1 46 8D 1A 5E ED 27 4D 9A C4 84 09 13 F8 
E5 97 5F 7C BE 63 F5 85 D4 E9 17 55 81 3B E0 77 3A 9D E4 E4 E4 90 95 95 45 46 46 06 A7 CF 5F 66 
D6 C6 74 2E 65 43 60 70 75 8C 66 6B A1 C7 E7 1F F9 77 3A 72 B9 74 F1 34 2A 0A 8F B5 B7 D0 BA 7E 
08 81 81 81 9E 09 AC DC D5 6E CA 32 F0 F7 B5 1E 7F F4 63 8F 13 F5 68 C9 DF 3E 0A 21 44 65 67 B3 
D9 38 7D FA 34 D1 D1 D1 C5 06 ED 8A A2 60 B3 D9 F0 F7 F7 F7 7A DF 55 55 95 CC CC CC 02 DB 8B 12 
14 14 44 FB F6 ED 59 BB 76 2D 36 9B 8D 93 27 4F D2 A0 41 83 22 AF 9D 9D 9D CD 89 13 27 88 8A 8A 
C2 68 34 A2 28 0A 76 BB DD 33 48 EB EE C3 B1 63 C7 B0 DB ED D4 AB 57 AF C0 A0 6E 49 FB 2B 4A A5 
AB D3 9F 9F 7B 34 3F 29 29 89 C4 C4 44 4F 6A 4F 93 26 4D CA 34 E0 3F 73 E6 8C A7 36 EB 8A 15 2B 
AE 3B E0 87 BC DC 2D 80 1D 3B 76 78 B6 85 5F 99 10 C8 3D E2 9F 9F 3B F5 E7 7A F2 F9 85 10 79 F2 
3F CC AB 28 0A 7E 06 95 41 AD 34 04 99 55 D2 2F 9D 25 CB 96 71 A5 6E B5 EB EA DA E9 22 F7 4A CD 
FE AC EC 2C D2 2E 9E 46 51 15 50 55 D6 EE CF 25 D7 A1 14 28 DB 59 96 E5 3B 7D AD C7 1F D2 AA 35 
51 83 E5 E6 5D 08 71 7B B0 5A AD C4 C4 C4 94 38 4A AF D5 6A 09 08 08 28 10 D8 6B 34 9A 42 B7 FB 
7A ED C6 8D 1B 17 7B 6D 77 6A B4 BB BA 93 56 AB F5 0A F8 DD 7D 88 8A 8A A2 51 A3 46 85 06 F4 25 
ED AF 68 95 3A E8 07 58 B4 68 11 DF 7F FF 7D 81 ED 37 2A 35 35 95 1E 3D 7A 70 E6 CC 19 BE FF FE 
7B 9A 36 6D 7A 43 E7 73 D7 62 0D CF 37 F3 67 83 06 0D 00 D8 BA 75 6B 81 F6 DB B7 6F 27 28 28 88 
A8 A8 A8 1B BA AE 10 55 99 3B D7 DE 3D B3 AC 5E AF 27 D0 A2 E3 E1 A6 4E 02 4D 2E B2 32 CE 63 CF 
B5 E1 72 29 B8 14 25 6F ED 52 70 29 2A 0E 7B 0E B6 CB 67 F3 1E E8 BD 92 DD 7F 26 DD C5 B7 BF 5F 
F6 4A EB 29 D3 7C 7E 1F EB F1 9B 42 42 69 F6 FC 0B 20 0F EE 0A 21 84 28 23 95 32 E8 6F D3 A6 0D 
0D 1B 36 04 60 C6 8C 19 9E 51 F1 B2 0A FA 33 32 32 78 E0 81 07 38 74 E8 10 4B 96 2C 29 36 BD 26 
25 25 85 DD BB 77 7B 7E 57 94 C2 EB 6C CC 9F 3F 1F 80 BB EE BA CB B3 ED 91 47 1E F1 EC CB 3F AA 
97 98 98 C8 E6 CD 9B 19 34 68 50 A5 BC 13 14 E2 56 70 6D B0 6F 34 1A 31 99 4C 98 4C 26 82 AD 06 
FE 14 9B 17 F8 E7 64 9E 27 37 C7 E6 35 1B 6F 6E 6E 0E D9 E9 E7 BD 02 7E B7 1D C7 B2 58 B5 2B CD 
6B B6 DA B2 22 79 FC 42 08 71 73 F4 EF DF BF 52 3D 44 5B 19 54 BA 07 79 DD 1E 79 E4 11 A6 4C 99 
E2 A9 9B DF B4 69 53 CF 2C 6A 37 EA AF 7F FD 2B 5B B7 6E A5 4B 97 2E 24 24 24 90 90 90 E0 B5 FF 
D1 47 1F F5 8C D2 77 E9 D2 85 C3 87 0F 73 F4 E8 51 EA D5 AB C7 8C 19 33 58 B4 68 11 83 06 0D A2 
61 C3 86 D8 6C 36 56 AD 5A C5 67 9F 7D 46 B3 66 CD 18 33 66 8C E7 3C 0D 1B 36 A4 5F BF 7E 2C 5D 
BA 94 A1 43 87 32 60 C0 00 2E 5C B8 C0 C4 89 13 09 0B 0B 63 EC D8 B1 65 F2 7A 84 A8 6A F2 D7 CF 
77 4F 73 EE 72 B9 3C 8B A2 28 84 A8 2A 7F 8A B5 B3 64 9F 9E F4 EC 8B A8 86 60 D0 9B 41 71 40 4E 
1A A0 16 08 F8 DD 16 6D 4E 21 26 32 98 0E 4D AA 97 D9 28 7F DA 1F DB 39 F6 CD D7 25 B6 8B 7A 74 
08 C1 2D CB BE 42 99 10 42 54 25 EE AA 8C E2 AA 4A 1B F4 0F 19 32 84 E9 D3 A7 7B A6 40 7E E2 89 
27 CA EC DC EE A9 97 7F F9 E5 97 02 13 2F 00 C4 C4 C4 78 82 FE B0 B0 30 4E 9F 3E 8D BF BF 3F 00 
DD BA 75 63 C1 82 05 8C 19 33 C6 33 EA 6F B5 5A 19 39 72 24 AF BF FE 7A 81 99 E7 16 2C 58 C0 88 
11 23 58 BC 78 31 F3 E7 CF C7 68 34 D2 AE 5D 3B 66 CD 9A 45 E3 C6 8D CB EC 35 09 51 15 B9 47 FA 
0D 06 83 57 1E 7E FE 6F D6 3C 81 7F EE 25 5C 8A 3F 3A 57 16 68 54 50 0B 0F F8 21 AF BE FF 8C EF 
0F F2 EF 88 20 EA 54 B3 DE 70 E0 2F 79 FC 42 08 21 2A 5A A5 0D FA 9B 37 6F 4E 66 66 26 D9 D9 D9 
18 0C 86 22 A7 71 BE 1E 1B 37 6E F4 B9 ED 6F BF FD 86 C3 E1 F0 3C D8 D1 A6 4D 1B B6 6C D9 42 46 
46 06 27 4F 9E 24 30 30 90 5A B5 6A 15 19 14 18 8D 46 E6 CC 99 C3 EC D9 B3 49 4E 4E A6 76 ED DA 
92 D2 23 44 19 70 FF CD E9 74 3A 80 22 1F BA D5 68 34 FC 29 36 97 25 FB F4 5C CE C9 C4 A8 87 2E 
F5 1C FC 94 6C C0 59 CC AC 58 D9 B9 2E DE FC 6A 27 33 46 DC 89 D5 7C 03 6F 95 92 C7 2F 84 10 A2 
12 A8 B4 41 3F E4 4D EE E0 9E 9E B9 A2 68 34 1A 4F C0 9F 5F 40 40 80 67 D2 08 5F CF 53 BF 7E FD 
B2 EC 9A 10 55 9E 3B F0 D7 6A B5 45 BE 57 B8 1F C4 1D D0 DC C1 A6 63 0A AD 6B 2A D4 0C 36 62 B5 
1A 58 BA CB 5E EC F9 4F A7 66 F3 CE B7 89 4C 7C BC CD 75 C7 E2 92 C7 2F 84 10 A2 32 A8 D4 41 BF 
10 42 94 C4 FD 40 2F 50 68 E0 EF DE AF D7 E7 D2 AB 99 0B AD 56 8B D1 68 E4 8E 70 3F 32 15 3B 6B 
77 5F 2E F6 FC DB 0E 5F 64 F6 9A 43 3C 75 7F 4C A9 FB 26 79 FC 42 08 21 2A 0B 09 FA 85 10 B7 BC 
A2 02 7F F7 28 7F FE BC 7F 77 D0 6F B1 58 18 D8 D1 C2 45 1B FC 91 5C 7C E0 BF F8 D7 63 D4 AF 11 
40 B7 96 35 8A 6D 97 9F AF 79 FC A1 AD DB 48 1E BF 10 42 88 72 57 29 4B 76 0A 21 44 69 B9 03 7F 
77 AA 8F D1 68 C4 6C 36 63 B5 5A 09 08 08 20 30 30 90 C0 C0 40 02 02 02 08 08 08 C0 6A B5 E2 E7 
67 61 CC 43 4D 88 0C F7 2B F1 FC EF 7D BF 8F 43 A7 D3 7D EB 4C 29 F2 F8 9B 8E 1B 2F 79 FC 42 08 
21 CA 9D 04 FD 42 88 DB C6 B5 81 BF C9 64 C2 62 B1 78 02 FF FC 01 BF C5 62 C1 64 32 11 60 35 F1 
CA A0 16 25 3E AC 6B 77 B8 98 F4 D5 2E D2 32 8B 7F 0E 00 24 8F 5F 08 21 44 E5 23 41 BF 10 E2 B6 
92 3F F0 D7 EB F5 98 4C 26 CC 66 33 7E 7E 7E 57 46 F7 FD 3C 01 BF C1 60 40 A7 D3 11 59 CD 9F F1 
03 9A A3 D5 16 3F E2 7E 21 3D 87 C9 5F EF C2 E9 2A 3A 65 47 F2 F8 85 10 42 54 46 12 F4 0B 21 6E 
3B 85 CD D6 9B 7F C6 5E A3 D1 88 5E AF F7 9A 75 B7 5D 4C 38 7F EE 51 F2 C3 BA FB 4E 5C E2 C3 1F 
F7 17 BA 4F F2 F8 85 10 42 54 56 12 F4 0B 21 6E 4B EE 87 78 F3 07 FF EE C5 1D EC BB DB B8 4B 7F 
3E DC B1 2E DD 5A D5 2C F1 DC AB B7 9F E2 FB 2D 27 BC 37 4A 1E BF 10 42 88 4A 4C 82 7E 21 C4 6D 
2B 7F 50 EF 4E F9 71 07 FB EE F5 B5 FE D1 37 96 98 DA 81 25 9E 7B D6 AA 43 EC 4A 4E F3 FC 2E 79 
FC 42 08 21 2A 33 09 FA 85 10 B7 BD FC C1 7F FE 91 FD C2 18 F4 5A 26 0C 6E 45 68 40 F1 33 67 BB 
5C 0A 53 BE 49 E4 4C 5A B6 E4 F1 0B 21 84 A8 F4 24 E8 17 42 88 6B 84 05 9A 78 79 50 4B 0C FA E2 
DF 22 D3 B3 EC 4C 9B B3 91 3D EF 4E 95 3C 7E 21 84 10 95 9A 04 FD 42 08 51 88 D8 3A 41 FC AD 57 
93 62 DB 68 55 85 96 09 DF E0 48 2F 7E 72 2F C9 E3 17 42 08 51 D1 24 E8 17 42 88 22 DC 1F 57 8B 
87 3A D4 2D 72 7F C7 D3 BF 51 27 F3 64 B1 E7 90 3C 7E 21 84 10 95 81 04 FD 42 08 51 8C BF F4 8C 
A1 55 FD D0 02 DB A3 D2 8F D2 E1 CC E6 12 8F 97 3C 7E 21 84 10 95 81 04 FD 42 08 51 0C AD 56 C3 
4B 03 5B 50 23 C4 E2 D9 E6 EF C8 A4 57 F2 8A 12 8F 95 3C 7E 21 84 10 95 85 04 FD 42 08 51 82 00 
8B 81 57 87 B4 C2 62 D2 A3 55 15 7A 1D 59 86 C5 99 55 EC 31 92 C7 2F 84 10 A2 32 91 A0 5F 08 21 
7C 50 2F C2 9F B1 7F 6A 46 A7 94 92 F3 F8 55 8D 86 26 CF 3D 2F 79 FC 42 08 21 2A 0D 7D 45 77 A0 
22 1D 3D 7A 94 C4 C4 44 4C 26 13 2D 5A B4 A0 66 CD 92 67 E2 CC 2F 23 23 83 84 84 04 CC 66 33 71 
71 71 58 2C 96 32 69 2B 84 A8 9C 62 73 4E 90 9B 52 72 1E FF 6F 35 3B 70 F0 B4 85 91 AD 6F 42 A7 
84 10 42 08 1F 54 C9 91 FE 7D FB F6 71 F7 DD 77 13 1D 1D 4D DF BE 7D E9 D9 B3 27 91 91 91 8C 19 
33 A6 C4 5A DB 00 4E A7 93 27 9E 78 82 E0 E0 60 BA 77 EF 4E E7 CE 9D 09 0C 0C 64 FA F4 E9 37 D4 
56 08 51 79 D9 53 53 D9 3B ED DD 12 DB 1D 0F AC C7 6F 35 EF E2 87 2D 27 58 BD FD F4 4D E8 99 10 
42 08 51 B2 2A 39 D2 FF D1 47 1F 71 E1 C2 05 3E FC F0 43 5A B6 6C C9 C1 83 07 79 F1 C5 17 99 31 
63 06 CD 9A 35 E3 2F 7F F9 4B B1 C7 3F FD F4 D3 CC 9D 3B 97 E7 9F 7F 9E 61 C3 86 61 B7 DB 19 3B 
76 2C E3 C6 8D A3 5A B5 6A 0C 1B 36 EC BA DA 0A 21 2A 29 45 61 CF D4 B7 B1 5F BE 54 6C 33 9B DE 
CA B2 A8 78 54 F2 F2 F8 3F 5A B6 9F 3A D5 AC C4 D6 09 BA 19 BD 14 42 54 31 B6 E4 64 9C 59 C5 3F 
5F 94 9F 46 AF 23 B0 71 F1 F3 8F 88 DB 97 66 EA D4 A9 71 4E A7 73 5B 9F 3E 7D 68 DE BC 79 45 F7 
E7 A6 38 7E FC 38 35 6B D6 C4 60 30 78 B6 CD 9B 37 8F 61 C3 86 D1 BB 77 6F 7E F8 E1 87 22 8F 4D 
49 49 A1 4E 9D 3A F4 EB D7 8F 85 0B 17 7A B6 5F B8 70 81 C8 C8 48 DA B5 6B C7 C6 8D 1B 4B DD B6 
B4 6C 36 1B 69 69 B5 31 A4 01 00 00 20 00 49 44 41 54 69 05 B6 FF F8 E3 8F 18 8D 46 EE BF FF FE 
EB 3A AF 10 A2 A0 8B DF 2D 25 75 C5 B2 62 DB A8 68 F8 B6 D1 00 8E 07 78 D7 F5 0F F2 D3 F3 72 BF 
28 82 AD 55 72 8C 45 88 4A 25 22 22 02 A3 D1 58 D1 DD 28 13 D9 A7 4E B1 79 44 F1 83 94 85 69 F1 
AF 09 84 DF D5 B1 1C 7A 54 BE B2 B3 B3 39 7E FC 38 31 31 31 68 B5 55 32 51 E5 BA 2D 5C B8 90 A4 
A4 A4 A3 55 F2 53 A8 6E DD 82 93 ED B8 6F 78 2E 5F 2E 7E 66 CD 05 0B 16 E0 72 B9 18 3C 78 B0 D7 
F6 F0 F0 70 EE B9 E7 1E D6 AC 59 C3 B9 73 E7 88 88 88 28 55 DB D2 3A 70 E0 00 AB 56 AD 2A B0 DD 
60 30 E0 70 38 98 37 6F 5E A9 CF 29 84 28 28 F8 52 1A 4D F6 24 96 D8 EE B7 5A 1D 0A 04 FC 00 97 
B3 9C BC F9 F5 4E 5A 1A F6 A1 D5 94 9C 3E 28 84 28 3F C3 87 0F A7 56 AD 5A 15 DD 8D 32 E1 CA C9 
01 A0 56 DD BA 04 85 84 15 D8 AF D1 80 AA 5E 2D 20 96 9D 95 45 F2 C1 03 9E E3 CA C2 F1 E3 C7 49 
4F 4F 2F 72 D0 38 31 31 91 E0 E0 60 EA D4 A9 03 5C 8D 5D 86 0C 19 42 78 78 78 A9 AE 35 73 E6 4C 
C6 8C 19 C3 C6 8D 1B E9 D4 A9 D3 0D F7 BD 2A AA 92 41 7F 61 0E 1E 3C 08 40 A3 46 8D 8A 6D B7 7F 
FF 7E 00 DA B6 6D 5B 60 5F 6C 6C 2C AB 57 AF E6 D4 A9 53 44 44 44 94 AA 6D 69 D5 AF 5F 9F FE FD 
FB 17 D8 BE 6E DD 3A 0C 06 03 5D BA 74 29 F5 39 85 10 DE 5C 97 2F 73 6E DA 54 94 12 DA B9 F3 F8 
8B 92 A9 58 C9 AD 75 0F 8F 77 2C F8 C1 2C 84 B8 79 42 43 0B 4E B4 57 D1 32 93 92 C8 3A 75 12 D5 
E5 2A D5 71 39 67 CF 02 E0 E7 E7 4F 70 70 30 A0 02 9A 2B EB 6B 7F 03 9D 56 07 C0 E5 BD 7B 4B DD 
47 8D 56 8B B9 7A 0D 02 1B 37 F6 2A 43 3C 7C F8 70 7E FE F9 E7 42 9F 87 54 14 85 96 2D 5B D2 A3 
47 0F 56 AF 5E 0D C0 07 1F 7C C0 07 1F 7C 40 58 58 18 8F 3D F6 58 A9 FA E0 BE 86 2F CF 5E 8A C2 
49 D0 7F C5 EC D9 B3 01 4A FC 47 78 F6 CA 1F 59 70 21 A5 F8 DC 6F 26 17 2F 5E 2C 75 DB D2 0A 0E 
0E 2E F4 BC 1B 36 6C C0 62 B1 94 78 F3 22 84 28 81 A2 F0 C7 CB 2F A2 D8 32 8B 6D 66 0A 09 C5 D6 
EB 49 D4 7D E9 C5 B6 DB 96 6C A3 55 4C 2D FA 77 AA 57 96 BD 14 42 DC A2 1C E9 97 D9 F3 F6 5B A4 
ED DA 75 43 E7 51 9D 0E 5C F6 DC 82 DB D5 AB A3 FD EE 76 00 A7 56 2C E3 54 09 E9 8A 45 09 A8 DF 
80 E6 FF 9A 80 B9 7A F5 2B D7 28 5D 00 3E 6A D4 28 A2 A3 A3 E9 D9 B3 E7 75 5D 5F DC 18 49 8A 02 
16 2F 5E CC EA D5 AB 79 F8 E1 87 E9 D6 AD 5B B1 6D 2F 5D CA 7B 90 CF 64 32 15 D8 67 36 9B 01 C8 
CC CC 2C 75 5B 21 44 E5 92 3C FF 0B 2E ED 2E 3E AD 47 A3 D5 D2 F4 F9 F1 FC F5 91 F6 C4 D6 29 B9 
26 FF 67 6B 0F B3 ED F0 F5 DD E8 0B 21 6E 2F 7B DE 9E 72 C3 01 3F 80 CB E9 C4 99 9B 5B 60 71 D9 
AF AE 5D F6 5C 9C 76 FB 0D 5F 2B E3 48 12 BB 26 BE 86 AA 94 F4 FD 67 E1 9A 36 6D CA D8 B1 63 4B 
9D DA 23 CA 46 95 0F FA F7 ED DB C7 93 4F 3E 49 DD BA 75 F9 E8 A3 8F 4A 6C 1F 14 94 57 85 23 3D 
BD E0 A8 9E FD CA 1F 54 58 58 58 A9 DB 0A 21 2A 8F B4 3F B6 73 EC 9B AF 4B 6C 17 F5 E8 10 82 5B 
B6 42 AF D3 F0 AF C1 2D 09 0F 34 17 DB 5E 51 54 A6 2E DC CD E9 8B BE 57 DB 10 42 DC 7E 6C C9 C9 
A4 ED DA 59 26 E7 52 9C 4E 5C 76 3B AE DC DC AB EB FC 3F DB ED B8 EC 76 14 87 B3 4C AE 67 3B 7E 
8C D4 6D BF 5F D7 B1 2B 57 AE A4 57 AF 5E 24 25 25 79 6D DF BA 75 2B 8F 3E FA 28 6D DA B4 A1 63 
C7 8E 0C 18 30 80 01 03 06 30 70 E0 40 CE 9D 3B 57 E0 3C 8B 17 2F A6 4F 9F 3E B4 6F DF 9E D1 A3 
47 97 F8 3C 26 E4 65 72 7C F5 D5 57 A4 A4 A4 30 72 E4 48 5A B6 6C 49 EF DE BD 3D 99 1E F9 ED DF 
BF 9F B1 63 C7 D2 A1 43 07 9A 35 6B 46 7C 7C 3C 5F 7C F1 45 81 6F 36 92 92 92 78 F2 C9 27 89 8B 
8B 23 2E 2E 8E B1 63 C7 7A F5 A5 A4 FD 37 5B 95 0E FA CF 9C 39 43 EF DE BD D1 68 34 AC 58 B1 82 
EA 57 BE AE 2A 8E FB EE D4 3D 8A 9F 9F 3B 9D C7 9D A3 5F 9A B6 42 88 CA C1 5D 8F BF A4 AF AD 43 
5B B7 21 6A F0 10 CF EF 21 FE 46 26 3C DA 0A A3 41 57 EC 71 99 D9 0E DE F8 6A 27 D9 B9 A5 CB DF 
15 42 DC 3E B2 52 CA 6E 0E 0F C5 E9 C8 0B EE 1D F6 AB 6B 87 3D 6F 94 FF CA DA FD 73 59 C9 4E 49 
B9 AE E3 F6 ED DB C7 F2 E5 CB 49 C9 77 FC FA F5 EB E9 D0 A1 03 47 8E 1C A1 5F BF 7E 18 0C 06 16 
2D 5A 44 42 42 02 4A 21 DF 28 BC F6 DA 6B 0C 1E 3C 18 45 51 30 9B CD BC FF FE FB F4 E8 D1 A3 C4 
6B FF F8 E3 8F 7C FE F9 E7 B4 6A D5 8A 4D 9B 36 D1 BA 75 6B 76 EE DC C9 53 4F 3D C5 A4 49 93 3C 
ED D2 D2 D2 68 D5 AA 15 3F FC F0 03 71 71 71 C4 C7 C7 73 FC F8 71 86 0E 1D EA 35 38 7C EE DC 39 
EE BA EB 2E 36 6C D8 C0 C3 0F 3F 4C CF 9E 3D F9 E1 87 1F F8 E9 A7 9F 7C DA 5F 11 AA 6C 4E 7F 6A 
6A 2A 3D 7A F4 E0 CC 99 33 AC 5C B9 92 A6 4D 9B FA 74 5C 83 06 0D 80 BC BB D2 26 4D BC 6B DD 6E 
DF BE 9D A0 A0 20 A2 A2 A2 4A DD 56 08 51 09 F8 58 8F DF 14 12 4A D3 71 E3 BD 1E 68 03 68 58 2B 
80 D1 7D 63 99 B6 68 77 B1 C7 9F 38 6F 63 EA C2 44 5E 1D D2 FA DA 53 08 21 AA 00 73 19 0E F8 39 
B3 B3 29 98 D1 5F 90 A3 8C 46 FA 01 CC D5 AA 79 FD 3E 7C F8 F0 EB 3E D7 5B 6F BD 45 8D 1A 35 58 
BF 7E 3D 66 B3 99 D7 5E 7B 8D FB EE BB 8F AD 5B B7 32 77 EE 5C AC 56 AB 57 FB C4 C4 44 B6 6F DF 
EE A9 18 34 68 D0 20 BE F9 E6 1B 7E FD F5 D7 12 AB FA AC 5C B9 92 B1 63 C7 F2 EE BB EF A2 D5 6A 
B9 78 F1 22 71 71 71 BC FD F6 DB 8C 1E 3D 9A C0 C0 40 FC FD FD 59 B4 68 11 BD 7A F5 42 73 E5 0D 
7A E2 C4 89 D4 AB 57 8F 59 B3 66 F1 CC 33 CF 00 B0 7C F9 72 CE 9F 3F CF E2 C5 8B E9 DC B9 33 00 
93 26 4D C2 75 E5 81 EC 92 F6 57 84 2A 39 D2 9F 91 91 C1 03 0F 3C C0 A1 43 87 58 B2 64 09 77 DF 
7D 77 91 6D 53 52 52 D8 BD FB EA 07 F8 23 8F 3C 02 C0 FC F9 F3 BD 46 02 13 13 13 D9 BC 79 33 83 
06 0D F2 E4 F0 97 A6 AD 10 A2 E2 95 26 8F DF 50 C8 83 F4 00 DD 5A D6 60 40 E7 A8 12 AF 95 70 F0 
02 73 D7 1D BE 9E 6E 0A 21 6E 71 01 0D 63 08 6C D4 B8 4C CE A5 B8 5C 9E 14 9E E2 16 C5 E1 28 93 
EB 59 AA 57 27 B4 5D 7B AF 6D 6B D7 AE 2D 74 F1 C5 A1 43 87 88 89 89 F1 3C EB 08 D0 BD 7B 77 32 
32 32 BC BE 11 70 9B 33 67 8E 57 89 D0 81 03 07 02 70 F8 70 C9 EF A7 ED DB B7 67 FA F4 E9 9E 3A 
FF 61 61 61 0C 1B 36 0C 9B CD E6 19 81 37 18 0C 9E 2C 10 37 3F 3F 3F 5A B6 6C C9 B1 63 C7 3C DB 
02 02 02 80 BC 1B 09 37 9D 4E E7 99 07 A2 A4 FD 15 A1 4A 8E F4 FF F5 AF 7F 65 EB D6 AD 74 E9 D2 
85 84 84 04 12 12 12 BC F6 3F FA E8 A3 9E 51 FA 2E 5D BA 70 F8 F0 61 8E 1E 3D 4A BD 7A F5 68 D8 
B0 21 FD FA F5 63 E9 D2 A5 0C 1D 3A 94 01 03 06 70 E1 C2 05 26 4E 9C 48 58 58 18 63 C7 8E F5 9C 
A7 34 6D 85 10 15 AB B4 79 FC C5 79 A2 7B 43 8E 9E CD E4 F7 43 17 8A 6D F7 ED 86 A3 D4 AF 11 40 
97 E6 25 A7 16 0A 21 6E 2F CD 5F FA 17 BB DE 78 9D CC E4 23 37 74 1E C5 E9 C0 85 5A A0 5A CF B5 
5C CA 8D 97 BA B4 D4 A8 41 8B 09 AF A1 CD 37 B9 29 C0 A9 53 A7 0A F6 4B 51 D0 E9 8A 4F 77 84 BC 
52 E9 FF F7 7F FF E7 99 B7 48 55 55 7E FE F9 67 2C 16 4B A1 D9 10 EE E7 25 DD AA 5D F9 D6 A1 B0 
09 4B AF 15 18 18 58 60 5B B3 66 CD 00 38 71 E2 84 D7 F6 84 84 04 56 AF 5E 4D 4A 4A 0A 19 19 19 
EC DF BF DF F3 3C 26 40 9F 3E 7D E8 D4 A9 13 93 27 4F 66 F9 F2 E5 FC FD EF 7F E7 B1 C7 1E F3 0C 
E6 96 B4 BF 22 54 C9 A0 DF FD 7F EC 2F BF FC C2 2F BF FC 52 60 7F 4C 4C 8C 27 E8 0F 0B 0B E3 F4 
E9 D3 F8 FB FB 7B F6 2F 58 B0 80 11 23 46 B0 78 F1 62 E6 CF 9F 8F D1 68 A4 5D BB 76 CC 9A 35 8B 
C6 8D BD EF DC 4B D3 56 08 51 31 AE 37 8F BF 28 1A 0D 8C 1F D0 9C 31 9F 24 70 AA 84 87 76 67 2C 
DD 4B ED 30 3F 1A D4 0C 28 55 9F 85 10 B7 36 53 B5 6A B4 FF 9F F7 49 DD B1 E3 BA EA F4 E7 5E B8 
C0 89 A5 8B F3 1E E4 55 94 92 83 FE 2B 3B AA 77 ED 46 40 C3 98 52 5D 4B A3 D1 60 A9 51 93 D0 B6 
71 68 F4 86 92 0F 28 85 FE FD FB B3 6A D5 2A 1A 36 6C C8 83 0F 3E C8 91 23 47 F8 FD F7 DF F9 CF 
7F FE 83 5E 5F 72 98 7A A3 B3 F3 1A AE DC C0 B8 47 F6 9D 4E 27 03 07 0E 64 C9 92 25 74 EC D8 91 
D8 D8 58 82 82 82 3C ED DC 8C 46 23 3F FD F4 13 B3 66 CD E2 C3 0F 3F E4 A9 A7 9E 62 CA 94 29 AC 
5E BD 9A E8 E8 E8 12 F7 57 84 2A 19 F4 6F DC B8 D1 E7 B6 BF FD F6 1B 0E 87 C3 EB EB 18 A3 D1 C8 
9C 39 73 98 3D 7B 36 C9 C9 C9 D4 AE 5D BB C8 3B B7 D2 B4 15 42 54 80 1B CC E3 2F 8A D5 AC E7 D5 
21 AD 19 F3 BF 09 64 E5 14 9D 4B 9B EB 70 F1 E6 57 3B F9 9F 11 77 12 64 2D DB 0F 53 21 44 25 A7 
D5 12 1A 17 47 68 5C 5C A9 0F CD 4C 4A E2 C4 D2 C5 D8 1D 4E EF 99 B8 DC 6F 51 D7 CC CE E5 D4 AA 
80 96 B0 B6 ED A8 DE ED DE B2 E8 7D 99 78 E7 9D 77 78 F4 D1 47 69 D4 A8 11 89 89 89 DC 79 E7 9D 
BC FB EE BB 74 ED DA F5 A6 5C FF C8 91 BC 6F 5A EA D6 CD 9B 51 FD DB 6F BF 65 C9 92 25 4C 9B 36 
8D E7 9E 7B CE D3 2E 29 29 A9 C0 40 B1 C1 60 60 D4 A8 51 8C 1A 35 8A B9 73 E7 F2 C4 13 4F 30 61 
C2 04 BE F8 E2 0B 9F F6 DF 6C 55 32 A7 BF 34 34 1A 4D 91 F9 57 1A 8D 86 FA F5 EB FB 14 C4 97 A6 
AD 10 E2 E6 29 8B 3C FE A2 44 86 FB 31 7E 40 73 B4 DA E2 6F 14 CE 5F CE 61 F2 82 9D 65 F2 F5 BB 
10 A2 6A 70 A7 D8 64 6A 34 A4 6A 35 A4 E6 5F 5F BB 4D AB 21 FD 4A C8 77 6D 6A 4E 45 CA C8 C8 20 
29 29 09 A3 D1 C8 73 CF 3D C7 A2 45 8B F8 E0 83 0F CA 2D E0 DF B4 69 13 6B D6 AC F1 FC EE 74 3A 
F9 F2 CB 2F 31 99 4C DC 71 C7 1D 40 5E 85 21 80 B8 7C 37 62 39 39 39 85 A6 30 E5 37 7C F8 70 AA 
55 AB 56 E8 73 08 BE EC BF 19 AA E4 48 BF 10 42 40 D9 E6 F1 17 A5 7D 4C 38 C3 EE 6B C0 67 6B 8A 
7F C8 6C CF B1 4B 7C BC EC 00 7F EF D3 A4 D8 76 42 08 01 E0 57 B7 2E AD 27 BD 85 2B 3B DB E7 63 
34 3A 1D A1 6D DB 95 63 AF 4A 27 20 20 80 A7 9E 7A 8A 4F 3F FD 94 B9 73 E7 62 36 9B B1 5A AD D4 
AC 59 93 AE 5D BB 32 61 C2 84 32 2D 6D EE 74 3A E9 DB B7 2F 7F FF FB DF B9 F3 CE 3B 99 37 6F 1E 
3B 76 EC E0 6F 7F FB 9B A7 6C 7B BB 76 79 FF 7D 26 4E 9C 88 56 AB C5 66 B3 31 79 F2 64 F6 EE DD 
EB 35 70 FB E4 93 4F 62 34 1A 19 38 70 20 61 61 61 2C 5A B4 88 F3 E7 CF D3 BD 7B 77 9F F6 57 04 
09 FA 85 10 B7 BC D2 4E 05 0F 79 79 FC 7B DE 9D 5A 66 79 FC C5 79 A4 73 14 C9 67 32 59 9F 78 A6 
D8 76 2B 7E 3F 49 74 0D 7F 7A B5 8F BC A1 EB 09 21 AA 86 90 D6 6D 2A F4 FA 46 A3 B1 40 AE BB 9B 
46 A3 41 AF D7 7B ED 77 E7 E8 BB B7 29 8A C2 D9 B3 67 A9 5E BD 3A 53 A6 4C 01 F2 46 FF B7 6C D9 
C2 87 1F 7E C8 B6 6D DB D8 B4 69 53 A1 C7 5E 7B 4E 5F F2 FF BB 74 E9 42 7C 7C 3C 13 26 4C 60 DA 
B4 69 58 2C 16 9E 79 E6 19 FE F3 9F FF 78 DA F4 ED DB 97 17 5F 7C 91 E9 D3 A7 D3 B5 6B 57 CC 66 
33 4F 3E F9 24 DD BB 77 E7 BD F7 DE F3 B4 EB D5 AB 17 CF 3E FB 2C 33 67 CE 04 C0 64 32 31 7A F4 
68 C6 8F 1F EF D3 FE 8A A0 99 3A 75 6A 9C D3 E9 DC D6 A7 4F 1F AF 12 48 E2 D6 F4 E9 A7 9F 62 B1 
58 18 32 E4 C6 82 14 21 6E 05 EE 80 FD F2 81 FD 9C 59 B5 0A 15 D5 E7 1B 80 B4 6D DB B0 5F 2A A2 
DA C3 95 73 18 83 43 B8 E3 83 8F 4A 9D D6 53 18 BB 53 61 DC AC DF 49 4A 29 38 43 77 7E 3A 9D 96 
B7 86 C7 D1 BC DE 8D 5F 53 08 21 CA 93 D3 E9 C4 E5 72 15 99 BA 9C 9B 9B 8B 5E AF F7 54 F1 51 55 
95 AC AC 2C 4F ED FD A5 4B 97 F2 A7 3F FD 89 6F BF FD 96 01 03 06 78 1D DB BB 77 6F 96 2D 5B 46 
46 46 06 FE FE FE 05 8E CD CF 66 B3 E1 E7 E7 E7 55 66 F3 5A 41 41 41 B4 6F DF 9E B5 6B D7 62 B3 
D9 38 79 F2 24 0D 1A 34 28 F2 66 21 3B 3B 9B 13 27 4E 10 15 15 85 D1 68 44 51 14 EC 76 BB 57 69 
51 55 55 39 76 EC 18 76 BB 9D 7A F5 EA 15 F8 EF 50 D2 FE 9B 65 E1 C2 85 24 25 25 1D 95 91 7E 21 
C4 2D 49 55 55 CF 72 F6 A7 9F 48 59 B3 0A BD AF F5 8F AF 1C 57 58 39 39 C5 E9 04 8D 06 15 88 1D 
F7 3C FA 6B CA C3 5D 2F A3 5E CB 84 47 5B F2 CF 4F 12 B8 94 59 F4 CC 98 2E 97 C2 5B 0B 76 31 E3 
AF 77 10 11 6C 2E B2 9D 10 42 54 34 BD 5E 5F EC 08 FB B5 41 AE 46 A3 F1 0A DA 2F 5C C8 2B 6B 9C 
94 94 E4 D5 CE 66 B3 91 94 94 44 64 64 A4 A7 7A E2 B5 C7 E6 57 D4 F6 A2 58 AD D6 12 2B 28 5A 2C 
16 1A 35 6A E4 F9 5D AB D5 7A 05 FC EE 3E 15 37 C9 6A 49 FB 6F 36 09 FA 85 10 B7 1C 77 B0 AF 28 
8A 67 D1 68 34 DC D5 ED BE BC 06 D7 54 B1 D0 A0 41 45 45 43 E1 A3 40 AA AA A2 D1 68 50 55 95 6D 
BF 6E 24 2B 33 93 3A 83 06 11 D8 BC 85 E7 9B 83 E2 46 90 7C 55 2D C8 CC CB 83 5A F2 F2 67 DB 71 
BA 0A 4E 2F EF 76 D9 66 E7 CD AF 76 32 ED 2F ED 31 19 A4 DE 82 10 E2 F6 D4 A7 4F 1F EA D5 AB C7 
2B AF BC C2 C2 85 0B 69 DE BC 39 D9 D9 D9 FC F4 D3 4F 64 66 66 B2 74 E9 D2 8A EE E2 6D 45 3E 4D 
84 10 B7 24 77 D0 EF 70 38 3C D3 9A AB 8A 0B 55 71 A1 38 AF AE 15 A7 0B 97 D3 E9 59 17 B6 A8 8A 
CB B3 06 D0 FB 5B A9 D1 EF 61 5C 2E D7 75 3D 2F 50 9C 66 75 83 19 D5 AB E4 39 3A 8E 9C C9 E0 DF 
4B F6 94 E9 B5 85 10 A2 32 A9 5E BD 3A 3B 77 EE E4 BD F7 DE 23 2E 2E 8E 4B 97 2E 11 10 10 C0 B8 
71 E3 38 7A F4 28 3D 7A F4 28 B3 6B F5 EF DF BF 42 1F A2 AD 0C 64 A4 5F 08 71 4B C9 9F D6 E3 72 
B9 70 38 1C 38 9D 79 75 F0 5D F6 22 D2 66 AE A9 57 7D ED 37 01 5E 93 DA A8 2A 86 9A 35 B1 3B 1C 
68 75 3A B4 5A AD 67 94 BF 2C 46 FB 01 1E 68 5B 9B 23 67 32 58 96 70 B2 D8 76 1B F7 9C E5 EB 5F 
FC 19 DC A5 62 26 72 11 42 88 F2 16 14 14 C4 A8 51 A3 CA FD 3A B3 67 CF 2E F7 6B 54 76 32 D2 2F 
84 B8 25 29 8A 82 CB E5 C2 6E B7 7B 46 FA 15 A7 F3 CA E2 CA B7 76 A1 28 F9 D6 CA 95 7D EE F5 95 
11 7E F7 1A 55 45 D5 6A 3D 37 13 EE 1B 8C B2 36 E2 C1 C6 B4 88 0A 29 B1 DD 17 FF 77 84 2D 07 2E 
94 F9 F5 85 10 42 54 2D 12 F4 0B 21 6E 39 F9 73 FA 5D 2E 97 27 E8 77 39 1C 79 8B 3D F7 EA DA 9E 
8B CB 6E CF B7 B6 5F D9 67 BF DA 3E 37 D7 B3 56 C9 BB A1 70 3A 9D 9E E7 05 CA 83 4E AB E1 E5 41 
2D A9 1E 6C 29 F1 B5 4E 5B B4 9B 13 E7 6D E5 D2 0F 21 84 10 55 83 04 FD 42 88 5B 96 3B E8 77 8F 
C4 FB 12 D4 17 BA E4 6B 43 BE D4 21 77 C0 5F 1E 23 FD 00 81 7E 06 26 0C 69 85 D9 58 B0 8A 50 7E 
59 B9 4E 26 7E B9 93 CC 1C 67 B9 F4 43 08 21 C4 ED 4F 82 7E 21 C4 2D 29 7F 6E BF 3B 28 BF 9A DE 
73 CD E2 72 5D 5D BB AE A4 F8 B8 AE A6 FB A8 AE AB 6B 77 E2 BF FB 9C E5 15 F0 BB 45 57 F7 67 4C 
BF 66 25 B6 4B 49 CD E2 ED 6F 12 51 CA B7 3B 42 08 21 6E 53 12 F4 0B 21 6E 69 F9 83 72 97 C3 8E 
CB 61 47 71 38 3C EB BC C5 9E 6F 6D C7 95 7B 75 ED CA B5 E3 CC CD F5 AC F3 07 FB E5 1D F0 BB 75 
6E 16 C1 A3 F7 D4 2F B1 DD 1F 49 17 F9 74 D5 C1 9B D0 23 21 84 10 B7 1B 09 FA 85 10 B7 0D D5 75 
65 D4 DE E9 F4 AC 15 A7 13 D7 95 07 7B 5D 4E 17 AE 2B E5 3C DD EB BC 45 F1 AC A9 A0 91 F4 C7 EF 
AD 4F 87 26 D5 4A 6C B7 F4 B7 E3 AC DB 91 72 13 7A 24 84 10 E2 76 22 41 BF 10 E2 B6 E1 C9 E9 BF 
66 51 1C 57 D7 85 8D F4 BB EC B9 9E 35 37 69 74 BF 30 E3 FA 37 A7 6E 84 7F 89 ED DE FF 61 1F 07 
4E A5 DF 84 1E 09 21 84 B8 5D 48 D0 2F 84 B8 6D 38 73 73 F3 52 75 1C 76 CF 3A FF CF BE EC BF 59 
29 3D 85 B1 18 75 BC FA 68 2B 02 2C 86 62 DB 39 9C 0A 93 BE DA 49 6A 46 11 F3 12 08 21 84 10 D7 
90 A0 5F 08 71 CB CB 4B CB 51 8B 4C EF 51 5D 8A 67 9D B7 B8 F2 AD AF A4 F7 5C 59 57 58 7E CF 15 
35 43 2D BC 38 B0 05 3A 6D F1 13 81 A5 66 E4 32 F9 EB 9D 38 5D F2 64 AF 10 42 88 92 55 F9 19 79 
55 55 25 21 21 81 6A D5 AA 51 BF 7E C9 0F D2 01 A4 A5 A5 71 E6 CC 99 02 DB CD 66 33 D1 D1 85 CF 
9C 99 91 91 41 42 42 02 66 B3 99 B8 B8 38 2C 96 E2 6B 73 0B 21 7C A3 D8 6C D8 F7 EC 06 F2 EA F4 
E7 29 CD 14 BC DE 2A 72 A4 DF AD 75 FD 50 9E BC 3F 86 FF 5D 59 FC 43 BB FB 4F 5E E6 BD EF F7 31 
F6 4F 4D 6F 52 CF 84 10 42 DC AA AA F4 48 FF E1 C3 87 B9 F7 DE 7B E9 D0 A1 03 E3 C6 8D F3 F9 B8 
BE 7D FB D2 B4 69 D3 02 4B A3 46 8D 0A 04 0C 4E A7 93 27 9E 78 82 E0 E0 60 BA 77 EF 4E E7 CE 9D 
09 0C 0C 64 FA F4 E9 65 FD 72 84 A8 72 EC E7 CE 72 F2 DD B7 51 32 32 80 FC 0F F2 5E 5D 7B CF CE 
5B 70 06 5E F5 4A F9 4E F7 BA 82 07 FA 3D FA DD 55 97 FB 5A D7 2A B1 DD BA 1D A7 59 B2 E9 18 AA 
AA 92 99 ED 60 F6 EA 43 A4 A4 66 DD D4 EA 43 42 08 21 2A BF 2A 39 D2 AF 28 0A EF BE FB 2E AF BF 
FE 3A 91 91 91 A5 3E 3E 2B 2B 8B 16 2D 5A 30 7E FC 78 AF ED 81 81 81 68 34 DE 5F C9 3F FD F4 D3 
CC 9D 3B 97 E7 9F 7F 9E 61 C3 86 61 B7 DB 19 3B 76 2C E3 C6 8D A3 5A B5 6A 0C 1B 36 EC 86 5E 8B 
10 55 55 E6 A1 43 1C 7C 6B 12 CE 8C 74 DC 23 F8 CE DC 5C E0 EA 20 BE A6 88 81 FD E2 F6 57 A6 40 
79 74 DF 58 4E 5E B0 71 E0 E4 E5 62 DB CD 5E 7D 88 88 20 13 DF 6E 3C CE A1 D3 E9 AC 4F 3C CB 5B 
C3 5B 53 33 D4 CF D3 E6 DA F7 26 21 84 10 55 4B 95 0C FA B7 6F DF CE 5B 6F BD C5 94 29 53 78 EC 
B1 C7 88 88 88 28 F5 39 6A D6 AC C9 E3 8F 3F 5E 6C 9B 94 94 14 E6 CD 9B 47 FF FE FD 99 3A 75 AA 
67 FB C2 85 0B 89 8C 8C E4 93 4F 3E 91 A0 5F 88 EB 70 71 CB 16 F6 4D 9F 8A 72 25 C8 77 53 1C 79 
0F B6 AA AA 8A 46 A3 B9 1A C0 17 88 F2 F1 CA FE F1 DA AD 29 7E 76 DC 9B 49 AF D3 F0 CA E0 56 FC 
63 E6 16 52 33 72 8B 6C A7 A8 30 75 E1 5E 5C A8 34 A8 53 97 E3 67 4E F3 D2 67 7F 78 02 7F 77 C0 
2F 81 BF 10 42 54 5D 55 32 E8 6F D1 A2 05 47 8E 1C 21 2C 2C 8C 4B 97 2E 95 DB 75 16 2C 58 80 CB 
E5 62 F0 E0 C1 5E DB C3 C3 C3 B9 E7 9E 7B 58 B3 66 0D E7 CE 9D BB AE 9B 0E 9B CD 46 5A 5A 5A 81 
ED 0E 87 03 8D 46 C3 C9 93 27 AF BB DF 42 54 66 97 7E FE 89 F3 0B BE 2A 34 1F 5F 71 BA F2 7E 70 
8F EA FB 18 E3 BA DB AA 2A A8 7A 0D 0E BB 9D 33 67 CE 90 91 91 81 C5 62 41 AF D7 A3 D3 E9 2A 2C 
68 FE EB 7D 35 99 F6 C3 B1 22 1F DA D5 68 34 38 55 95 E6 0D 1B 53 2B 22 82 B0 E0 10 FE D8 BF 87 
17 66 6F E3 9F 0F D6 A2 5A A0 11 AD 56 8B 46 A3 91 C0 5F 54 69 11 11 11 18 8D C6 8A EE 86 10 15 
A2 4A 06 FD 26 93 09 93 C9 74 C3 E7 71 8F 22 16 F5 21 BA 7F FF 7E 00 DA B6 6D 5B 60 5F 6C 6C 2C 
AB 57 AF E6 D4 A9 53 D7 15 F4 1F 38 70 80 55 AB 56 15 D8 6E 30 18 70 38 1C CC 9B 37 AF D4 E7 14 
A2 B2 AB 77 2C 99 9A 27 4F 14 BA 4F 05 CE EB 74 05 B6 95 96 0A 5C B8 70 81 DF 17 2F C6 64 32 61 
30 18 3C 01 7F 45 06 CC F5 B5 E1 1C 74 15 2C 14 A0 D1 68 50 81 26 D1 31 54 0B 0D C3 EE 74 E1 E7 
E7 4F F3 98 58 76 1D D8 C3 94 C5 49 34 D5 ED C6 A2 B5 CB 88 BF A8 F2 86 0F 1F 4E AD 5A 25 3F 2B 
23 C4 ED A8 4A 06 FD 37 4A A3 D1 B0 6E DD 3A 74 3A 1D 7A BD 9E A8 A8 28 EE BE FB 6E 5E 7B ED 35 
EA D6 AD EB 69 77 F6 EC 59 00 82 83 83 0B 9C 23 34 34 14 80 8B 17 2F 5E 57 1F EA D7 AF 4F FF FE 
FD 0B 6C 5F B7 6E 1D 06 83 81 2E 5D BA 5C D7 79 85 A8 94 5C 4E D2 BE 9C 4F 56 11 01 3F A8 A0 01 
45 93 57 9B 40 D5 68 C8 0E 0A C6 A9 2F F9 2D 2E 7F 20 AC D5 6A D1 E9 74 04 C6 34 22 BE 6D 3B AC 
56 AB 27 F0 77 8F 94 57 A4 25 BF A7 F2 CB 81 4C CF EF EE 80 BF 51 54 43 AA 85 85 E1 54 14 CF 3E 
7F 6B 5E E0 BF E7 F0 7E 8E 18 DA 31 B2 5B 28 D5 02 8D 9E 9B 97 8A 7E 2D 42 54 04 F7 67 AF 10 55 
91 04 FD D7 E1 A5 97 5E E2 F8 F1 E3 F8 FB FB 93 9A 9A CA 86 0D 1B 98 33 67 0E 4B 97 2E 65 E7 CE 
9D 9E 87 83 DD A9 43 85 7D AB 60 36 9B 01 C8 CC CC 2C B0 CF 17 C1 C1 C1 85 DE 4C 6C D8 B0 01 8B 
C5 42 A3 46 8D AE EB BC 42 54 36 CE CC 4C 12 27 4D 24 6B F7 EE E2 1B AA 79 FF A3 06 06 91 F5 60 
3C CE 80 40 9F 1E CA 75 07 C0 3A BD 1E 93 C9 84 D5 6A 25 20 20 80 A0 A0 20 FC FD FD 2B 45 7A 0F 
E4 7D B3 F8 5C 03 95 F4 2F 76 B0 E3 48 EA 95 67 16 A0 7E DD 68 42 82 82 B1 3B 5D DE CF 2D 00 66 
8B 95 46 D1 8D 38 94 7C 88 59 1B D2 99 34 B4 25 B5 C2 AC 92 EA 23 84 10 55 90 04 FD D7 E1 DA 11 
F6 17 5E 78 81 A9 53 A7 F2 C2 0B 2F 30 79 F2 64 3E FE F8 63 00 82 82 82 00 48 4F 4F C7 CF CF CF 
EB 18 BB 3D EF 81 C3 B0 B0 B0 9B D0 63 21 6E 4D 39 E7 CE B1 EB B5 57 B0 9D 28 6A 84 DF 9B A6 66 
2D D4 87 FE 84 D1 68 C4 E0 63 C9 4A 77 E0 AB D7 EB 31 1A 8D 79 C7 5E 49 E9 A9 2C C1 B1 BB FC A6 
06 95 91 0F 34 E4 D9 4F B6 E1 70 2A D4 8B 8C 22 28 28 04 BB 4B 29 72 EE 01 93 C9 42 74 DD FA 1C 
39 7E 84 57 E6 ED F2 0A FC 41 52 7D 84 10 A2 AA A8 D2 75 FA CB D2 F0 E1 C3 01 D8 B1 63 87 67 5B 
78 78 38 40 A1 0F 0B BB 53 7F AE 27 9F 5F 88 AA 20 E3 F0 61 B6 3D F7 4F 9F 03 7E 53 D3 66 04 3D 
3D 02 FF 88 08 02 02 02 F0 F7 F7 27 20 20 A0 C4 C5 DD CE DF DF 1F AB D5 8A C5 62 29 90 CB 5F 91 
DC 01 BF AA AA 5C CE CC E1 DD 25 FB 70 BA 14 EA D4 AA 4B 50 60 30 2E 97 82 CB A5 E0 54 AE AE 9D 
8A 82 4B 51 3D 6B B3 D9 4A BD C8 68 2E 67 BB 78 65 DE 2E 4E 5F B4 A1 28 8A D4 F2 17 42 88 2A 44 
46 FA CB 48 EE 95 D2 81 EE 40 1F A0 41 83 06 00 6C DD BA 95 26 4D 9A 78 B5 DF BE 7D 3B 41 41 41 
44 45 45 DD B4 3E 0A 71 AB B8 F8 FB 56 F6 BC FD 16 AE 9C 1C 9F DA 87 74 BB 97 D0 FE 8F 60 77 3A 
71 3A 9D A5 0A 68 DD 41 BD 56 AB F5 8C F6 9B CD 66 8C 46 63 85 8F F6 BB FB AF AA 2A E9 B6 5C 5E 
FF 6A 37 47 CE 64 52 A3 7A 1D AC FE 41 79 29 3D 45 1F 4D FE BA A4 7A 83 99 DA 35 EB 72 2A E5 B8 
8C F8 0B 21 44 15 24 23 FD 25 48 49 49 61 77 BE 5C 62 25 DF 83 72 F9 CD 9F 3F 1F 80 BB EE BA CB 
B3 ED 91 47 1E F1 EC CB 1F 7C 24 26 26 B2 79 F3 66 06 0D 1A 54 26 55 84 84 B8 9D 9C 5E B9 82 C4 
37 27 FA 1C F0 D7 7D EC 71 EA 3F 3D 02 EB 95 91 FB C0 C0 40 82 82 82 08 0A 0A F2 3C FB 52 DC E2 
6E 1B 14 14 44 40 40 00 56 AB 15 B3 D9 5C 69 AA F6 28 8A 82 CB E5 E2 FB 2D 27 48 4A C9 20 28 28 
14 7F FF 40 9C 2E 05 97 A2 E0 74 B9 17 57 BE B5 2B 6F A4 FF CA DA A5 A8 28 AA 8A D1 E4 47 68 68 
04 17 33 72 99 BB EE 88 E7 E6 48 08 21 C4 ED AF 4A 8E F4 E7 E6 E6 F2 F9 E7 9F A3 28 0A 59 59 59 
00 24 27 27 33 73 E6 4C 00 7A F6 EC E9 19 81 EF D2 A5 0B 87 0F 1F E6 E8 D1 A3 D4 AB 57 8F 19 33 
66 B0 68 D1 22 06 0D 1A 44 C3 86 0D B1 D9 6C AC 5A B5 8A CF 3E FB 8C 66 CD 9A 31 66 CC 18 CF 75 
1A 36 6C 48 BF 7E FD 58 BA 74 29 43 87 0E 65 C0 80 01 5C B8 70 81 89 13 27 12 16 16 C6 D8 B1 63 
6F FA 6B 17 A2 32 4B 9E 37 97 A3 0B BE F6 A9 AD 46 6F A0 C9 3F C7 10 D6 A9 33 2E 97 0B 9D 4E 87 
A2 28 9E 1B F3 D2 06 B3 EE EA 3D EE 0A 3E F9 D7 15 21 7F 5A 8F CB E5 A2 6B B3 30 D6 EF 3E C7 F9 
F4 34 8C 46 3F CC 16 AB D7 04 64 1A 34 A8 A8 68 AE 4C 4E E0 FE 59 F5 14 2E D5 E0 B0 E7 70 F1 E2 
59 AC 26 3D 7D DB 45 E0 74 3A BD 6E 6A 64 B4 5F 88 DB C3 A5 AC D3 04 FB 49 69 52 E1 AD 4A 06 FD 
29 29 29 8C 18 31 C2 2B 28 D8 B1 63 07 23 47 8E 04 E0 B3 CF 3E F3 04 FD 61 61 61 9C 3E 7D 1A 7F 
7F 7F 00 BA 75 EB C6 82 05 0B 18 33 66 8C 27 B8 B0 5A AD 8C 1C 39 92 D7 5F 7F 1D 8B C5 E2 75 AD 
05 0B 16 30 62 C4 08 16 2F 5E CC FC F9 F3 31 1A 8D B4 6B D7 8E 59 B3 66 D1 B8 71 E3 9B F0 6A 85 
A8 FC 54 A7 93 7D 33 FE CD D9 9F 7F F2 A9 BD C1 3F 80 E6 AF 4C 20 A8 59 73 CF EC BB 3A 9D AE 40 
4A 8F AF 81 7F FE A0 37 FF 52 D1 A9 2F AA AA 7A 46 FA FD 0C 2A FF E8 59 93 7F 2F 3F C9 85 0B A7 
08 0E A9 81 D1 6C BD 1A E4 17 98 85 98 AB 19 3E 80 D3 91 4B EA 85 53 28 8A 42 9B 06 FE 54 0F D4 
E3 74 3A BD 52 98 84 10 B7 BE 53 A9 BB F9 F1 F7 89 74 8A 7D 92 E6 75 1E AC E8 EE 88 4A A4 4A 06 
FD 51 51 51 45 A6 E9 5C EB B7 DF 7E C3 E1 70 78 66 F0 6B D3 A6 0D 5B B6 6C 21 23 23 83 93 27 4F 
12 18 18 48 AD 5A B5 8A FC C0 34 1A 8D CC 99 33 87 D9 B3 67 93 9C 9C 4C ED DA B5 25 A5 47 88 7C 
9C 36 1B BB 27 BF 41 DA AE 5D 3E B5 37 47 54 A7 D5 1B 6F E2 17 59 A7 40 C0 0F A5 1F E1 CF 2F FF 
DF 71 65 19 FD 76 8F F4 3B 9D 4E 2C 7A 85 3F DF 65 65 D6 C6 74 D2 52 53 08 0C AE 8E D1 6C CD D7 
F8 EA 8F 1A F5 CA C8 BF AA C1 E9 C8 E5 D2 C5 D3 28 AA 82 06 95 8D 07 33 B8 68 3B C2 3F FA C4 50 
CD 68 94 14 1F 21 6E 23 BF 27 E5 7D 5B FA C7 91 C5 C4 D6 EE 8E 4E 6B 28 B7 6B 1D 3F 7E 9C F4 F4 
74 9A 37 6F 5E E8 7E F7 44 A2 43 86 0C F1 7A E6 51 54 8C 2A 19 F4 97 86 46 A3 29 74 CA EE 80 80 
00 62 63 63 4B 75 9E FA F5 EB 97 65 D7 84 B8 E5 E5 9E 3F CF CE D7 27 60 3B 76 CC A7 F6 01 0D 1B 
D2 F2 F5 37 30 06 87 00 85 07 E4 65 11 A4 57 74 A0 9F 5F FE 9B 19 45 51 F0 33 A8 0C 6A A5 E1 EB 
1D 0A 97 2F 9D C5 2F A0 1A 7A A3 5F 81 91 7D F7 CF 2E 87 1D DB E5 B3 A8 57 02 7E 77 78 BF EF 94 
8D 7F CD DF CB 73 FD 9A D0 2C 2A D4 73 03 25 84 B8 79 5C 8A 9D E4 73 5B B8 64 CB BB 29 BF 51 19 
D9 E7 38 93 76 80 C0 A0 20 D2 2F 5F 62 E5 1F 6F 53 2D A8 E1 0D 9F 57 AB D1 12 60 89 20 3A E2 4E 
8C FA AB 25 C8 87 0F 1F CE CF 3F FF 5C E4 C0 C1 07 1F 7C C0 07 1F 7C 40 58 58 18 8F 3D F6 D8 0D 
F7 A3 B2 38 7C F8 30 61 61 61 84 84 84 54 74 57 4A 45 82 7E 21 44 85 C8 4C 3E C2 AE D7 26 90 9B 
9A EA 53 FB B0 F6 77 D0 EC 85 97 D0 5D 99 D8 EE 5A B7 6B C0 9A 3F D5 C8 3D 0B 78 A0 45 C7 C3 4D 
ED 2C DA A3 25 3D E3 3C 66 FF 70 74 06 CB B5 47 A2 B8 72 C9 4E 3F 5F 20 E0 77 BB 98 61 E7 D5 2F 
13 79 BA 67 0C BD EE A8 73 B3 5E 92 10 82 BC BC FB E5 DB 26 93 91 7D AE EC 4E AA 01 BD 4E 4F C3 
C6 31 EC DF B3 97 53 17 77 71 F2 A2 6F DF A2 FA 62 8B 71 3E 3D DB 8C A7 7A 50 DE 04 A0 25 7D 4B 
38 6A D4 28 A2 A3 A3 E9 D9 B3 67 99 F5 A1 A2 D9 6C 36 62 62 62 18 3E 7C 38 9F 7D F6 59 45 77 A7 
54 A4 7A 8F 10 E2 A6 4B DD BE 9D 3F C6 8F F3 39 E0 AF F5 C0 83 B4 9C F0 5A 91 01 FF ED EA DA 60 
DF 68 34 62 32 99 30 99 4C 04 5B 0D FC 29 D6 49 A0 C9 45 4E E6 79 72 73 6C D8 9D 2E CF 92 9B 9B 
53 6C C0 EF E6 74 A9 7C BC FC 20 EF 2E DA 4D AE E3 C6 47 1A 85 10 BE 50 59 B3 63 5A D9 06 FC 79 
A7 A5 5A CD 6A A8 AA 93 1A B5 6A 14 F9 77 7F BD B2 ED 97 59 BD 63 1A 4E 57 AE 4F ED 9B 36 6D CA 
D8 B1 63 6F CB D4 9E 5B 31 2D 52 82 7E 21 C4 4D 95 B2 66 15 89 13 5F C5 99 9D ED 53 FB FA 43 87 
D3 F8 EF A3 A1 82 AA E8 54 94 FC 0F 14 EB 74 3A CF FC 01 16 8B 05 3F 3F 3F 2C 16 0B 21 FE C6 2B 
81 BF 82 33 FB 22 76 77 E0 6F CF C1 99 75 1E 0D C5 07 FC F9 AD 4F 3C CB 98 4F 12 38 75 31 AB DC 
5F 9B 10 55 DD D9 CB 87 48 CD F4 6D E2 41 9F 69 40 A7 D3 11 12 16 84 C3 69 C7 EA 6F C6 6C 31 53 
D6 DF 81 66 E5 A6 71 FC C2 76 9F DA AE 5C B9 92 5E BD 7A 91 94 94 E4 D9 B6 62 C5 0A FA F4 E9 43 
76 76 36 0B 17 2E E4 A1 87 1E A2 7D FB F6 8C 1E 3D 9A CB 97 2F 17 38 87 CB E5 62 C6 8C 19 F4 EE 
DD 9B D6 AD 5B 33 64 C8 10 56 AD 5A E5 D3 F5 55 55 65 E6 CC 99 0C 1C 38 90 96 2D 5B 12 1F 1F CF 
9B 6F BE 49 CE 35 25 A1 97 2C 59 42 AF 5E BD 38 79 F2 A4 D7 F6 C4 C4 44 E2 E3 E3 59 BF 7E 3D 00 
33 67 CE F4 A4 29 FD FC F3 CF 0C 18 30 80 01 03 06 78 95 76 AF CC AA D6 A7 A8 10 A2 42 1D 9D FF 
05 FB FF 67 06 8A AB B8 49 A5 F2 68 0D 06 9A 8E 7B 9E 7A 83 06 DF 84 9E 55 5E EE 91 7E 83 C1 80 
C9 64 C2 CF CF 0F AB D5 8A D5 6A C5 CF CF CF 2B F0 D7 38 2E A1 D8 33 D1 E4 A6 61 D4 A9 0C 68 9A 
CB 1D 75 C1 D7 CC A7 63 E7 32 F9 E7 CC 04 36 EE 29 E3 D1 47 21 84 97 AC DC B4 B2 3F A9 0A A1 D5 
82 51 54 27 4E 97 1D 87 D3 4E 78 F5 90 32 1F ED 07 DF FB BF 6F DF 3E 96 2F 5F 4E 4A 4A 8A 67 DB 
FE FD FB F9 F1 C7 1F 79 F6 D9 67 19 32 64 08 4E A7 13 B3 D9 CC FB EF BF 4F 8F 1E 3D BC 8E 77 38 
1C DC 7B EF BD 8C 1F 3F 9E 88 88 08 BA 76 ED CA EA D5 AB 79 F0 C1 07 F9 EF 7F FF 5B EC B5 1D 0E 
07 3D 7B F6 64 E4 C8 91 A4 A4 A4 D0 B9 73 67 6C 36 1B AF BE FA 2A 6D DB B6 F5 BA C1 48 4C 4C 64 
F9 F2 E5 9C 3F 7F DE EB 1C 27 4E 9C 60 C5 8A 15 1C 38 70 00 00 A7 D3 89 CD 66 F3 FC 9C 99 99 49 
66 66 E6 2D 93 5E 2A 41 BF 10 A2 DC A9 2E 17 FB FE 33 9D E4 AF E6 FB D4 5E 6F B5 D2 6A E2 9B 54 
EF 7A 6F 39 F7 AC 72 CB 3F D2 9F 7F B6 60 3F 3F 3F FC FD FD 3D 81 7F 68 80 C9 13 F8 6B 9D 99 18 
75 0A FD 9A E4 52 2B C4 C0 7D 4D 2C 0C ED 10 80 9F C9 46 54 26 97 00 00 20 00 49 44 41 54 B7 B7 
FB AC 5C 27 53 BE D9 C5 AC 55 87 50 94 5B EF EB 6B 21 6E 05 21 D6 DA 65 7B 42 4D DE 00 81 D9 5F 
4F 4E 4E 26 39 39 99 64 E7 64 A0 37 AA 18 4C FA 32 1F ED 0F B6 46 DE F0 39 BE FF FE 7B B6 6F DF 
CE B2 65 CB D8 B0 61 03 03 07 0E 64 EB D6 AD FC FA EB AF 9E 36 33 67 CE E4 97 5F 7E E1 EB AF BF 
66 F6 EC D9 CC 98 31 83 53 A7 4E D1 B4 69 53 5E 7E F9 65 32 32 32 8A 3C FF CC 99 33 59 B3 66 0D 
6F BE F9 26 1B 36 6C E0 A3 8F 3E 62 FD FA F5 BC FD F6 DB EC DD BB 97 A9 53 A7 96 BA CF CF 3C F3 
0C 4B 97 2E 05 A0 7B F7 EE AC 5C B9 92 95 2B 57 D2 AC 59 B3 D2 FF 07 A8 00 12 F4 0B 21 CA 95 2B 
3B 8B 5D AF 4D E0 CC BA B5 3E B5 37 57 AB 46 DC D4 E9 04 B7 6C 55 CE 3D BB 35 E4 7F 90 D7 60 30 
60 34 1A 3D 29 3E F9 03 FF B0 40 33 03 9A AB C4 56 53 78 B8 A9 93 DA A1 57 BF 15 88 6B 10 CA 84 
FE F5 A9 5F DD 5A F2 05 AF 58 B2 E9 18 2F CC D9 46 6A 86 BD 1C 5F 9D 10 55 53 B0 35 92 A8 88 F6 
65 77 42 15 FC 83 CD 28 8A 03 A7 D3 8E D3 69 C7 E5 CA FB 39 28 C4 52 A6 A3 FD 11 41 0D 88 0C 6B 
71 C3 E7 99 33 67 8E 57 A9 CF 81 03 07 02 79 95 71 DC 66 CF 9E 4D 83 06 0D 78 F8 E1 87 3D DB 4C 
26 13 BD 7A F5 22 2D 2D 8D 9D 3B 77 16 79 FE FF FE F7 BF 84 87 87 33 7E FC 78 AF ED 63 C6 8C 21 
34 34 94 6F BE F9 E6 86 5F C3 AD 46 AA F7 08 21 CA 4D EE C5 0B EC 7A ED 55 32 8F 26 FB D4 DE BF 
7E 7D 5A BD FE 26 C6 D0 D0 72 EE D9 AD 25 FF 44 61 06 43 C1 9A DB EE FD 7A 7D 2E BD 9A B9 D0 6A 
B5 18 8D 46 FC FC FC 3C 4B 98 C5 C2 A4 C7 C3 99 FB D3 31 56 6D 4F 29 70 8E C2 EC 3D 7E 89 67 FF 
BB 99 17 1E 69 41 CB A8 5B AB 34 9D 10 95 DD BD 2D 9E E5 E7 3D 1F 73 E4 CC 6F 37 76 22 0D 68 D1 
60 B6 6A 70 3A ED 70 4D 88 AF 33 82 DE A8 C5 65 57 6E 38 F8 AF 1D D6 82 FB 5A 8C 86 32 F8 EE 20 
28 28 C8 EB F7 6A D5 AA 01 90 96 76 35 75 E8 D0 A1 43 18 8D 46 EE BF FF 7E AF B6 EE 74 A1 6B 73 
F0 DD 14 45 E1 F0 E1 C3 DC 75 D7 5D 05 CA AE 1B 8D 46 62 63 63 49 48 48 F0 CC E6 5E 55 48 D0 2F 
84 28 17 B6 A3 C9 EC 7C FD 55 72 2F 5C F0 A9 7D 68 5C 5B 9A BF F4 2F 74 96 6B 4B 4F 0A 28 3A F0 
CF 9F 02 64 30 18 50 14 C5 13 F4 5B 2C 16 CF 62 34 1A 31 18 0C 3C D3 BB 09 CD EA 85 F2 E1 8F FB 
7C AA D6 73 29 D3 CE 2B 73 B7 33 EC BE 86 0C E8 5C AF DC 5E 9F 10 55 8D 41 67 A1 47 CB B1 64 36 
BA C0 E5 AC D3 3E 4F 1A 9A DF 85 8C 64 12 0E 7D 89 39 50 8B CB 65 CF 7B 80 A7 90 59 B9 FD 02 B4 
A4 5F 54 68 1A D9 83 A8 88 3B 4A 7D 1D 8D 46 43 A0 A5 3A 81 7E 35 4A 7D AC AF B4 D7 14 6B 70 3A 
9D 64 65 65 11 1E 1E 4E C7 8E 1D 0B B4 1F 38 70 20 F7 DD 77 5F A1 E7 CA CE CE 26 37 37 17 4B 11 
9F 27 26 93 09 45 51 50 14 45 82 7E 21 84 B8 11 69 3B 76 B0 FB AD 49 38 B3 6C 3E B5 AF D9 E3 7E 
1A 3F FB 0F 34 55 AC 42 4F 69 15 17 F8 EB F5 7A CF 07 99 7B 52 41 77 79 4F 93 C9 84 5E AF 47 A7 
D3 A1 D5 6A B9 B7 55 0D 1A D6 0A 60 F2 82 44 4E 5D 28 F9 FF 23 97 A2 32 67 CD 21 F6 9D B8 C4 D8 
3F 35 C3 6A 96 8F 0E 21 CA 8A BF 39 1C 7F F3 F5 95 B4 DC 96 BC 30 EF 21 52 8D 93 DC 1C 0D AA 7A 
F5 C1 7D F7 CF AA 9A 57 C5 46 AB D3 72 F4 5C 02 1D 9B FC B9 5C 67 E9 2D 2B 7A BD 9E C8 C8 48 AC 
56 2B AF BF FE 7A A9 8E B5 5A AD 84 87 87 73 F4 E8 D1 42 F7 27 27 27 53 AF 5E 3D CF FB A8 FB E6 
20 3D 3D DD AB 5D 71 0F E8 4A C9 4E 21 44 95 77 66 DD 5A 76 BD 3E C1 E7 80 3F 7A C8 E3 34 F9 C7 
18 09 F8 7D E4 0E FC DD 39 FE 26 93 09 8B C5 82 D5 6A 25 20 20 C0 B3 58 AD 56 2C 16 4B 81 80 DF 
7D 8E 7A 11 FE FC CF 5F EF A0 53 D3 08 9F AF BD 79 FF 79 FE 31 33 81 23 67 32 CB EB E5 09 21 7C 
94 91 7D 8E B3 69 07 50 55 95 AC CB 1A 32 53 C1 96 06 99 A9 78 FD 6C 4B 83 AC 4B 1A 14 97 4A 96 
FD 32 A7 52 13 2B BA EB 3E EB D0 A1 03 7B F7 EE 25 31 B1 F4 7D EE D8 B1 23 FB F6 ED 63 F3 E6 CD 
5E DB D7 AE 5D 4B 72 72 32 BD 7B F7 F6 6C AB 5D 3B EF C1 EA ED DB AF 96 22 CD CC CC 64 CA 94 29 
05 CE 6B 36 9B D1 E9 74 24 27 FB 96 B6 5A 99 C8 70 8D 10 A2 CC 1C FB FA 2B 8E 7C F1 B9 4F 6D B5 
7A 3D 8D 9F FD 07 35 EE EB 5E CE BD BA FD E4 1F F1 D7 EB F5 9E B2 9E 8A A2 78 46 9F 74 3A 9D 67 
71 DF 24 B8 8F 75 B3 98 74 BC 3C A8 25 8B 37 1D E7 B3 B5 87 71 B9 4A 4E 2F 48 49 CD E2 B9 59 5B 
79 A6 57 13 BA B7 A9 59 0E AF 4E 08 E1 8B 00 4B 04 BD DB BD 86 DD E9 FB DC 1A 3A AD 9E 3A 61 AD 
CB BC 2F AF BC F2 8A D7 EF 06 83 A1 C0 B6 EB F1 E6 9B 6F B2 64 C9 12 7A F6 EC C9 C4 89 13 69 D9 
B2 25 B9 B9 B9 24 24 24 B0 72 E5 4A D6 AE 2D BA 40 C4 1B 6F BC C1 B2 65 CB E8 DD BB 37 13 26 4C 
20 36 36 96 5D BB 76 F1 C6 1B 6F 10 1E 1E EE D5 BF 07 1E 78 00 AB D5 CA C4 89 13 31 9B CD 18 8D 
46 DE 7F FF FD 02 23 FF 90 F7 DE DA B8 71 63 B6 6E DD CA D4 A9 53 A9 5E BD 3A 1D 3B 76 24 26 26 
E6 86 5F 6F 79 93 A0 5F 08 71 C3 54 45 E1 C0 07 EF 91 B2 DA B7 09 53 F4 7E 56 9A BF FC 2F 42 5A 
B7 29 E7 9E DD BE DC 81 7F FE 91 FF FC 39 C1 F9 F7 B9 03 FD A2 BE AA 7E B8 63 5D 1A 47 06 F2 F6 
37 89 A4 66 94 3C D3 A6 DD E1 E2 3F 4B F7 B0 F7 C4 25 46 C5 37 C6 A0 97 6F 69 84 A8 08 B5 43 9B 
97 DC A8 1C 45 47 47 B3 7E FD 7A 26 4F 9E EC B5 5D AF D7 33 6E DC 38 F4 FA BC 30 33 7F 3A 62 61 
DB F2 6F 77 AF 01 1A 35 6A C4 AF BF FE CA A8 51 A3 18 31 62 84 67 50 23 34 34 94 A1 43 87 16 DB 
B7 56 AD 5A B1 61 C3 06 46 8C 18 C1 98 31 63 50 55 15 93 C9 C4 BD F7 DE CB 27 9F 7C E2 79 70 D8 
7D BE 6F BE F9 86 E1 C3 87 F3 B7 BF FD 0D 93 C9 C4 E0 C1 83 79 F9 E5 97 69 DC B8 71 81 BE FE FB 
DF FF 66 F0 E0 C1 BC F0 C2 0B 68 B5 5A 36 6E DC 78 4B 04 FD 9A A9 53 A7 C6 39 9D CE 6D 7D FA F4 
F1 2A 9D 24 6E 4D 9F 7E FA 29 16 8B 85 21 43 86 54 74 57 44 15 E1 CA CE 66 CF DB 93 B9 B8 6D 9B 
4F ED 4D E1 E1 B4 7A FD 0D AC 51 D1 E5 DC B3 AA C1 FD 21 A8 AA AA 57 8E 69 FE 40 DF D7 89 63 2E 
D9 EC BC FD 4D 22 89 47 7D 9F 38 A8 41 CD 40 5E 1E D4 82 1A 21 F2 00 B6 10 C2 9B AA AA 64 65 65 
61 B5 5A 8B DD E6 66 B3 D9 F0 F3 F3 2B F4 3D 2B 3B 3B 9B A3 47 8F 12 10 10 40 ED DA B5 4B 35 21 
96 CD 66 E3 F4 E9 D3 44 47 47 7B DD 54 14 E6 E8 D1 A3 54 AF 5E DD 93 E7 9F 95 95 85 9F 9F 5F 81 
76 4E A7 93 63 C7 8E 11 1A 1A 4A 48 48 E5 AE 6E B6 70 E1 42 92 92 92 8E CA F0 8C 10 E2 BA D9 53 
53 F9 E3 85 E7 7D 0E F8 FD A3 A2 69 3B FD 3F 12 F0 97 21 77 50 9F 7F C4 BF B0 51 7E 5F 04 5B 8D 
BC F5 44 5B 06 74 8E F2 F9 98 A4 94 74 FE 31 33 81 84 83 BE 55 69 12 42 54 1D 1A 8D A6 40 70 5F 
D8 36 37 AB D5 5A E4 7B 96 C5 62 21 36 36 96 C8 C8 C8 52 CF 80 6B B5 5A 89 89 89 29 31 E0 07 88 
8A 8A F2 AA FA 53 58 C0 0F 79 DF 48 34 68 D0 A0 D2 07 FC F9 49 D0 2F 84 B8 2E 59 C7 8F B3 6D DC 
18 32 8E 24 F9 D4 3E B4 75 1B E2 A6 4E C3 14 76 7D 55 2A 44 F1 F2 07 FF A5 19 DD BF 96 56 03 7F 
EE D1 90 09 8F B6 F2 B9 4A 4F 66 B6 83 37 BE DC C9 E7 EB 92 90 49 7C 85 10 A2 72 92 A0 5F 08 51 
6A 97 12 77 B1 7D FC 73 E4 9C 3B E7 53 FB 1A F7 DE 47 CB 89 6F A2 2B 62 C4 44 54 3E 1D 9A 54 E3 
7F 46 DC 49 74 8D 00 9F DA AB AA CA 82 5F 92 79 E5 F3 ED 5C B6 39 CA B9 77 42 08 21 4A AB CA 07 
FD AA AA B2 65 CB 16 8E 1C 39 52 EA 63 33 32 32 58 B7 6E 1D BF FE FA 2B D9 D9 D9 65 D6 56 88 CA 
EC EC CF 3F B1 F3 D5 57 70 64 FA 56 B6 31 6A D0 A3 C4 8E 1D 87 A6 0A 4D 80 72 BB A8 19 6A E1 DF 
4F B7 A7 7B 9B 5A 3E 1F B3 F3 48 2A A3 FF BB 85 7D 27 2E 97 63 CF 84 10 42 94 56 95 0E FA 0F 1F 
3E CC BD F7 DE 4B 87 0E 1D 18 37 6E 9C CF C7 39 9D 4E 9E 78 E2 09 82 83 83 E9 DE BD 3B 9D 3B 77 
26 30 30 90 E9 D3 A7 DF 50 5B 21 2A BB E3 DF 7E C3 BE E9 EF A2 38 4A 1E C9 D5 EA 74 34 19 FD 4F 
A2 87 0E BB 09 3D 13 E5 C5 A8 D7 32 A6 5F 53 9E ED 1B EB 73 95 9E 0B E9 39 BC 38 67 1B DF 6F 3E 
51 CE BD 13 42 08 E1 AB 2A 19 F4 2B 8A C2 3B EF BC 43 8B 16 2D 38 79 F2 64 A9 8F 7F FA E9 A7 99 
3B 77 2E CF 3D F7 1C 89 89 89 6C DB B6 8D 4E 9D 3A 31 6E DC 38 3E FF FC F3 EB 6E 2B 44 A5 A5 28 
1C FC F0 7D 92 E6 CE F1 69 16 42 BD C5 42 8B D7 26 52 F3 FE 9E 37 A1 73 E2 66 78 A0 6D 6D A6 FD 
A5 3D D5 7D AC D2 E3 74 29 CC 5C 71 80 77 BE 4D 24 C7 EE 2A E7 DE 09 21 84 28 49 95 0C FA B7 6F 
DF CE 5B 6F BD C5 94 29 53 D8 B4 69 53 A9 8E 4D 49 49 61 DE BC 79 F4 EF DF 9F A9 53 A7 D2 BC 79 
73 E2 E2 E2 58 B8 70 21 26 93 89 4F 3E F9 E4 BA DA 0A 51 5E DC A5 1C AF 77 71 E5 E4 B0 EB 8D D7 
39 B5 62 B9 4F D7 33 85 86 D2 E6 9D 77 09 8D 6B 5B CE AF 4C DC 6C 0D 6B 06 F0 DE C8 3B B9 A3 91 
EF 0F 63 FF B2 FB 2C FF FC 24 81 13 E7 7D 9B A1 59 08 21 44 F9 A8 92 93 73 B5 68 D1 82 23 47 8E 
10 16 16 C6 A5 4B 97 4A 75 EC 82 05 0B 70 B9 5C 0C 1E 3C D8 6B 7B 78 78 38 F7 DC 73 0F 6B D6 AC 
E1 DC B9 73 44 44 44 94 AA 6D 69 D9 6C 36 D2 D2 0A D6 D2 76 38 1C 68 34 9A EB FA 06 43 DC 5E DC 
23 F2 D9 C9 47 C8 D8 B8 11 95 D2 97 55 51 ED 76 B2 F6 EF 43 B1 D9 C0 5D 0D A6 98 91 7E 63 CD 5A 
D4 7A 76 34 97 8C 26 2E C9 BF C1 DB D6 53 F7 84 53 23 10 7E D8 76 A1 B8 7F 0E 1E 27 CE DB 18 FD 
DF CD 0C BD BB 26 77 34 0C 2C FF 0E 0A 51 84 88 88 08 8C 46 63 45 77 43 88 0A 51 25 83 7E 93 C9 
84 C9 64 BA AE 63 F7 EF DF 0F 40 DB B6 05 47 31 63 FF 9F BD 77 8F 8F AB AA F7 FE DF 7B EE B7 CC 
24 33 B9 DF 93 A6 F7 14 6A 5B 14 54 50 14 F1 E0 1D 0B 8F 1E 11 F4 9C 87 23 DE E0 28 E8 E1 A5 F2 
A8 1C D4 1F 3F 3C 78 38 7A 0E 22 F2 08 5A AB 16 8A 54 54 A0 85 8A 5A A5 85 72 69 9B 36 6D D3 A4 
49 7A C9 7D 72 9B CC 7D 5F 9E 3F 26 7B 3A 93 4B 3B 93 A4 49 9A AC F7 EB 35 AF 69 F7 5E 7B CD 5A 
B3 33 7B 7D D6 77 7D D7 F7 BB 72 25 3B 76 EC E0 F4 E9 D3 14 16 16 66 55 36 5B 8E 1E 3D CA F6 ED 
E3 B3 9F 9A CD 66 E2 F1 38 9B 36 6D CA BA 4E C1 C2 21 35 61 53 4D EB 71 4A BA 3A 30 8E C9 28 98 
41 25 00 48 24 D2 8E 03 A8 B2 0C 92 34 A1 8B 4F C0 93 CB 91 CA 6A 94 3F 66 B6 22 30 5B E8 6D 95 
0C 2A 8E D2 2E C2 DD 05 A8 F1 C4 77 31 D5 B0 96 82 04 AB CD 6E 8E C6 97 10 D7 CE 3D 94 C4 64 8D 
FF FB 62 07 CF FC F5 0D 6A 4C 27 31 48 22 B6 A7 60 F6 F9 D4 A7 3E 45 69 69 E6 1B D3 05 82 85 C4 
A2 14 FD D3 A1 BB BB 1B 80 DC DC DC 71 E7 BC 5E 2F 00 7E BF 3F EB B2 D9 52 5B 5B CB C6 8D 1B C7 
1D DF B9 73 27 66 B3 99 2B AE B8 62 4A F5 0A 2E 7C 52 5D 73 54 55 65 78 DB 53 44 BB 3B 79 EB BB 
AE 4A 14 90 00 6D F4 1D 90 90 D0 D0 90 98 58 00 6B 9A 86 34 2A F4 5F FB FB DF 08 4D 10 B5 C7 FE 
A6 75 94 FE E3 0D AC C8 20 F1 C9 6C 92 3A F9 39 39 FC 37 8E 0F EE A7 BA AE 8C E5 DE 6B D3 32 D6 
0A A6 CE 50 48 E1 D1 5D BD B4 F7 C5 32 2A DF A9 14 61 C9 AD E0 D3 57 14 90 EB 10 11 9D 04 B3 8B 
3E F6 0A 04 8B 91 F9 35 42 5F 00 E8 EE 40 13 AD 14 D8 6C 36 00 46 46 45 51 36 65 B3 25 37 37 77 
C2 C9 C4 AE 5D BB B0 DB ED 2C 5B B6 6C 4A F5 0A 2E 7C 74 B1 AF 28 0A F1 78 9C D6 9C 1C A2 80 A6 
2A A3 E7 13 9E 3A 99 B8 65 40 A2 AC AA 9D F1 EE 19 4B E5 C6 EB 59 F2 4F FF 3C 33 8D 9F 41 52 27 
3F 31 39 C2 9E D1 FD 3B 3D A1 FD 5C BE E6 26 3C 8E E2 69 27 B2 9A 2F E8 93 1B 45 8D F1 FA F1 AD 
AC AE B8 06 87 35 91 25 72 36 FA B6 EE A2 15 FC F4 B9 26 7E FF 72 66 D1 7A DA FD 31 1E D8 D1 CB 
BF 5D 57 CF DA 5A 21 C2 04 02 81 60 36 58 94 1B 79 A7 83 C7 E3 01 60 78 78 78 DC B9 58 2C 61 E9 
F2 F9 7C 59 97 15 08 66 82 B4 0D B8 A3 A2 5F 96 65 00 94 58 0C 25 16 43 8D 9F 79 57 E3 31 D4 58 
CA 7B 6C CC B1 78 0C 39 7A E6 3D CD AD C7 60 A0 EE B3 9F A7 E6 53 9F CE 28 A2 CF 5C A0 7F 0F 8D 
27 B7 13 8D 07 58 52 B7 0C D0 78 FD F8 93 C8 B2 8C AA AA C9 EF EB 42 25 75 35 A3 A1 FD 59 DE 68 
DD C6 2B CD BF 4E 3B 7E BE 31 1A 24 3E FB BE E5 DC 79 FD 1A EC D6 CC 6C 49 43 C1 18 FF 67 D3 1B 
FC E6 2F AD E7 B9 75 02 81 40 20 00 21 FA B3 26 3F 3F 11 B5 62 A2 0D C0 BA 3B 8F EE A3 9F 4D 59 
81 60 26 D1 2D FD B1 58 0C 45 49 58 F8 55 59 1E 7D 29 29 EF 0A AA 9A F2 AE 8E 9E D3 DF 65 19 6D 
F4 DF 9A AA 24 97 07 0C 56 2B 75 77 7C 95 A2 AB DF 3B 2F 05 73 EA 6A 47 24 16 A2 E1 D4 1F C8 C9 
F1 50 58 5C 88 AF A0 80 D6 DE 97 18 0C 76 26 45 FF 85 4A AA 1B 57 34 1E 66 7F FB D3 00 34 77 ED 
4A EB DF 6C F5 F1 8A FA 22 FE F3 33 6F A6 B2 C0 99 51 79 55 D5 D8 F4 A7 16 BE F5 CB 7D 8C 84 E5 
F3 DC 3A 81 40 20 58 DC 08 D1 9F 25 4B 96 2C 01 60 EF DE BD E3 CE BD FE FA EB 78 3C 1E AA AB AB 
B3 2E 2B 10 CC 14 A9 42 50 51 94 A4 E8 57 E2 F1 C4 2B 16 3D F3 1E 8B 8E AE 00 44 93 2B 01 89 73 
B1 33 E5 A3 D1 E4 BB A6 69 48 26 23 E5 77 7C 95 9C 8B D7 A2 AA EA 1C F7 76 62 52 57 3B 0E 9F DA 
41 34 16 A0 B4 BC 14 55 53 29 2D 2F 03 34 F6 B7 6F 5B 10 D6 FE F9 B6 9A 51 91 EF E0 3F 3F F3 66 
AE 58 53 9C F1 35 AF 1E EB E3 B6 87 5E A6 B9 23 70 1E 5B 26 10 08 04 8B 1B 21 FA CF 41 67 67 27 
07 0F 1E 4C FE FF FA EB AF 07 60 F3 E6 CD 69 83 68 43 43 03 7B F6 EC E1 63 1F FB 58 D2 87 3F 9B 
B2 02 C1 4C A3 8B FE A4 BF 77 06 A2 7E C2 57 4A 19 34 0D 53 59 39 E6 F2 8A A4 E0 9F 6F 62 39 55 
F0 47 62 21 1A 3B 9F C5 E9 CA C1 E5 76 20 CB 31 4C 26 03 79 3E 2F 6D 7D BB 69 ED 79 99 BE E1 56 
06 83 1D 8C 44 FA 88 C4 87 91 95 28 4C 21 BC E9 6C 33 9F 57 33 6C 16 23 77 5E 57 CF 2D EF 5B 8E 
C9 98 D9 30 D3 3D 18 E6 2B FF 77 2F CF BD 76 FA 3C B7 4E 20 10 08 16 27 8B 72 23 6F 34 1A E5 17 
BF F8 05 AA AA 12 0A 85 00 68 6D 6D E5 27 3F F9 09 00 EF 7D EF 7B 93 16 F8 2B AE B8 82 E6 E6 66 
DA DA DA A8 AA AA A2 AE AE 8E 8F 7C E4 23 6C DB B6 8D 1B 6F BC 91 EB AE BB 8E BE BE 3E EE BE FB 
6E 7C 3E 1F B7 DF 7E 7B F2 73 B2 29 2B 10 CC 24 63 13 6C C1 68 B8 CD 4C 38 4B 74 1F 09 0D 4C A6 
59 F5 17 CF 16 4D 53 E9 0F 9C A0 6B A0 89 A6 CE 17 89 C5 47 28 AF AA 41 56 E2 49 2D 5F 50 94 4F 
7F 9F 9F BF 1D FB F1 A4 3B 9A 8D 06 13 26 A3 15 A3 C1 82 C9 68 C1 68 30 63 32 8C BE 1B 2D 69 E7 
4C 06 0B 46 FD 7D A2 63 67 39 97 A8 3B 51 6F 76 FD 1C BF 9A 51 BD 64 65 72 35 C3 DF DB CB FE F6 
6D BC 7D F9 67 D2 36 2B CF E6 A6 E5 0F BD A5 82 65 65 6E FE BF C7 1B E8 1B 8A 9C B3 7C 5C 56 F9 
D1 D3 87 69 3C 31 C4 17 3E B0 02 AB 59 D8 A5 04 02 81 60 A6 58 94 A2 BF B3 B3 93 5B 6E B9 25 4D 
B0 EC DB B7 8F CF 7E F6 B3 00 3C F6 D8 63 49 D1 EF F3 F9 E8 E8 E8 C0 E5 72 25 CB 6E D9 B2 85 5B 
6E B9 85 DF FE F6 B7 6C DE BC 19 8B C5 C2 86 0D 1B 78 E4 91 47 58 BE 7C 79 DA 67 65 53 56 20 98 
69 52 FF C6 95 78 62 F3 F8 F8 10 9D BA C2 D7 85 FC E4 D1 7D F4 43 F3 C9 1D 26 18 F5 D3 33 D4 4C 
EF 50 33 5D 83 4D F4 0D 1F 27 AE 44 12 9D 90 C0 EE 70 E0 CC 71 A0 AA 4A B2 03 66 8B 91 5C AF 87 
81 FE C1 D4 AE A7 A1 A8 32 8A 2A 03 B3 93 49 56 92 A4 C4 A4 60 82 09 81 C9 68 4E 3B 67 94 CC 18 
0D 66 24 4C 68 48 1C ED 7C 01 87 CB 35 6E 35 A3 DD BF 87 D5 23 1F C0 E7 2E C7 60 30 CC 49 94 A2 
15 E5 1E 7E F4 D9 B7 F0 FF 3F D1 C0 BE E3 FD 19 5D B3 73 5F 07 2D 9D C3 7C E3 E3 17 53 EA B5 03 
67 FE 96 83 11 99 C7 77 B5 71 CD 86 32 8A F3 12 E7 2E F4 E8 4B 02 81 40 30 1B 2C 4A D1 5F 5D 5D 
9D B1 2F F2 EE DD BB 89 C7 E3 69 19 FC 2C 16 0B 8F 3E FA 28 3F FB D9 CF 68 6D 6D A5 AC AC 6C 52 
37 9D 6C CA 0A 04 E7 03 6D D4 C2 AF 29 67 42 76 92 22 EA D3 25 FF 44 21 3A 53 4C FF 73 AC F3 63 
72 90 9E A1 16 7A 87 9B E9 19 3A 46 CF 50 0B A1 E8 F8 CC D4 30 DA 6A 55 23 BF 28 2F 61 E5 4F 13 
F7 1A DE 82 3C 06 FB 87 F4 A9 CE 6C 34 FF AC 68 9A 86 AC 44 13 EE 45 F1 CC AF D3 73 28 14 17 97 
8E 5F CD F0 FB D9 D5 F4 3F 6C A8 F9 38 65 BE D5 58 2D 8E E4 35 B3 89 DB 61 E6 3B 37 AD 63 D3 9F 
5A 78 7C 57 5B 46 13 C6 B6 EE 11 FE F5 27 2F F3 E5 8F AC E2 B2 15 05 68 9A C6 48 38 CE 37 7F B9 
9F 63 1D C3 FC A5 A1 9B EF 7D 6A 2D 25 5E 47 F2 1A 21 FE 05 02 81 60 72 16 A5 E8 CF 06 49 92 26 
4D D9 2D 49 12 B5 B5 B5 19 D7 93 69 59 81 60 26 90 87 86 F0 3F FD 3B A2 AF BD 0A 9A 86 32 1A 26 
76 BC CA 4F 39 76 AE F3 B3 68 DD 57 D4 38 FE 40 1B 3D 43 CD 89 D7 F0 31 86 43 5D 99 AD 30 48 12 
9A 94 C8 87 E1 70 5A 51 55 79 DC 79 93 49 22 27 D7 C5 F0 60 60 52 6B FF BC 67 B4 9F 76 FB 24 AB 
19 79 1E 06 FA 4F B1 B3 F1 3F 90 30 50 E0 AE A5 24 6F 35 65 DE D5 14 E7 AD C0 6C B4 CF 66 53 B9 
E9 DD 4B 58 59 E9 E1 FE 27 0F 11 08 9F 7B 66 13 8A C8 7C F7 37 07 B8 F6 B2 0A 3E 7A 59 05 FF FE 
9B 83 34 77 05 58 52 51 C9 89 AE 0E BE F6 D8 1B 49 E1 2F 92 AD 09 04 02 C1 D9 11 A2 5F 20 58 60 
44 7A 7A 38 B1 F5 09 7A FE F4 02 6A 3C 0E A3 8E 3C 72 34 0A 9C B1 0C EB E2 28 35 E3 EE B9 CE 9F 
3F 97 1E 8D 81 E0 69 7A 75 81 3F 74 8C FE 91 13 A3 EE 35 D9 A3 5B F9 F3 F2 73 12 D6 EF 49 C8 F5 
BA 08 0C 8E CC 1B 6B 7F B6 64 B3 9A A1 69 6A 72 02 B5 BF ED 77 18 24 23 BE 9C 6A 4A BD AB 28 C9 
5B 45 49 DE 4A 2C A6 CC 42 6D 4E 87 4B 96 E6 F3 5F 9F 7D 0B DF DB 72 80 E6 8E F1 39 4C 26 E2 A9 
DD 27 D9 FE 7A 27 E1 B8 C2 EA 25 CB 29 2D 2C C4 97 9B C7 1B 47 0E F1 F5 9F EF E3 BB 37 5D 4C 89 
D7 81 C1 90 D8 03 20 84 BF 40 20 10 8C 47 88 7E 81 60 81 10 3A 71 82 B6 27 B6 D0 F3 97 3F A3 4D 
E0 BE 96 74 EF D1 FF 9F 3C 23 A1 98 34 9A D7 C8 54 1D 35 63 8B 9C 71 01 1A 5F 7E 66 84 B1 EE 87 
AF FB E2 F7 0E B7 10 93 C3 33 52 B7 6E FD B6 58 2C 58 EC 06 64 25 36 E9 EA 85 64 04 47 8E 8D 60 
20 7C E1 59 FB A7 B9 9A A1 6A 0A BD C3 2D F4 0E B7 B0 BF ED F7 48 92 84 D7 55 49 69 DE 6A 4A BC 
89 49 80 CD EC 3E 2F 4D 2F CA B5 F1 1F FF 7B 03 3F 7E E6 28 DB 33 88 D6 23 49 12 A1 98 C2 8A 9A 
A5 14 78 7D C4 64 05 87 C3 45 FD D2 95 1C 3C 76 98 6F FC 62 3F DF B9 F1 22 4A 7D 4E 21 FC 05 02 
81 60 12 84 E8 17 08 2E 70 02 4D 4D B4 3F FE 1B FA 5E DE 73 56 4B BC 12 D7 2D DE E3 15 70 DB 72 
8D 96 55 2A 11 AB CA EA 5D 4C BA 93 77 2A 96 FE 74 3F FC C4 6B 32 3F FC 99 40 B7 7E 7B BC 36 D4 
D1 89 0E 12 A0 92 E2 C2 34 DA 7F 4D C2 9D 67 27 14 88 5C 70 D6 FE 99 5E CD D0 34 0D 7F A0 1D 7F 
A0 9D 86 13 CF 00 90 E7 AA A0 34 6F D5 E8 24 60 15 0E 4B EE 8C B5 DF 6C 32 70 DB 87 56 B2 AA 32 
97 07 FF 70 84 68 5C 99 B0 9C 24 49 68 C0 B2 EA 3A 0A 7C 3E E4 94 09 AD CB E9 62 D5 92 E5 34 B6 
1C E5 AE 4D 07 84 F0 17 08 04 82 B3 20 44 BF 40 70 81 32 B0 7F 1F ED 8F 6F 61 60 FF BE 8C CA 9F 
D9 C8 9B EE CE A3 98 25 5A EB 13 E2 A8 A3 56 A5 E6 0D B0 0D 69 C9 8D BC 69 D1 7C CE A1 89 A7 E5 
87 3F 13 48 12 9A A4 61 36 9B 30 59 A5 84 95 3F 71 82 49 37 2E 48 60 73 9A 88 04 65 7C 39 4B 30 
48 06 14 2D 8E A2 C6 51 D4 18 B2 1A 43 51 12 EF AA 3A B1 30 9D 75 66 69 35 63 60 E4 24 03 23 27 
39 74 72 3B 00 1E 67 49 62 25 20 6F 15 A5 DE 55 38 AD BE 69 77 E5 AA B5 25 2C 29 C9 E1 BB BF 39 
40 67 7F 68 4C 37 25 34 0D 6A 2B 6B C8 F3 E4 12 93 95 33 7F 90 A3 D8 EC 4E 96 56 2F E5 58 EB 31 
21 FC 05 02 81 E0 2C 08 D1 2F 10 5C 60 F4 ED 7E 89 F6 27 1E 67 B8 E9 68 56 D7 9D F1 E9 4F D7 4D 
27 57 9B 88 5B 8D 2C A9 5B 46 6B CB 31 5A D6 28 AC F8 53 7C 42 D1 9F 2E DE 35 06 43 A7 19 08 B5 
E1 0F 1C A7 77 F8 38 FD 23 ED 53 F6 C3 9F 09 12 D6 6F 70 79 4C A8 9A 72 96 8D C7 E9 93 00 87 DB 
44 34 A4 E0 B4 14 72 F9 8A 5B B0 58 2C 18 8D C6 B4 F8 F6 00 1A 2A B2 72 66 12 A0 A8 31 64 25 7D 
62 70 E6 5C 3C 11 8D 67 B4 CC D8 B2 FA 84 62 A2 73 67 DE E3 68 DA 78 57 AD B9 5A CD 18 0A 76 32 
14 EC E4 F0 A9 17 00 70 3B 8A 12 13 80 BC C4 4A 40 8E BD 70 4A F5 D6 14 B9 F8 AF 5B 2E E1 07 BF 
6D 64 CF D1 DE D1 FE 24 04 7F 55 79 35 1E 4F 1E 31 45 9D 34 9E AC D5 6A A7 A6 B2 96 E3 27 8E 0B 
E1 2F 10 08 04 93 20 44 BF 40 70 01 A0 A9 2A 3D 7F 7E 91 F6 27 1E 27 78 F2 C4 94 EA 50 47 E3 F4 
A7 5A FA 55 B3 44 FB 9B AC E4 B8 DC 14 16 17 32 1C 18 A2 4B ED A6 E2 65 19 DB 40 42 6C EA 1A 2B 
E6 96 18 2E 36 13 5E 16 A0 E3 E4 8F 19 89 75 24 E2 E1 CF 31 39 F6 42 F2 5D B5 B8 1D E5 34 9E FE 
03 18 E2 18 2C 2A B2 1C 3B 53 68 AC 58 1C 3B F3 41 C3 6C 83 93 03 AF 30 30 F2 41 F2 3D 15 13 C6 
B5 97 30 60 36 DA 30 1B 6D B3 D3 39 40 D5 64 E2 72 94 98 1C 21 1A 0D 31 12 19 E2 4F 8D F7 21 19 
E3 59 AF 66 84 83 63 37 FB 4E 8F E1 50 37 C3 A1 6E 8E 9E 7E 11 00 97 CD 47 49 DE EA E4 E6 60 8F 
A3 24 A3 7A 34 4D C3 6E 31 F2 F5 8F D5 F3 AB 17 8F F3 9B BF 9D 00 0D 2A 4A 2B F1 B8 73 51 94 D1 
EC CF 68 18 25 99 5C DB 1F 18 8A 5E 89 A2 E6 26 73 4E D8 6C 4E AA CA 6B 68 3F D5 2A 84 BF 40 20 
10 4C 80 10 FD 02 C1 3C 46 8D C5 E8 DC B1 9D 13 BF DD 4A A4 A7 67 7A 75 C9 67 2C C2 FA 46 DD 8E 
35 36 E2 56 A8 AD 28 3B 93 C9 B5 A7 87 B6 B7 58 28 3C 14 23 50 64 60 A4 D8 44 A0 D8 44 CC A9 8B 
A6 20 84 8F 4F AB 2D 53 C5 6E 71 53 E0 59 42 A1 7B 29 85 9E 3A 7C 39 B5 98 0D 0E E2 F1 38 07 DA 
7F 4F 5C 8E E0 CC 05 59 CE DE 0D C7 E2 80 58 44 E2 E0 A9 DF 73 B9 EB 96 A4 A5 1F E6 56 30 1A 24 
13 66 A3 01 03 16 8C 9A 9D E6 CE 97 88 CB 61 F2 F2 6C 59 AF 66 44 82 F2 79 DD BB 30 12 F1 73 AC 
F3 AF 1C EB FC 6B E2 33 AD 79 C9 3D 01 A5 79 AB C8 75 96 8F BB 26 35 BB F3 70 30 CA DE E6 7E 24 
A0 B8 B8 02 A7 CB 93 70 E9 49 21 C7 F1 27 DC B6 ED 20 0D D3 35 7C 03 A9 B3 18 93 D9 46 59 49 25 
A7 3A 4E F0 F5 5F EC E7 7B 37 5D 2C 84 BF 40 20 10 8C 22 44 BF 40 30 0F 51 42 21 4E FF F1 0F 9C 
FC DD 53 C4 06 07 A7 5C 8F 64 30 60 F4 E5 23 F7 F6 D0 6B 4A FF B9 AB 66 89 F6 37 DB 70 3A C7 64 
72 CD F7 D1 B3 A2 8F 9E 15 E6 39 DD D7 6A 36 5A C9 77 D7 52 E8 A9 A3 C0 53 47 A1 BB 2E CD 7D 44 
D3 34 54 55 45 96 65 A2 F1 30 87 3B 9F C5 64 96 30 98 65 C6 05 2F 1A 67 D9 1F 83 A6 81 41 C2 64 
91 38 39 F0 0A 83 C1 0F E1 33 CE 5D 16 DB F4 A6 69 C9 BE 46 E3 61 0E 77 3D 8B D9 62 9C D2 6A 86 
C5 2E 11 0B 6B 78 73 6A 18 18 39 89 AA 9D 5F 57 AC 50 74 80 E6 AE BF D3 DC F5 77 20 31 69 2B C9 
5B 99 5C 0D F0 BA 2A 01 50 55 15 45 51 78 FA E5 93 B4 74 06 C8 CD F5 E1 72 B9 91 15 35 AD 4B 06 
43 8C 3C C7 F3 00 B8 6D AF D0 3B 72 35 D1 B8 2F ED 1E 59 AC 0E 7C BE 42 7A 7A 3A B8 EB 97 07 B8 
ED 83 CB 79 D3 12 DF 9C DF 47 81 40 20 98 6B 84 E8 17 08 E6 11 F1 C1 41 4E FE 6E 1B A7 FF F8 07 
E4 50 70 CA F5 18 CC 66 BC 57 BC 03 E7 3B DF C5 D0 89 76 86 FF F2 22 8A AC A0 28 4A 42 60 49 0A 
FD 6F 0A A3 58 63 14 95 14 8C CF E4 DA E7 9F D5 68 36 06 C9 48 9E AB 82 42 4F 5D F2 95 E7 AA 40 
C2 30 E9 35 BA 18 56 14 85 63 5D 7F 26 26 07 91 0C 12 23 7E E3 D4 1B 22 49 68 AA 42 E3 E9 67 79 
AB F3 9F E7 85 B5 5F 17 FC 8A A2 70 B4 E3 05 62 F1 E0 B4 57 33 5C 96 62 DE 7B D9 37 18 0C 9F A0 
7B E8 08 5D 83 8D F4 0C 1D 23 AE 44 CF 43 0F CE 10 8E 0D 73 BC FB 65 8E 77 BF 9C 68 8F C9 49 49 
DE 4A 8A 3C 2B 28 70 2D E5 1D AB F3 F9 CB C1 1E 7A 87 07 B0 58 1C D8 EC CE B4 4D E7 45 EE BF 62 
94 46 58 52 B7 8C E3 2D CD E4 D9 9F E5 64 F8 13 68 29 BB 97 E3 B1 08 7D 7D DD 48 48 F4 0F 47 F9 
D6 E6 03 94 7A ED 5C BD AE 94 AB D7 95 E1 71 4E 9C 6C 51 20 10 08 16 3A 42 F4 0B 04 F3 80 48 4F 
0F 27 7F BB 95 CE 1D DB CF 64 CE 9D 02 46 BB 9D D2 6B DE 47 D1 FB 3F 80 6A B3 33 32 32 82 CD 66 
23 56 5C C2 E0 48 17 03 D1 63 84 39 41 CC D4 03 06 15 BB 6D 92 4C AE 5E 0F 03 FD 83 E7 2D 76 BD 
DB 51 44 A1 7B D4 82 EF A9 23 DF 5D 8B C9 90 B9 18 D3 45 A0 AA AA A8 AA 8A D3 5C 44 81 73 15 B2 
1C 47 96 E5 E4 E4 E6 5C 09 C5 F4 8D BA 06 83 01 A3 D1 88 D1 68 C4 6C 33 93 67 AF 4E D6 31 97 D6 
FE 71 56 FE 19 5C CD 18 0E 7D 88 02 F7 52 4A BD AB 30 18 AE 43 43 A5 77 B8 85 CE FE 43 74 0C 34 
D2 3D 78 74 E6 72 27 4C 42 4C 0E D2 DE FB 2A ED BD AF 02 60 32 D8 78 EF FA 4A F6 B7 F9 38 D5 DB 
4D 50 59 83 D9 96 83 84 84 C1 10 A7 20 67 27 2E 97 27 B9 FF 44 EB 7E 8D 53 FD EF 26 2A 27 A2 08 
C9 F1 28 FD 7D A7 51 55 15 29 65 2A D0 D1 1F E6 B1 17 5A F8 E5 8B C7 79 FB EA 22 AE D9 50 4E 7D 
D5 CC 85 1F 15 08 04 82 0B 01 21 FA 05 82 39 24 74 F2 04 ED 4F 3C 4E CF 5F FE 7C 26 0A CB 14 B0 
78 72 29 FF D0 87 29 7D FF 07 30 3A 1C C8 B2 4C 24 12 66 28 7A 82 13 81 D7 E9 0D 36 12 52 7A 92 
BF 78 49 92 32 CE E4 3A 5D D5 9F F0 C3 1F B5 E0 8F 0A 7D 9B 39 67 5A 75 42 BA A5 DF 6B 5F C2 EA 
FC 02 02 81 00 C1 60 90 88 1C 21 2E C7 51 14 E5 AC C2 5F 92 A4 84 D0 37 9B B1 9A AD 38 1D 4E DC 
6E 37 39 39 39 19 4D 1A CE 37 B3 B9 9A 21 49 06 8A 3C CB 28 F2 2C 63 6D CD B5 68 9A 4A 5F A0 95 
CE 81 46 3A FA 0F D1 35 78 84 68 7C EA AB 4F 99 20 AB 11 06 23 4D 54 15 43 55 31 28 EA EF 19 0E 
55 32 12 AF C3 62 0A 60 92 46 28 AB 58 99 DC 7F D2 D7 D3 4B 49 EE 0B B4 F4 FC 2F E4 78 94 41 7F 
07 AA 96 2E F8 D3 EA 57 34 FE 7C A0 8B 3F 1F E8 A2 A2 C0 C9 35 1B CA 79 F7 C5 25 B8 EC 62 28 14 
08 04 0B 1F F1 A4 13 08 E6 80 40 53 13 ED 4F 6C A1 6F CF EE 69 89 4A 5B 41 01 15 1F BD 8E D2 AB 
DF 8B C1 6A 25 26 87 38 DE BD 9B 13 7D AF 73 B2 EF 0D 22 F1 C0 F8 8B A6 99 C9 F5 6C 9C CB 0F 7F 
A6 49 DD 04 AA 5B EC 4D 26 13 66 B3 19 83 C1 90 14 EE 93 A1 5B FA F5 6B 8C 46 63 B2 BE F9 20 F8 
61 EE 56 33 24 C9 40 81 7B 09 05 EE 25 5C 54 F5 41 20 91 BC AB 63 E0 10 9D FD 8D 74 0E 1E 26 12 
9B E0 EF 6B 06 31 1A E2 E4 B9 5A C8 93 8E 83 04 0E 7B FA FE 13 6F BE 17 55 7B 8D E6 AE B7 31 E0 
8F A1 9D 45 F0 8F E5 64 6F 90 87 9F 3D CA 63 2F 34 73 F9 EA 42 DE 77 49 39 2B CA 3D E7 B5 3F 02 
81 40 30 97 08 D1 2F 10 CC 22 03 FB F6 D1 FE 44 E6 09 B5 26 C3 59 51 41 E5 C6 EB 29 BA F2 5D 04 
62 7D 1C EA 7E 81 F6 DE D7 E8 1A 38 7C CE 38 F9 33 95 C9 55 C2 90 F4 C3 2F CA 5D 4A A1 67 29 79 
AE F2 B3 FA E1 9F 0F 74 6B BD C9 64 C2 6A B5 02 60 32 99 92 56 FE 6C AF D7 C5 FF D8 18 FD 73 C1 
FC 5A CD 90 F0 E5 54 E3 CB A9 66 4D E5 FB 81 44 F2 AE 8E 81 46 3A 07 0E D1 39 70 98 50 74 EA 9B 
CE CF FE C9 89 BF D9 E2 49 F6 9F AC 28 FE 0D AF 0D BE 8B 70 34 27 EB 75 A9 58 5C 61 E7 BE 4E 76 
EE EB A4 BA C8 C5 FB 2E 29 E7 CA 8B 8A 71 58 C5 F0 28 10 08 16 16 E2 A9 26 10 CC 02 53 4D A8 35 
96 9C BA A5 54 FE AF EB 51 56 F8 68 EB 7B 8D BF EE B9 83 81 E0 E9 CC 2B 98 46 26 57 BB C9 8B CF 
59 43 BE 7B 49 42 E4 E7 D6 61 35 DB E7 D4 E7 5D B7 5E 9B 4C 26 6C 36 1B 92 24 61 36 9B D3 AC E0 
E7 42 B7 82 1B 0C 86 84 30 1E 15 FE 26 93 69 DE 08 7F FD 7D BE AD 66 E4 B9 2A C8 73 55 B0 BA E2 
BD 00 0C 86 3A 92 7B 02 3A 07 0E 13 8C F8 A7 5C 77 4A 07 D0 24 B0 DB 27 DF 7F A2 D1 C5 55 97 FC 
8A 60 C8 43 CF 40 05 DD 03 95 F8 03 25 28 4A 76 43 5C 5B F7 08 0F FE E1 08 3F DB 71 8C 77 AC 29 
E6 7D 1B CA A9 2B 9D BE 2B 9A 40 20 10 CC 07 84 E8 17 2C 6A CE 87 FB 86 2E 12 35 55 A5 FB C5 3F 
71 62 EB 13 53 4E A8 A5 E3 5E 57 8F E9 7D 17 D3 E7 F4 F3 4C DF CF 88 BE 3A 32 B5 B6 91 7D 26 D7 
F0 48 84 42 E7 C5 5C 5A 7B 33 56 AB 35 99 AD D6 64 32 25 E3 9F CF 05 A9 2E 2B 16 8B 25 29 6C B3 
11 FC 13 D5 95 2A 8E E7 43 C8 4E BD 7D 17 C2 6A 46 AE A3 94 5C 47 29 2B CB DF 03 C0 70 B8 7B 74 
4F 40 62 35 20 10 EE CD BA 4E FD 6F 36 93 FD 27 4E FB 10 35 F6 21 6A 4A 0F A2 AA 46 FC C3 25 74 
0F 54 D0 3B 58 41 20 94 97 F1 67 46 62 0A DB 5F 3B CD F6 D7 4E B3 A4 C4 CD FB 2E 29 E3 9D 6B 8A 
B1 59 A6 B1 97 42 20 10 08 E6 18 21 FA 05 8B 12 5D 28 0D 1D 3D 42 D7 F6 ED 68 4C CF E2 A9 0B A7 
FC 37 BF 05 EF BA F5 74 EE D8 CE C9 A7 9E 9C 56 42 AD B8 D7 80 7A 45 2D E1 65 36 9A 63 27 9B 89 
36 FE 00 00 20 00 49 44 41 54 51 87 DB 60 78 CA D5 8D 5A 4C 35 CC 66 53 56 99 5C AD 0E 13 DD 23 
07 08 C5 FD 38 1C 15 49 BF F0 B9 4C 78 94 1A 46 53 17 AF 46 A3 31 E9 FF 9E AD 05 5B 17 BF 7A 3D 
FA 04 40 17 FD 73 9A 9C EB 02 5E CD 70 DB 8B 70 DB 8B 58 5E 7A 25 00 23 91 3E 3A 07 0E 8D 4E 02 
1A 19 0A 75 9D AB E1 53 DE 7F 62 30 28 14 E4 9E A2 20 F7 14 B0 9B 48 D4 49 CF 60 E5 E8 24 A0 0C 
59 C9 2C 5A 54 4B E7 30 3F 7A 7A 98 47 B6 1F E3 CA 8B 8A B9 66 43 19 B5 C5 C2 FA 2F 10 08 2E 3C 
16 BD E8 6F 6A 6A A2 A9 A9 89 FA FA 7A AA AB AB 33 BA 66 60 60 80 AE AE F1 83 95 CD 66 A3 A6 A6 
66 C2 6B 02 81 00 AF BC F2 0A 36 9B 8D 75 EB D6 61 B7 DB A7 D3 6C C1 34 48 75 6B E8 7E F1 45 3A 
9F DF 8E C9 32 FD D8 DD 4A 3C CE D0 C1 06 8E FE F7 0F 89 0F 0D 65 DF 2E 03 84 CB 4C 84 6A 4D 84 
57 B8 08 5B 23 40 17 44 A6 DD 34 40 B7 98 82 CB 63 CA 3A 93 6B 34 A4 70 A4 EB 59 DE EE F9 4C A2 
C4 68 EC F4 B9 B4 F4 03 69 A2 DC 60 30 8C 13 FB 99 0A E2 D4 7F A7 D6 37 D7 56 FE 85 B6 9A E1 B2 
E5 B3 B4 E4 1D 2C 2D 79 07 00 A1 68 3F 9D 03 87 39 DD 7F 88 CE FE 43 0C 86 3A D2 DB CC CC EC 3F 
01 B0 59 83 54 16 1D A6 B2 E8 30 9A 26 D1 1F 28 A2 77 B0 82 9E FE 0A 06 83 05 E7 6C 7B 38 2A F3 
CC DE 53 3C B3 F7 14 CB CB 3D 5C B3 A1 8C 2B EA 8B B1 9A E7 F6 37 20 10 08 04 99 B2 68 45 FF EE 
DD BB B9 F6 DA 6B E9 EE EE 4E 1E AB AF AF E7 B9 E7 9E A3 AC AC EC AC D7 7E E8 43 1F E2 6F 7F FB 
DB B8 E3 26 93 89 58 2C 96 36 80 CA B2 CC CD 37 DF CC A6 4D 9B 50 47 03 6B 9B 4C 26 EE BD F7 5E 
EE B8 E3 8E 19 EA 8D 20 53 52 E3 9E EB 2F 49 92 B8 EC CA 77 27 0A 8C 31 7A 4B A3 B1 40 24 26 16 
45 BA 9F B5 A6 69 BC FE F7 BF 11 EC EC 22 9B 10 97 8A 5D 22 58 65 24 58 6B 22 58 69 42 4D CE 3D 
66 48 E9 EB 8C 5A F9 4D 66 C3 94 32 B9 9A 6D 70 6A 70 2F 83 C1 0F 52 60 AE 1C 2D 36 F7 82 58 FF 
FE 8D 46 63 9A EF FB 74 EA 4C 7D 1F FB EF D9 64 31 AC 66 38 AC 5E 96 14 BF 8D 25 C5 6F 43 D3 34 
46 C2 FD 9C F6 1F E4 B4 FF 20 5D 43 47 18 89 77 4F 69 FF C9 B9 7E 82 92 A4 E1 73 77 E1 73 77 B1 
A2 72 2F B1 B8 9D 9E 81 72 7A 86 2A E8 1D 28 27 1A 3F BB 51 E6 E8 A9 21 8E 9E 1A E2 A7 CF 35 F1 
AE 8B 4B B8 66 43 19 55 85 AE E9 7F 21 02 81 40 70 1E 59 94 A2 FF E0 C1 83 5C 7D F5 D5 94 96 96 
F2 D0 43 0F B1 76 ED 5A 76 EC D8 C1 17 BF F8 45 AE BC F2 4A 0E 1F 3E 9C DC EC 36 11 A1 50 88 35 
6B D6 F0 6F FF F6 6F 69 C7 DD 6E F7 B8 81 F3 5F FE E5 5F F8 F9 CF 7F CE 57 BF FA 55 6E BA E9 26 
62 B1 18 B7 DF 7E 3B 5F F9 CA 57 28 28 28 E0 A6 9B 6E 3A 2F 7D 14 4C 8E 2E FA E3 F1 44 E4 13 00 
4D 1D 7D 1F A3 7F 01 14 83 CA BE 82 93 AC F2 97 62 97 CD 69 75 49 12 A8 FA 35 19 7E 7E CC 67 60 
A4 C6 48 B0 C6 44 B8 D8 C8 24 F3 89 19 C1 66 76 53 E6 BD 08 45 96 69 F3 EF C1 EA 18 23 F8 33 44 
CF E4 7A E8 F4 1F B8 3C E7 96 79 91 A9 76 B2 CF 9E 89 F6 CC F5 84 26 95 85 BE 9A A1 23 49 12 0E 
6B 2E D5 05 6F A1 C4 BD 96 03 ED BF A7 B1 EB 77 59 ED 3F 09 05 22 53 CA 2D 61 31 87 29 2F 3C 46 
79 E1 31 00 06 47 0A E8 1D 2C A7 7B A0 92 81 40 11 9A 36 F1 77 14 8C C8 FC FE E5 93 FC FE E5 93 
AC AA CC E5 9A 0D E5 5C BE BA 10 B3 49 58 FF 05 02 C1 FC 63 51 8A FE 07 1F 7C 90 91 91 11 B6 6E 
DD CA 9A 35 6B 00 F8 CC 67 3E 43 53 53 13 F7 DF 7F 3F 2F BE F8 22 57 5D 75 D5 59 EB 28 29 29 E1 
93 9F FC E4 59 CB 74 76 76 B2 69 D3 26 36 6E DC C8 7D F7 DD 97 3C BE 75 EB 56 CA CB CB 79 F8 E1 
87 85 E8 9F 45 52 DD 7A 14 45 21 1E 4F C4 3B 07 26 CF 82 AB 41 63 51 37 07 7C A7 09 19 A2 BC ED 
44 75 DA 4A 40 EA 24 61 32 F1 A5 19 25 C2 E5 06 46 6A 4C 04 6B 8C C4 73 CE AF 20 F0 E6 54 52 95 
BF 9E 72 DF 9B F0 39 6B 08 45 82 6C 7B ED 8E 19 CB E4 3A 18 FC 10 3E 63 F9 BC 12 8C 30 BF 84 FA 
4C B1 D0 57 33 52 49 ED 53 5C 89 D2 EC 7F 01 8B D5 9C D5 FE 13 9B D3 44 38 38 76 B3 6F F6 E4 BA 
7A C9 75 F5 B2 B4 FC 0D 64 C5 4A EF 60 69 72 43 70 38 3A B1 45 BF F1 C4 20 8D 27 06 79 F8 59 33 
EF 5E 5B C2 3F 6C 28 A7 22 DF 31 F5 46 08 04 02 C1 0C B3 E8 44 BF A2 28 6C D9 B2 85 D5 AB 57 27 
05 BF CE C6 8D 1B B9 FF FE FB 79 EA A9 A7 CE 29 FA 33 61 CB 96 2D 28 8A C2 C7 3F FE F1 B4 E3 F9 
F9 F9 BC E3 1D EF E0 F9 E7 9F A7 A7 A7 87 C2 C2 EC 93 17 05 83 41 06 06 06 C6 1D 8F C7 E3 48 92 
C4 A9 53 A7 A6 DC EE 85 4A AA E0 8F C5 62 84 C3 61 02 81 44 72 21 55 D6 37 08 A6 8B 0A D9 A4 D1 
50 98 D8 BF 71 3C CF 4F 7D 47 21 39 51 6B 9A 2B 8C 36 C1 F2 80 E2 90 12 22 BF DA 48 A8 CA 84 7A 
1E 7F 69 06 C9 84 CF 59 47 A1 6B 35 45 39 AB B1 9B F3 50 55 95 D8 B0 CA 09 FF 49 DA 06 76 11 93 
83 20 31 AD 4C AE 1A 80 AA B0 B7 69 2B AB 0A 3F 8A C5 62 99 17 1B 5D 17 13 33 19 6D 6A BE DD 33 
DD 6D 29 1E 8F 73 DC FF 22 B1 78 90 BC 02 5B D6 FB 4F 22 41 79 46 32 49 EB 98 8C 51 4A 7C AD 94 
F8 5A 01 08 84 F2 E8 1D AC A0 7B A0 02 FF 70 09 AA 9A FE 9B 0A 84 E3 6C DB 7D 82 6D BB 4F B0 AC 
C4 C1 E5 2B 72 59 57 93 83 C9 78 EE EF 5B BF BF E1 98 CA B3 FB FC 5C B1 32 97 FC 9C C4 EA E2 7C 
BB 5F 17 2A 85 85 85 58 66 60 0F 97 40 70 21 B2 E8 44 7F 6F 6F 2F FD FD FD 7C E0 03 1F 18 77 6E 
E5 CA 95 00 19 0B 66 FD 01 3D D9 C3 F8 C8 91 23 00 AC 5F BF 7E C2 CF DA B1 63 07 A7 4F 9F 9E 92 
E8 3F 7A F4 28 DB B7 6F 1F 77 DC 6C 36 13 8F C7 D9 B4 69 53 D6 75 2E 74 52 FD F9 75 E1 BF F4 E4 
09 AA 35 0D 25 1E D7 0B A5 09 F8 A3 05 FD 44 8D 71 96 D4 2D A3 B5 E5 18 07 8A 3A B9 B4 B9 34 B5 
D2 64 F9 90 17 FA EB 2D 04 AB 8D 44 8A CF AF 35 5F 8D 9B 89 0F 7B 88 0D BA 91 87 DD F4 A9 06 8E 
D2 0A B4 A6 65 72 55 14 05 83 73 08 67 89 03 4D 53 D3 12 39 65 EA 16 92 EA 0A 62 30 18 68 F4 9F 
66 5F FF AF E6 DC 1F 5C B0 70 48 DB 6B 83 4C C1 FA 23 58 ED 53 DB 7F 62 B1 4B 44 C3 EA B4 AD FD 
93 91 E3 18 20 C7 31 40 6D E9 01 14 D5 44 DF 50 29 3D 83 15 F4 0C 54 10 0C A7 67 F4 6D EA 0C D1 
D4 19 E2 17 7F 96 29 34 F4 52 6C EA C3 2E 8D DF AF 93 BA 82 23 6B 46 9A B4 E5 94 95 37 F2 FD 6D 
2B 58 A2 B6 62 93 A2 F3 C2 9D 6E 21 F0 A9 4F 7D 8A D2 D2 D2 73 17 14 08 16 20 8B 4E F4 EB 1B 77 
73 73 73 C7 9D CB CD CD C5 60 30 E0 F7 9F 3D A1 8C 24 49 EC DC B9 33 19 05 A3 BA BA 9A CB 2F BF 
9C 6F 7D EB 5B 54 56 56 66 F4 59 5E AF 17 E0 9C 9F 35 19 B5 B5 B5 6C DC B8 71 DC F1 9D 3B 77 62 
36 9B B9 E2 8A 2B A6 54 EF 42 26 55 F0 47 22 11 42 A1 10 D1 67 9F 41 1A EC 9F D0 BD 47 31 6A 1C 
2A EB 25 C7 E5 A6 B0 B8 90 E1 C0 10 6D 5A 0F 2B 8F 7B 70 85 4D 28 06 95 6E 6F 84 0E 6F 90 0E 5F 
90 B0 45 02 CC E3 3F 78 86 70 59 4A C8 77 AC C4 67 5F 8E DB 5A 9E 51 3F A3 D1 28 91 48 84 91 91 
11 82 C1 20 A1 50 88 58 2C 46 3C 1E 3F E7 66 50 5D E8 9B CD 66 2C 16 0B 76 BB 1D 97 CB 85 B3 D2 
89 DD 6E C7 6A B5 26 63 F5 0B 21 22 98 0E A9 56 FE 53 81 BF 73 2A D4 88 D5 C9 94 F7 9F 44 C3 90 
6B 5A 8E D7 5E C7 B0 DC C6 60 A4 05 59 9D E1 CD F1 80 D1 20 53 94 77 82 A2 BC 13 50 03 A1 A8 9B 
9E FE 0A 7A 06 CB E9 1B 2A 43 56 12 CF 83 B8 66 E2 B4 52 C2 69 A5 84 65 C5 36 2E AB 73 B1 A6 C2 
8E D1 20 25 7F 7F 8A A2 10 8E A9 FC F4 2F FD 14 38 5E 65 49 D9 3E AC D6 28 2D 27 AE E4 73 EF F2 
E1 73 99 C4 24 7B 06 D0 C7 5E 81 60 31 B2 E8 44 FF E0 60 22 4D BC 9E E0 66 2C 56 AB 95 91 91 B3 
27 3E FA DA D7 BE C6 89 13 27 70 B9 5C F4 F7 F7 B3 6B D7 2E 1E 7D F4 51 B6 6D DB C6 FE FD FB 29 
2F 2F 3F E7 67 D9 6C 36 80 73 7E D6 64 E4 E6 E6 4E 38 99 D8 B5 6B 17 76 BB 9D 65 CB 96 4D A9 DE 
85 4C EA 06 DE 70 38 CC C8 C8 08 A7 9D 4E 22 A4 BA F7 9C E1 58 D9 30 51 A3 42 75 45 19 AA A6 52 
5A 5E 86 BF A7 87 3D 2B BA B0 C4 24 7A BC 51 14 C3 58 07 F9 99 C3 6C B4 52 EA AD A7 AA 60 03 55 
05 EB 71 58 33 4B 2E 94 DA CF 68 34 4A 30 18 64 64 64 84 91 91 11 C2 E1 30 D1 68 34 A3 90 8F A9 
99 5C 75 D1 EF 74 3A 13 C2 DF E9 C4 66 B3 A5 25 79 12 08 A6 82 FE F7 2A CB 32 A1 C8 08 AF BF F6 
CA B4 F7 9F 98 AD 12 C3 B1 66 DE 5E FB 69 7C EE 8F 63 32 1B E9 1B 6E E1 54 FF 7E 4E F6 BD 41 EF 
70 2B 9A 36 F3 BF 5D 87 75 98 EA 92 43 54 97 1C 42 D3 0C F8 87 8B E8 19 AC A4 77 A0 82 A1 A0 0F 
80 A6 AE 08 4D 5D 11 F2 5C 56 AE 7A 53 09 FF B0 BE 8C FC 1C 33 C3 C1 28 DF FE 55 03 9D 81 08 FF 
B0 A2 01 80 F2 82 26 5A 3A 36 F0 D3 BF 9A B8 E7 93 6B 28 F5 39 CF 4B 52 35 81 40 B0 38 58 74 A2 
DF E3 49 2C BF 0E 0F 4F 9C E5 28 16 8B E1 F3 F9 CE 5A C7 58 0B FB 9D 77 DE C9 7D F7 DD C7 9D 77 
DE C9 77 BF FB 5D 7E FC E3 1F 8F FB 2C 87 23 7D 43 57 6C D4 B2 7C AE CF 12 CC 2C 6A 34 CA D0 C1 
83 F8 F7 BF C1 D0 A1 83 44 5A 8E 23 69 1A 4A 3C 71 3F F4 10 9D AA 49 E2 70 D5 20 4E A7 0B 97 DB 
81 2C C7 30 99 0C E4 E5 FB F0 D3 97 A8 EC 3C B8 0E B8 6C F9 54 15 AC A3 B2 60 3D 65 DE 35 18 0D 
D3 5B 39 B8 50 32 B9 0A 16 2F A9 7B 6D 8E 75 FD 99 98 1C 44 32 48 D3 DA 7F 82 24 A1 A9 0A 8D A7 
9F E5 AD CE 7F C6 68 34 52 E8 59 46 51 EE 72 36 2C F9 18 91 78 80 53 FE FD 9C EC DB CF 29 FF 7E 
42 D1 F1 FB A3 A6 8B 24 A9 E4 7B 3A C9 F7 74 42 D5 CB 44 62 0E 7A 06 13 21 41 7B 07 2B 18 18 81 
27 76 B5 F1 C4 AE 36 D6 54 79 E8 1D 8E D1 3D 14 E1 B2 FA 6E 0C D2 08 4B EA 96 71 BC A5 99 0D 2B 
8E F1 D7 7D EB B9 6B D3 01 EE F9 E4 1A CA F2 5D C9 E8 72 E2 37 28 10 08 B2 61 D1 89 FE FC FC 7C 
E0 8C 15 3E 15 BF DF 8F A2 28 53 F2 B1 FF D4 A7 3E C5 9D 77 DE C9 BE 7D FB 26 FC AC E2 E2 E2 B4 
F2 BA EB CF 54 3E 4B 90 39 4A 38 CC D0 E1 46 06 1B 1A 18 68 D8 4F E0 D8 31 34 3D FC 1F A0 6F 00 
D4 14 05 24 18 76 C8 0C E4 C5 69 AB 0C 13 33 29 94 97 14 24 92 02 8D EA E3 82 A2 7C FA FB FC 33 
B6 51 50 92 24 0A 3D 75 54 E6 AF A7 BA 70 03 5E 57 D5 B4 EB D4 B9 90 33 B9 0A 16 07 A9 FB 4F 54 
55 C5 69 2E A2 C0 B9 0A 59 4E 44 D6 4A FD 5B CD 64 55 4A FF 9B 37 1A 8D 98 6D 66 F2 EC D5 C9 3A 
52 DD D0 6C E6 1C EA 8A DF 4E 5D F1 DB 01 F0 07 DA 38 D9 F7 06 27 FD FB E8 1E 6C 42 19 9B F9 77 
06 B0 59 42 54 16 1E A5 B2 F0 28 9A 26 31 18 2C A0 A7 BF 92 9E C1 72 0E 9D D4 50 35 03 2B 6A AB 
F0 B9 37 E3 72 7A 92 2E 85 5A CF 5E 2E 5A 76 35 07 9A FC FC 9F 5F 36 F0 9D 1B 2F A2 2C DF 35 A7 
19 B1 05 02 C1 85 C9 A2 13 FD 85 85 85 B8 5C 2E F6 EE DD 3B EE DC EB AF BF 0E C0 DA B5 6B B3 AE 
37 1A 8D 02 67 84 3E C0 92 25 4B 00 D8 BB 77 2F 2B 56 AC 18 F7 59 1E 8F 27 E3 2C C0 82 CC 90 83 
41 86 0E 1D 64 F0 60 03 83 0D 0D 04 8E B7 8C 11 F9 29 65 73 24 22 45 26 A2 45 12 7F AD EA 63 28 
57 41 36 8D BA 0E 48 60 B7 39 70 E6 38 50 55 25 A9 EF CD 16 23 B9 5E 0F 03 FD 83 53 DE 28 68 36 
D9 A9 F0 5D 44 65 C1 7A AA F2 D7 63 B3 B8 A7 DE E1 49 58 68 99 5C 05 0B 97 54 4B BF D7 BE 84 D5 
F9 05 04 02 01 82 C1 20 11 39 42 5C 8E A7 6D 40 9F 08 7D 45 CA 6C 36 63 35 5B 71 3A 9C B8 DD 6E 
72 72 72 32 9A 34 F8 72 AA F1 E5 54 B3 B6 E6 5A E2 4A 84 D3 FD 0D 9C EC DB C7 C9 BE 37 08 84 7B 
67 BC CF 92 A4 91 E7 EA 21 CF D5 C3 F2 CA 57 89 C9 56 C2 B1 E5 D8 AC AF 21 69 01 CA 2A 56 26 5D 
0A FB 7A 7A F1 E5 FC 89 A5 D5 D7 71 AC F5 18 77 6D 3A 20 84 BF 40 20 98 12 8B 4E F4 5B 2C 16 3E 
FC E1 0F B3 79 F3 66 76 EF DE CD 65 97 5D 96 3C F7 F0 C3 0F 63 30 18 B8 E1 86 1B 92 C7 3A 3B 3B 
F1 FB FD D4 D7 D7 03 24 2D 46 63 D9 BC 79 33 40 5A 7D D7 5F 7F 3D 5F FF FA D7 D9 BC 79 33 9F FC 
E4 27 93 0F E6 86 86 06 F6 EC D9 C3 CD 37 DF 3C E9 DE 02 41 66 C4 87 87 D3 44 FE 48 5B 2B DA 38 
47 60 50 6D 12 E1 42 23 D1 22 03 91 22 23 E1 62 03 8A 23 75 A0 3C 63 D9 93 00 4D D5 C8 2F CA 4B 
58 F9 D3 C4 BD 86 B7 20 8F C1 FE A1 AC AC FD 6E 47 11 55 F9 EB A9 2C 58 4F A9 77 15 06 E9 FC FD 
F4 16 43 26 57 C1 C2 22 35 7A 8D 3E C9 D4 27 98 06 83 21 AB FD 27 FA A4 54 AF 2F DB BF 77 B3 D1 
46 75 C1 25 54 17 5C 02 C0 60 A8 83 93 7D 6F 70 AA 6F 3F 1D 03 8D C8 4A 74 1A 3D 9D 18 8B 29 8A 
C5 DC 00 12 38 EC E9 2E 85 DE 7C 2F FE BE DD 38 1D FF 40 4D 65 2D 2D ED C7 B9 6B D3 01 BE 7B D3 
C5 94 FA 9C 42 F8 0B 04 82 8C 59 74 A2 1F E0 8B 5F FC 22 4F 3E F9 24 1F FD E8 47 B9 EB AE BB A8 
AA AA E2 A9 A7 9E 62 EB D6 AD DC 7A EB AD C9 8D B8 00 57 5C 71 05 CD CD CD B4 B5 B5 51 55 55 C5 
03 0F 3C C0 93 4F 3E C9 C7 3E F6 31 EA EA EA 08 06 83 6C DF BE 9D C7 1E 7B 8C D5 AB 57 F3 E5 2F 
7F 39 79 6D 5D 5D 1D 1F F9 C8 47 D8 B6 6D 1B 37 DE 78 23 D7 5D 77 1D 7D 7D 7D DC 7D F7 DD F8 7C 
3E 6E BF FD F6 B9 E8 7E C6 CC 64 4C 70 9D E9 0E 4C B1 C1 01 86 0E 1E 4C B8 EB 1C 3C 40 E8 C4 89 
71 ED D4 8C 10 2D 30 12 29 32 10 2E 4A 84 CF 8C E7 66 18 42 53 92 D0 A4 C4 46 6B 87 D3 8A 3A 76 
99 5F 92 30 99 24 72 72 5D 0C 0F 06 26 B5 F6 4B 18 C8 77 2F A1 AA 60 03 35 45 97 E0 75 55 4C AD 
C3 D3 60 B1 64 72 15 2C 0C E6 EB FE 93 5C 47 29 B9 95 A5 AC A9 7C 3F 8A 1A A7 73 A0 31 B9 0A 30 
10 3C 3D E5 7A C7 B5 9F 84 B1 A1 78 12 97 C2 02 E7 0F B0 9B 2E C3 69 2D E4 58 5B 9C 5B 1F 7A 8D 
F5 75 79 AC A9 CE 63 59 B9 87 25 25 6E 6C 96 69 EC 83 10 08 04 0B 9E 45 29 FA 2F BD F4 52 9E 79 
E6 19 3E FF F9 CF 73 EB AD B7 A2 69 1A 65 65 65 DC 75 D7 5D DC 73 CF 3D 69 65 7D 3E 1F 1D 1D 1D 
B8 5C 89 2C 8C 57 5E 79 25 5B B6 6C E1 CB 5F FE 32 EA A8 45 D9 E9 74 F2 D9 CF 7E 96 6F 7F FB DB 
D8 ED F6 B4 EB B7 6C D9 C2 2D B7 DC C2 6F 7F FB 5B 36 6F DE 8C C5 62 61 C3 86 0D 3C F2 C8 23 2C 
5F BE 7C 76 3A 9C 25 FA 00 3B 74 F4 08 5D DB B7 A3 91 9D A5 6C 2C FA 80 9B FF E6 B7 90 7F E9 65 
69 C7 CE 45 D4 DF C7 D0 C1 83 0C 34 34 30 78 F0 00 A1 B1 39 14 24 88 79 0D 84 8B 0D 44 0B 8D 44 
8A 8D 44 F3 0D 68 53 0C 93 AF 0F BC 79 F9 39 89 81 77 12 72 BD 2E 02 83 23 69 D6 7E 63 0C 9C 7D 
36 AA D6 5D 4B 4D D1 06 72 DD 05 69 56 C7 D9 64 31 65 72 15 5C F8 5C 28 FB 4F 8C 06 33 E5 BE 8B 
29 F7 5D CC 65 CB 3F C5 48 A4 2F 31 01 F0 EF E3 B4 BF 81 98 1C 9A 5A C5 A3 C6 06 BB FD 6C 2E 85 
FD E4 DA FF 48 AE 0D 2A BC 20 2B 56 86 83 5E F6 34 FB D8 BE DF 47 20 58 80 C7 51 C6 D2 32 2F 4B 
4B DD D4 95 E6 50 5B 9C 83 C5 74 7E 73 86 08 04 82 0B 87 45 29 FA 21 21 DE 0F 1F 3E CC D0 D0 10 
81 40 20 CD BA 9F CA EE DD BB 89 C7 E3 C9 0C 7E 6F 7A D3 9B 78 F9 E5 97 09 04 02 9C 3A 75 0A B7 
DB 4D 69 69 E9 A4 03 8A C5 62 E1 D1 47 1F E5 67 3F FB 19 AD AD AD 94 95 95 CD 6B 97 9E D4 E5 F0 
EE 17 5F A4 F3 F9 ED 98 CE 92 BD 50 33 41 DF 06 23 79 0D 2A A6 E0 E4 03 B3 12 8F 13 ED E9 C1 FB 
E6 B7 9C 35 C9 4C A4 A7 87 C1 86 03 49 77 9D 70 57 67 DA F9 84 1F BE 31 61 C1 2F 32 10 2D 34 A0 
5A 66 48 78 8E 0E BC 16 8B 05 8B DD 80 AC C4 CE 24 FB D4 BB 36 FA 6F C9 08 8E 1C 1B A1 40 98 92 
66 28 3E A6 11 39 1E 81 AA 22 4A DF B9 0E 8B C9 39 33 6D 9A 06 13 7D BF 33 21 7C 84 D0 17 CC 24 
17 F2 FE 13 97 2D 9F 95 E5 57 B1 B2 FC 2A 34 4D A5 6B F0 28 27 FD FB 38 D5 B7 8F BE 40 6B C6 6D 
9F 8A 4B A1 C9 18 C5 EB EE C4 EB 3E F3 8C D4 34 03 C3 21 2F 7B 9A BC 6C 7F 23 9F 91 48 3E 6E 7B 
25 B5 45 85 D4 95 E6 B0 B4 D4 4D 6D 71 66 D9 81 05 02 C1 C2 63 D1 8A 7E 1D 8F C7 93 0C AD 39 11 
92 24 4D 98 B2 3B 27 27 27 99 C1 37 13 24 49 A2 B6 B6 76 4A 6D 9C 2D D2 B2 62 8E BE 24 49 E2 B2 
2B DF 9D 28 90 9E F1 1E 09 89 03 DE 93 1C CE 6F 25 AF B6 8C B7 76 2D 1B 57 9F 6E 71 7E FD A5 BF 
A3 28 0A B2 2C 27 07 61 80 48 57 17 83 07 0F 30 D8 D0 C0 E0 C1 06 22 3D 3D C9 EB 55 9B 44 B8 D2 
44 A4 48 22 5A 64 9A C0 0F 7F 66 D1 07 5E 8F D7 86 AA 6F FE 95 00 F5 4C 9F D1 46 BF 04 4D C2 9D 
67 27 1C 88 A0 29 0A 9E B6 38 11 75 FA D6 F4 F3 85 10 EA 82 F9 C8 42 DA 7F 22 49 06 4A F2 56 52 
92 B7 92 37 D7 FD 23 E1 D8 10 A7 FC FB 39 D1 FB 06 A7 FC FB 89 C4 03 93 5D 38 23 2E 85 89 A2 2A 
1E 67 1F 1E 67 1F 15 34 25 8F 87 A3 39 EC 6D F1 B2 73 7F 01 C1 88 8F 1C 7B 15 95 05 E5 2C 2D 75 
B3 B4 CC 4D 75 A1 4B 4C 04 04 82 45 C0 A2 17 FD 82 74 52 13 3B 29 A3 C2 57 53 47 DF B5 33 B9 71 
00 64 83 CA 01 6F C2 A7 B5 D9 DD CD 45 3D 65 E4 C4 CE AC 62 48 12 A8 29 79 74 54 55 65 B8 AD 95 
D0 D1 A3 04 0E 37 32 74 E8 20 B1 FE FE 44 DD BA 1F FE C5 E6 EC FD F0 67 02 49 42 93 34 CC 66 13 
26 AB 94 B0 F2 27 4E 90 36 D3 49 35 FD 4B 60 75 9A E8 5A A6 51 F1 B2 0C E3 A3 C0 0A 04 82 0C 58 
88 FB 4F EC 16 0F 4B 4B AE A0 AE F8 72 54 55 A1 7B B0 99 F6 9E D7 39 DD BF 9F FE 60 1B 1A 09 F7 
D0 E9 B8 14 66 DC 16 6B 00 BB 35 40 89 B7 3D 79 4C 56 AC BC D1 E6 E3 CF 87 BC 04 C3 05 B8 6C 95 
54 E4 57 B3 B4 D4 4B 5D A9 9B AA 42 27 46 C3 CC 7F 6F BA 5B EC 70 28 C4 D6 97 1E E3 DD 17 5D 4B 
55 61 09 C0 84 41 32 04 02 C1 CC 21 44 BF 00 48 77 EB 51 14 85 78 3C 11 27 1B 40 89 C5 26 BC E6 
48 61 37 11 43 8C 25 75 CB 68 6D 39 C6 3E 5F 3B 6F 6B AF 4E EA E3 D4 49 82 A6 AA 84 9A 8E 72 F0 
8E 2F 83 04 51 AF 21 11 49 E7 62 2B 91 A2 E9 F9 E1 CF 04 89 81 17 5C 1E 13 AA A6 9C 99 D9 4C 5C 
12 BD 93 0E B7 89 68 50 A6 7D 83 05 DF 0B 89 A8 1E D9 5A 27 05 82 C5 CC E2 D8 7F 22 E1 73 D5 E0 
34 95 50 E5 79 27 FE 81 6E 5A BA F6 B3 BF B7 99 22 5F 13 56 6B E6 2E 85 C1 40 78 CA E1 82 53 31 
19 A3 F8 DC 1D F8 DC 1D C9 63 9A 66 60 5F 7B 1E 7F 6D F4 31 32 3A 11 28 F7 D5 52 57 52 44 5D 69 
0E 95 85 2E A6 3A 0F 48 1D 63 02 A1 18 3F FA E3 CF 29 F4 FE 85 5F FE A5 97 7F 7A D7 57 28 F1 3A 
92 AB CB 62 65 52 20 38 3F 08 D1 2F 48 43 55 55 14 45 21 16 8B 25 2D FD AA AC 2F 37 9F 11 BC B2 
51 E3 40 51 27 39 2E 77 32 89 CC 71 AD 87 FA 8E 22 72 22 A3 59 64 47 07 F3 90 35 CE 60 B5 C6 50 
AE 91 48 91 79 66 FD F0 A7 81 DD EC C5 DA A5 62 3A DA 43 FF 25 66 8C 0E 23 06 8B 8A 2C A7 4C 72 
C6 2E 6F E8 FF 96 CE 58 FE CD 76 89 9E 95 66 9C AF C9 58 85 E0 17 08 B2 66 31 EC 3F 49 4D 44 26 
69 66 BC E6 5A AA 9D 5D 44 B4 EC 5C 0A 43 81 C8 8C 25 07 1C 4B C2 3D C8 8F C7 E9 07 9A 80 BF 03 
D0 70 32 87 BF 1D F5 12 0A 17 E2 B0 54 52 E2 AB 61 69 49 25 75 A5 6E 2A F2 9D 9C EB 6B 4E 35 28 
05 42 31 EE D9 B2 8F 25 15 2F 03 50 90 77 84 7F FF CD 5F F8 C6 F5 6F 4F 86 20 15 D1 C1 04 82 F3 
83 10 FD 82 24 A9 3E FD 8A A2 24 45 BF 12 8F EB 05 92 A2 F7 68 59 3F 51 83 4C 75 45 59 32 89 8C 
BF A7 87 7D C5 A7 A9 E9 C9 C5 EF 0A D1 EF 0A D3 E7 0A 13 31 CB 50 2F 01 E6 39 EB 9B DD E2 26 DF 
5D 4B 81 BB 0E AF A3 06 87 A9 98 48 50 A1 A7 6F 2F A7 F2 9E 45 35 8F 60 77 8E 11 FC 19 62 71 40 
34 0C BD EF F4 52 A5 5C 94 3C 2E C4 BF 40 90 3D 0B 55 EC A5 AE 3E 48 92 84 26 29 C4 6C 07 B3 76 
29 B4 39 4D 84 83 63 37 FB 9E 5F 1C B6 00 0E 5B 00 68 07 12 89 2D 1B 4F 5B D8 73 2C 9F 91 70 3E 
76 73 05 C5 79 B5 2C 29 A9 65 59 A9 97 32 9F 23 39 11 48 9D EC 0C 07 A3 DC FD EB 83 18 CC 2F 63 
36 86 59 52 B7 8C E3 2D CD 14 FB 5E E1 AE 4D 6E FE FD 86 7A CA F2 13 91 F2 84 F0 17 08 66 1E 21 
FA 05 E3 D0 45 BF FE B0 1E EB DE A3 18 35 0E 95 F5 E2 74 A6 27 91 C9 CB F7 D1 46 1F 6D F9 83 B3 
36 18 4D 84 D9 68 25 DF 5D 4B A1 A7 8E 02 4F 1D 85 EE 3A 72 EC 85 69 FB 15 42 A1 10 11 86 A0 BA 
82 7E 4F 1C A3 09 0C 66 85 71 79 BD C6 59 F6 C7 A0 69 60 90 30 5B 25 46 2A A3 28 AE EA E4 F7 26 
06 2C 81 40 00 E9 E1 44 F5 CD C5 43 EA 41 54 2D 8A C7 63 CB DA A5 30 12 4C AC BE 6A 73 F8 A0 35 
9B 62 29 EE 41 07 50 81 A6 4E 03 AF B6 78 09 46 F2 B1 99 CA C9 77 57 53 5B B8 94 A5 65 05 38 CC 
F0 EF BF 39 44 BB 7F 98 F7 BE B9 01 97 CB 93 5C 25 D6 68 A2 B9 63 03 DF DC 7C 90 7F BF A1 9E F2 
82 9C B3 46 79 13 08 04 53 43 88 7E 41 1A A9 7E 97 49 0B 8D 9C 1E 4D E2 58 D9 30 51 A3 42 D9 24 
49 64 CE D7 D2 F3 44 18 24 23 79 AE 0A 0A 3D 75 C9 57 9E AB 02 89 89 37 08 8C 1D 40 FA E3 0D A8 
44 41 81 11 FF 99 78 FA E9 56 FA C9 07 1D 49 4A 7C 8E 06 A0 A9 F4 44 F7 52 CA 92 A9 76 47 20 10 
2C 30 52 9F 39 7A A6 61 C9 A8 D1 2B EF C5 64 36 4C C9 A5 D0 62 97 88 85 A1 BE E0 13 98 6D 10 8C 
77 31 1C 39 8D 3F 70 82 B8 32 C5 5C 01 33 40 6A F4 20 38 82 0A 34 F7 C2 81 93 39 0C 87 7C 98 AC 
F9 BC 7D 8D 01 23 23 94 55 AC 4C AE 12 F7 F5 F4 B2 61 F9 31 FE BA 7F 3D DF DC 7C 90 7B 3E B9 86 
B2 7C 57 32 C7 89 10 FE 02 C1 CC 20 44 BF 60 42 52 45 AF 12 4F 0C 48 12 12 B2 49 E3 70 D5 20 76 
C7 D9 92 C8 0C 9E B7 A5 67 B7 A3 88 42 F7 A8 05 DF 53 47 BE BB 16 93 61 F2 3C 02 63 D1 37 0C EA 
96 37 87 A9 10 A7 54 4D 2C 16 45 96 E5 71 B1 C1 27 72 D1 19 BB 4C AF C7 04 B7 58 2C E4 98 CB C5 
B2 B4 40 20 18 47 EA 73 A7 23 F0 32 B2 12 C6 99 C3 94 5D 0A 63 11 09 7F E4 08 97 95 FF 6F 9C 4E 
27 16 8B 05 83 C1 C0 48 B4 17 7F A0 1D 7F A0 15 7F A0 8D EE 81 16 C2 F1 81 F3 D0 A3 CC D1 DD 83 
8A 7D ED 20 81 C3 9E BE 4A EC CD F7 A2 F5 ED 65 55 DD 7B 68 3C D6 CF FF F9 65 03 DF B9 F1 22 CA 
F2 5D C9 88 3E E2 99 2A 10 4C 1F 21 FA 05 E7 44 53 CE 84 EC 3C 5E 1D 22 66 52 A8 C8 22 89 CC 54 
B1 5B DC 49 71 AF 0B 7D 9B 39 67 CA F5 A5 46 85 D0 97 D8 BD F6 25 68 A1 5C 06 46 06 18 19 19 21 
12 89 10 8F C7 51 47 DD 9B 26 F3 CB D7 C5 BE D1 64 C2 6A B5 92 93 93 43 9E 23 0F AF D3 8B C9 64 
4A 0B 41 28 06 2B 81 40 00 89 E7 86 A2 C5 69 1D 78 11 93 59 C2 60 96 A7 EC 52 68 B2 48 74 8D BC 
41 30 D6 87 C3 E1 48 D6 EF B6 17 E1 B6 17 51 53 F8 E6 E4 25 51 79 84 BE E1 36 FC 81 36 FA 86 5B 
E9 1A 6C 25 10 39 9D 08 59 36 8B E8 E1 49 8B 27 59 25 CE CF D9 49 4D E5 46 8E 9F 38 CE 5D 9B 0E 
08 E1 2F 10 CC 30 42 F4 0B CE 89 EE D3 AF 18 E1 68 ED 08 76 FB F4 93 C8 8C 65 32 3F FC F3 81 EE 
57 6B 36 9B B1 58 2C 38 1C 0E 64 59 C6 60 30 60 B5 5A 33 CA 04 9A 6A E5 B7 5A AD 38 1C 0E EC 76 
3B 56 AB 75 9C E8 17 08 04 8B 9B D4 CD AC C7 7B 77 11 57 42 48 9A 94 E6 52 98 5E 56 22 75 23 EF 
84 CF 11 49 42 D3 54 9A BA 9F 27 DF F3 CF 69 46 8A B1 E5 AD 26 17 65 DE 7A CA BC F5 C9 63 AA 26 
D3 1F 38 31 3A 11 68 E7 74 7F 33 43 A1 13 A8 5A 64 26 BA 3C 71 7B 25 B0 DB 27 5F 25 D6 FA F7 90 
E3 7C 1F 55 E5 35 B4 9F 6A 4D 5A FC F5 A8 3E 13 F5 4D 20 10 64 8E 10 FD 82 73 22 47 13 F1 E7 DB 
56 CA C4 CC 2A 25 D3 4C 22 23 61 20 D7 59 4E A1 A7 8E A2 DC A5 14 E5 2E 3D AB 1F FE 4C 92 BA C4 
6E 32 99 B0 DB ED C4 47 A3 13 59 2C 96 64 52 B2 4C 93 01 E9 93 07 9B CD 86 D3 E9 C4 6E B7 63 32 
99 92 C2 5F 20 10 2C 6E 52 05 BF A6 69 B8 2C C5 E4 3B 56 22 CB F1 64 3E 14 DD B5 30 D5 E0 A0 5F 
37 76 03 B0 FE 7C 31 9B CD 98 AD 66 F2 EC D5 C9 EB B2 71 2D 34 48 26 F2 DD B5 E4 BB 6B 59 5E 76 
E6 F8 70 B8 1B 7F A0 9D BE E1 E3 9C EC 6B 66 60 A4 1D 59 9D 7E E6 41 DD CA 9F 7F 8E 55 E2 1C EB 
1F 18 89 7C 92 B2 92 4A 4E 77 9E 48 5A FC 85 F0 17 08 A6 8F 10 FD 82 49 49 FA B5 2B 0A 8A 09 9A 
57 C4 A6 94 44 C6 11 90 30 77 CA D8 E2 B9 54 BD F7 46 4A F3 57 E0 76 E5 62 36 9B 31 1A 8D 73 F2 
00 D7 7D F0 65 59 C6 ED 76 63 B1 58 92 B9 09 54 55 4D 66 8D 3C 1B BA A5 DF 60 30 60 B1 58 B0 D9 
6C 58 AD 56 AC 56 6B B2 5F 62 70 12 08 04 A9 71 EA 7D 8E 3A 56 E7 17 30 3C 3C 4C 20 10 20 18 0F 
12 0E 87 09 87 C3 44 A3 51 E4 68 94 78 3C 9E DC 7F 64 32 99 30 5A 2C 58 AC 56 EC 76 3B 76 BB 1D 
A7 D9 49 8E 3D 07 8F C7 43 4E 4E CE B8 E0 0B D3 21 D5 3D E8 92 BA C4 B1 A8 3C 82 7F B8 8D 9E A1 
E3 9C E8 6D C6 3F D2 4E 4C EE 02 32 74 0F 1A B5 F2 DB 6C E7 5E 25 D6 06 F7 D2 3B F2 5E 2C D6 7C 
BC DE 42 7A 7A 3A F8 F9 CE E3 DC 79 DD 6A F1 4C 15 08 A6 89 10 FD 82 73 A2 C4 E3 B4 2F D7 88 59 
34 0A B2 48 22 13 0E 44 28 6C 85 8B FE 2C 71 3A 18 43 AB 72 90 6B AB CE 6A E3 ED F9 C0 60 30 A0 
69 5A D2 D2 6F 34 1A 93 13 80 73 B9 F5 8C 25 75 D5 20 69 7D 33 9B 93 96 39 81 40 20 00 D2 82 03 
E8 56 7B 8B C5 82 A2 28 C9 67 88 D5 6A 4D 5A FF F5 F2 FA 33 C5 62 B1 60 B1 58 92 86 05 93 C9 94 
56 F7 F9 CC 0B 62 35 B9 28 F5 D6 53 EA AD 67 6D 4D E2 98 EE 1E D4 33 DC 46 6B 57 13 BD C3 AD 44 
E2 A7 91 A4 E8 B8 EB 75 2B 7F 5E 46 AB C4 41 F2 EC CF D1 D2 75 2D 7E 7F 37 4E AB 89 0F AE 2F 40 
96 E5 34 D1 2F C4 BF 40 90 3D 42 F4 0B 26 24 75 00 91 0D 2A C7 D7 68 58 2C D9 25 91 B1 3A 4D 74 
57 C5 09 3A 35 18 99 D5 E6 4F 4A EA 46 5E DD 05 C7 68 34 26 AD FB D9 0E 9E A9 9B 75 8D 46 63 F2 
25 7C FA 05 02 C1 58 52 A3 7D D9 6C 36 20 B1 EA 98 EA E6 A3 BB FA E8 96 7E FD 99 A2 1B 16 2C 16 
0B 66 B3 19 AB D5 8A C5 62 99 B3 55 C5 54 F7 A0 95 65 57 26 F3 BB F4 0F 9F E6 54 5F 13 47 3B 8E 
D2 D6 77 02 97 A3 0F 9B 2D 94 98 B4 64 B4 4A 6C 45 D5 F6 32 32 BC 14 B3 21 87 2F 5C 55 48 B1 C7 
84 2C CB 69 CF 56 81 40 90 3D 42 F4 0B 26 24 55 FC 9E 58 2A 13 B7 18 C9 F3 98 B2 4E 22 13 0D CA 
1C BF 48 21 6F 87 36 AE DE B9 24 55 94 EB 96 FF D4 76 65 EA D3 9F FA EF D4 FA C4 A0 24 10 08 52 
49 F5 C9 B7 D9 6C 48 92 84 D9 6C 1E E7 CF 3F 36 90 80 2E 74 C7 1A 15 74 AB BF D9 6C 4E C4 FE 9F 
07 46 06 4D D3 B0 9B BD 94 E4 D4 E3 28 AE 20 9F 7E 5E 6C 7F 99 9A B2 3D 78 B2 58 25 0E 05 22 2C 
2B 7F 95 8B 3C EF C6 6B 57 D3 F6 5A CD 87 F1 43 20 B8 50 11 A2 5F 30 8E B4 04 5D 66 89 F6 37 19 
30 4F 31 89 8C D9 2E D1 B5 CC 80 F3 65 09 F3 3C 79 60 4B 92 94 66 45 3B 5B 4C FE 6C EA 4C 7D 1F 
FB 6F 81 40 B0 78 D1 8D 01 BA 4B 8F EE AB 9F BA 87 28 F5 B9 9B BA A7 48 77 13 4C 35 54 A4 5A FF 
F5 BD 51 F3 C1 D8 90 DA 7E 59 96 31 1B 22 D4 96 BD 8E 29 CB 55 62 9B D3 44 19 4D 38 A5 37 21 CB 
9E 71 82 5F 7F 7E 0B 04 82 EC 10 A2 5F 30 8E D4 C1 67 70 8D 99 B8 55 C2 E9 54 A7 9E 44 26 0C 7D 
97 98 29 3E 36 3E DB EF 5C 31 D1 80 31 13 83 88 18 88 04 02 41 2A A9 06 01 DD 15 67 22 97 C2 54 
41 9B FA 7C 1C 9B 0C 70 AC 4B A1 3E 99 98 0F 2E 85 63 3F 7B 48 3D 88 46 0C 97 C7 96 F5 2A 71 24 
28 33 A0 BD 4E 89 54 9B 36 A1 99 EB 3E 0A 04 17 32 42 F4 0B D2 48 B5 D4 28 06 15 FF 5A 13 26 13 
18 CC CA D4 93 C8 58 25 86 56 98 F0 75 A8 19 87 C3 9C 4D C4 00 22 10 08 CE 37 99 BA 14 9E 2B 0B 
78 EA B1 F9 E4 52 98 DA 16 A3 D1 88 64 D4 F0 AB AF 61 9A E2 2A B1 C5 2E 31 12 3E 46 54 1D C4 60 
C8 17 C1 11 04 82 19 60 D1 8B FE A6 A6 26 9A 9A 9A A8 AF AF A7 BA BA 3A AB 6B 03 81 00 AF BC F2 
0A 36 9B 8D 75 EB D6 61 B7 DB 67 A4 EC 5C 92 1A 53 7A 68 B5 09 C5 26 81 02 23 7D 93 3D 6C CF 36 
D0 24 CE 69 92 04 12 F4 5F 62 A3 6C 02 CB 96 40 20 10 2C 64 16 BA 4B E1 D8 36 18 8D 46 BA 43 AF 
A2 A8 11 9C 6E A6 BC 4A 1C 0D 43 47 E8 EF 54 18 96 09 0B BF 40 30 03 2C 5A D1 BF 7B F7 6E AE BD 
F6 5A BA BB BB 93 C7 EA EB EB 79 EE B9 E7 28 2B 2B 3B CB 95 20 CB 32 37 DF 7C 33 9B 36 6D 4A FA 
5E 9A 4C 26 EE BD F7 5E EE B8 E3 8E 29 97 9D 6B F4 41 49 1F 88 AC BE A5 58 83 FD C4 62 D1 B4 8D 
54 99 C6 B0 4F DD B8 66 B1 58 B0 79 57 26 3F 47 20 10 08 16 13 0B DD A5 50 1F 3F 24 49 42 D1 E2 
9C 18 FE 2B 26 B3 84 C1 2C 4F 79 95 D8 6C 95 E8 0D 1F 20 2C F7 93 23 E5 A4 AD 6E 08 04 82 EC 59 
94 A2 FF E0 C1 83 5C 7D F5 D5 94 96 96 F2 D0 43 0F B1 76 ED 5A 76 EC D8 C1 17 BF F8 45 AE BC F2 
4A 0E 1F 3E 8C D1 38 3E 3D BA CE BF FC CB BF F0 F3 9F FF 9C AF 7E F5 AB DC 74 D3 4D C4 62 31 6E 
BF FD 76 BE F2 95 AF 50 50 50 C0 4D 37 DD 34 A5 B2 73 CD D8 07 A9 DB 5C 45 28 62 A5 BF BF 9F E0 
F0 30 E1 70 38 19 69 02 26 17 EF A9 B1 EB 6D 36 1B 39 39 39 B8 7D 3E 72 5D 05 22 CE B2 40 20 58 
F4 2C F4 67 5F 7B FF 4B C4 95 85 3E CD 13 00 00 1B 84 49 44 41 54 10 92 26 31 E2 4F 1F 4B CF 8C 
1B 63 57 8F 27 D8 9C 2B 49 68 9A CA B1 9E 17 28 C8 FD 67 B1 91 57 20 98 26 8B 52 F4 3F F8 E0 83 
8C 8C 8C B0 75 EB 56 D6 AC 59 03 C0 67 3E F3 19 9A 9A 9A B8 FF FE FB 79 F1 C5 17 B9 EA AA AB 26 
BC B6 B3 B3 93 4D 9B 36 B1 71 E3 46 EE BB EF BE E4 F1 AD 5B B7 52 5E 5E CE C3 0F 3F 9C 14 F2 D9 
94 CD 96 60 30 C8 C0 C0 C0 B8 E3 BA 20 9F 2A 63 93 4D D9 ED 76 1C 0E 07 AA AA 26 C3 CB 65 6A E9 
D7 93 CD 38 9D 4E 6C 36 5B 32 A6 F4 7C F0 3F 15 08 04 02 C1 CC 30 76 13 B2 CB 52 4C BE 63 25 B1 
58 14 59 96 D3 F2 10 E8 1B 98 15 4D 22 8A 03 0B 61 4C 92 9A F4 D9 4F 8D 4A 64 36 9B 31 DB CD 78 
1D 35 69 6E A1 62 FC 10 08 A6 C6 A2 13 FD 8A A2 B0 65 CB 16 56 AF 5E 9D 14 FC 3A 1B 37 6E E4 FE 
FB EF E7 A9 A7 9E 9A 54 F4 6F D9 B2 05 45 51 F8 F8 C7 3F 9E 76 3C 3F 3F 9F 77 BC E3 1D 3C FF FC 
F3 F4 F4 F4 50 58 58 98 55 D9 6C 39 7A F4 28 DB B7 6F 1F 77 DC 6E B7 33 30 30 C0 7F FC C7 7F 64 
5D A7 FE 30 96 65 99 68 34 4A 24 12 21 1C 0E 13 89 44 B2 76 EF D1 85 BD FE 00 B7 A6 A4 90 D7 63 
4B 4F 75 63 96 AA AA 0B 7E 43 97 E8 E3 C2 61 31 F4 53 F4 71 61 30 D5 3E 8E 0D D5 A9 8F 1F 91 48 
84 68 34 4A 34 1A 25 16 8B 11 8F C7 93 13 00 3D 72 51 AA 2B E8 D8 EC C3 36 9B 0D BB DD CE 3E EB 
5E 2C 96 FD 58 2C 96 69 45 29 D2 34 8D B5 6B D7 F2 9E F7 BC 27 EB 6B 05 82 85 C0 A2 13 FD BD BD 
BD F4 F7 F7 F3 81 0F 7C 60 DC B9 95 2B 13 3E E7 A7 4E 9D 9A F4 FA 23 47 8E 00 B0 7E FD FA 09 AF 
DF B1 63 07 A7 4F 9F A6 B0 B0 30 AB B2 D9 52 5B 5B CB C6 8D 1B D3 8E 0D 0E 0E B2 73 E7 4E AA AA 
AA F0 7A BD 59 D7 A9 3F 84 E3 F1 38 B1 58 2C 29 F8 A3 D1 84 4F 7F 6A 88 B9 73 91 1A C9 41 CF 1E 
A9 3F C0 F5 8C 92 53 11 FD E1 70 98 23 47 8E 50 5E 5E 3E A5 3E 5E 08 88 3E 2E 1C 16 43 3F 45 1F 
17 06 D3 E9 A3 2E FA 75 AB BE 6E 30 D2 C7 10 DD 70 A4 8F 2D BA F0 D7 99 48 F0 EB 63 86 3E 6E E8 
63 C7 74 56 8B 4F 9F 3E CD AB AF BE 2A 44 BF 60 D1 B2 E8 44 BF BE 71 37 37 37 77 DC B9 DC DC 5C 
0C 06 03 7E BF 7F 4A D7 EB 0F 4A FD FA 6C CA 66 4B 6E 6E EE B8 7A F5 CF BB E8 A2 8B A8 AF AF CF 
BA CE 54 4B 4D 2C 16 4B 0A 7E FD 21 9D A9 95 5F 27 55 F4 EB 0F F1 D4 2C 92 FA F9 6C E8 EE EE E6 
C8 91 23 53 EE E3 85 80 E8 E3 C2 61 31 F4 53 F4 71 61 30 9D 3E EA 63 43 AA C1 28 18 0C 12 0A 85 
D2 AC FD A9 A2 5F 1F 53 74 57 50 DD 18 34 56 F4 DB ED 76 9C 4E 27 76 BB 1D 9B CD 86 C9 64 4A E6 
3B C8 96 9D 3B 77 D2 D3 D3 93 F5 75 02 C1 42 61 D1 89 FE C1 C1 41 00 AC 56 EB 84 E7 AD 56 2B 23 
23 23 53 BA DE 66 B3 01 24 AF CF A6 EC 7C 20 35 E1 8B BE 8C 6A B1 58 92 29 E2 B3 0D B3 99 6A ED 
D7 1F D4 FA 5E 81 A9 08 7E 81 40 20 10 CC 5F 52 7D F2 6D 36 1B 92 24 61 36 9B B1 D9 6C 28 8A 92 
E6 DF AF 67 23 D6 C7 1C B3 D9 9C 1C 1F F4 97 7E AD 7E 4E 44 EE 11 08 A6 C7 A2 13 FD 1E 8F 07 80 
E1 E1 E1 09 CF C7 62 31 7C 3E 5F 46 D7 3B 1C 8E 71 D7 02 C9 EB B3 29 3B 5F 48 4D F4 A2 8B F5 B1 
16 FE 4C DD 7B 74 C6 A6 8F 17 0F 6E 81 40 20 58 58 A4 FA E6 5B 2C 96 A4 05 5F 17 FC A9 7B C2 C6 
06 84 D0 AF 4B CD 58 9C 1A 50 C2 6C 36 8B 20 10 02 C1 0C B0 E8 44 7F 7E 7E 3E 70 C6 0A 9F 8A DF 
EF 47 51 94 B3 FA D8 A7 5E 5F 5C 5C 9C 76 4E 77 AF D1 AF CF A6 EC 7C 21 35 9C A6 C1 60 48 3E 98 
67 22 89 4C AA 65 5F 3C B8 05 02 81 60 61 90 3A 6E A4 0A F7 D4 7D 60 FA BB FE EF B1 A2 3F D5 E0 
94 FA 6F 5D EC A7 8A 7E 31 7E 08 04 53 63 D1 89 FE C2 C2 42 5C 2E 17 7B F7 EE 1D 77 EE F5 D7 5F 
07 60 ED DA B5 93 5E BF 64 C9 12 00 F6 EE DD CB 8A 15 2B C6 5D EF F1 78 92 99 7D B3 29 3B 9F 18 
6B A5 3F 1F F5 0A 04 02 81 60 61 31 56 B4 8F 75 09 4D 35 22 A5 1E 1F 6B 6C 4A 3D 3E 76 12 20 10 
08 A6 CE A2 73 AA B6 58 2C 7C F8 C3 1F E6 F8 F1 E3 EC DE BD 3B ED DC C3 0F 3F 8C C1 60 E0 86 1B 
6E 48 1E EB EC EC E4 E0 C1 83 C9 FF 5F 7F FD F5 00 6C DE BC 39 ED A1 D5 D0 D0 C0 9E 3D 7B F8 D8 
C7 3E 96 F4 E1 CF A6 EC 4C E0 76 BB 79 CF 7B DE 43 69 69 E9 8C D5 99 FA D0 9D EE 6B 26 38 1F 7D 
9C 6F 88 3E 2E 1C 16 43 3F 45 1F 17 06 D3 ED E3 58 6B 7F EA 1E 2E FD A5 6F D2 D5 37 EA EA AF D4 
40 0F 63 AF 49 75 FB 49 FD 9C A9 B0 7C F9 72 11 B9 47 B0 A8 91 EE BB EF BE 75 B2 2C BF F6 C1 0F 
7E 70 C1 46 25 18 CB 9E 3D 7B B8 F2 CA 2B C9 CD CD E5 AE BB EE A2 AA AA 8A A7 9E 7A 8A 9F FD EC 
67 DC 7A EB AD FC F0 87 3F 4C 96 5D BA 74 29 CD CD CD B4 B5 B5 51 55 55 05 C0 B5 D7 5E CB B6 6D 
DB B8 E1 86 1B B8 EE BA EB E8 EB EB E3 EE BB EF 26 1A 8D B2 6B D7 2E 96 2F 5F 9E BC 3E 9B B2 02 
81 40 20 10 2C 04 A6 E3 12 3A 16 61 E1 17 08 A6 C7 D6 AD 5B 69 69 69 69 5B 74 EE 3D 00 97 5E 7A 
29 CF 3C F3 0C 9F FF FC E7 B9 F5 D6 5B D1 34 8D B2 B2 32 EE BA EB 2E EE B9 E7 9E B4 B2 3E 9F 8F 
8E 8E 0E 5C 2E 57 F2 D8 96 2D 5B B8 E5 96 5B F8 ED 6F 7F CB E6 CD 9B B1 58 2C 6C D8 B0 81 47 1E 
79 64 9C 88 CF A6 AC 40 20 10 08 04 0B 01 21 D4 05 82 F9 C7 A2 B4 F4 A7 32 34 34 44 20 10 A0 BC 
BC 7C C2 F3 7A B2 2A 8B C5 32 E1 B9 D6 D6 56 CA CA CA CE E9 A6 93 4D 59 81 40 20 10 08 04 02 81 
60 26 58 D4 96 FE 54 3C 1E 4F 32 B4 E6 44 48 92 34 A1 E0 D7 CF D5 D6 D6 66 F4 39 D9 94 15 08 04 
02 81 40 20 10 08 66 92 45 B7 91 57 20 10 08 04 02 81 40 20 58 6C 08 D1 2F 10 08 04 02 81 40 20 
10 2C 70 84 E8 17 08 04 02 81 40 20 10 08 16 38 42 F4 0B 04 02 81 40 20 10 08 04 0B 1C 21 FA 05 
02 81 40 20 10 08 04 82 05 8E 10 FD 02 81 40 20 10 08 04 02 C1 02 47 88 7E 81 40 20 10 08 04 02 
81 60 81 23 44 BF 40 20 10 08 04 02 81 40 B0 C0 11 A2 5F 20 10 08 04 02 81 40 20 58 E0 2C FA 8C 
BC 82 73 13 0E 87 79 E5 95 57 E8 EB EB A3 A2 A2 82 8B 2F BE 18 AB D5 3A 61 D9 E6 E6 66 1A 1B 1B 
B1 58 2C AC 5E BD 9A 8A 8A 8A 59 6E ED F4 E8 E8 E8 E0 C8 91 23 0C 0D 0D B1 6C D9 32 56 AF 5E 9D 
76 7E 60 60 80 AE AE AE 71 D7 D9 6C 36 6A 6A 6A 66 AB 99 19 A3 69 1A AF BC F2 0A 05 05 05 93 66 
84 CE E6 FE 66 5A E7 6C 10 8D 46 79 E5 95 57 E8 ED ED A5 A6 A6 86 FA FA 7A CC 66 F3 59 CB 1F 3D 
7A 94 E3 C7 8F 93 93 93 C3 86 0D 1B C6 65 E3 CE B6 CE F3 CD B1 63 C7 90 65 79 DC F1 F2 F2 72 72 
72 72 D2 8E 65 D3 F6 B9 FE 9D 76 75 75 71 EC D8 31 2E BD F4 D2 B3 7E BF 4D 4D 4D 34 35 35 51 5F 
5F 4F 75 75 F5 39 EB 3D 76 EC 18 03 03 03 2C 5F BE 3C ED DE B6 B5 B5 11 0E 87 27 BD AE B4 B4 F4 
AC 99 D9 B3 21 DB BF A1 4C FA A8 69 1A AD AD AD 1C 3A 74 08 B7 DB CD BA 75 EB C6 DD 7F 9D D9 BE 
B7 93 7D E7 A9 64 FA CC 38 72 E4 08 CD CD CD 58 AD 56 56 AE 5C 49 79 79 F9 A4 65 33 F9 3D 0B 04 
82 31 DC 77 DF 7D EB BE F7 BD EF 69 0D 0D 0D 9A 40 30 96 6F 7F FB DB 9A CB E5 D2 80 E4 AB A6 A6 
46 DB B3 67 4F 5A B9 43 87 0E 69 6F 79 CB 5B D2 CA 19 0C 06 ED 73 9F FB 9C A6 AA EA 1C B5 3E 73 
5A 5B 5B B5 0F 7E F0 83 69 ED 07 B4 6F 7D EB 5B 69 E5 DE FE F6 B7 8F 2B 03 68 26 93 69 DE F5 F3 
D8 B1 63 DA 3B DF F9 4E 0D D0 AE BD F6 DA 09 CB 64 7A 7F B3 A9 73 36 F8 CE 77 BE A3 79 3C 9E B4 
76 2F 5D BA 54 DB BB 77 EF 84 E5 1F 7A E8 21 2D 3F 3F 3F AD BC D3 E9 D4 46 46 46 A6 5C E7 F9 E6 
85 17 5E 98 F0 6F 0D D0 EE B9 E7 9E B4 B2 99 B6 7D AE 7F A7 8A A2 68 FF F5 5F FF 95 FC 9B DB BF 
7F FF 84 E5 5E 7A E9 25 AD A8 A8 28 AD 9D F5 F5 F5 DA A9 53 A7 26 AD 7B E7 CE 9D C9 B2 9F FF FC 
E7 D3 CE 39 9D CE 49 BF 4B 40 BB ED B6 DB 66 A4 7F D9 FC 0D 65 DA C7 C6 C6 46 6D DD BA 75 69 E5 
BC 5E AF F6 E4 93 4F A6 95 9B 8B 7B 7B B6 EF 5C 27 93 67 46 53 53 93 76 D9 65 97 A5 B5 5D 92 24 
ED D3 9F FE B4 16 8F C7 C7 95 CF E4 F7 2C 10 08 CE F0 C4 13 4F 68 F7 DE 7B 6F AB 10 FD 82 49 E9 
EF EF D7 9C 4E A7 F6 8D 6F 7C 43 7B ED B5 D7 B4 A3 47 8F 6A 5F FF FA D7 35 40 AB AD AD 4D 2B 7B 
DB 6D B7 69 6F 7B DB DB B4 27 9F 7C 52 6B 69 69 D1 5E 78 E1 05 6D D9 B2 65 1A A0 FD FC E7 3F 9F 
A3 1E 64 86 DF EF D7 96 2C 59 A2 D9 ED 76 ED 87 3F FC A1 76 E4 C8 11 AD AB AB 4B 7B EE B9 E7 B4 
9D 3B 77 A6 95 5D B7 6E 9D B6 66 CD 1A 6D D3 A6 4D 69 AF DF FD EE 77 73 D4 FA F1 28 8A A2 DD 7B 
EF BD 9A CD 66 D3 EA EA EA 26 1D 6C B3 B9 BF 99 D6 39 1B F4 F5 F5 69 26 93 49 BB F9 E6 9B B5 3F 
FC E1 0F DA 9F FE F4 27 ED 1F FF F1 1F 93 13 96 68 34 9A 56 FE 81 07 1E D0 00 ED EA AB AF D6 76 
EC D8 A1 F5 F4 F4 68 8D 8D 8D DA 83 0F 3E 98 2C 9B 6D 9D B3 C1 D3 4F 3F AD 01 DA 37 BF F9 CD 71 
7F 6F AD AD AD C9 72 D9 B4 7D 2E 7F A7 8D 8D 8D DA A5 97 5E AA 99 CD 66 AD AA AA 6A 52 D1 DF D0 
D0 A0 B9 5C 2E 6D D9 B2 65 DA 53 4F 3D A5 B5 B6 B6 6A 3F F9 C9 4F 34 B3 D9 AC 2D 5D BA 54 93 65 
79 DC 35 F1 78 5C 5B B5 6A 95 B6 7C F9 72 0D D0 3E F7 B9 CF A5 9D FF DD EF 7E A7 3D F6 D8 63 E3 
5E 37 DC 70 83 06 68 0F 3C F0 C0 B4 FB 97 CD 7D C8 B4 8F C1 60 50 2B 2F 2F D7 F2 F2 F2 B4 C7 1F 
7F 5C EB EA EA D2 5E 78 E1 05 AD B4 B4 54 B3 5A AD 5A 53 53 53 B2 CE D9 BE B7 E7 FA CE B3 79 66 
AC 5D BB 56 33 1A 8D DA 4F 7F FA 53 AD B3 B3 53 6B 6F 6F 4F 7E 77 3F F8 C1 0F D2 CA 66 F2 7B 16 
08 04 E9 08 D1 2F C8 88 BE BE BE 71 C7 D6 AE 5D AB 01 5A 7B 7B FB 59 CB 6D DB B6 4D 03 B4 7F FA 
A7 7F 3A AF 6D 9C 2E 5F FA D2 97 34 40 7B FE F9 E7 CF 59 76 DD BA 75 DA D5 57 5F 3D 0B AD 9A 3A 
7B F7 EE D5 DC 6E B7 F6 9F FF F9 9F 5A 4F 4F CF 59 07 DB 4C EF 6F 36 75 9E 6F 54 55 D5 5A 5A 5A 
D2 8E 29 8A 92 14 16 AF BE FA 6A F2 78 77 77 B7 66 B1 58 B4 77 BE F3 9D 5A 2C 16 9B 91 3A 67 0B 
5D F4 BF F4 D2 4B 67 2D 97 4D DB E7 F2 77 FA FE F7 BF 5F 7B F7 BB DF AD 35 36 36 6A FF FA AF FF 
3A A9 E8 FF DC E7 3E A7 01 DA 81 03 07 D2 8E DF 71 C7 1D 93 FE 4E EF BF FF 7E CD 68 34 6A 7F FC 
E3 1F 27 14 A0 93 B1 61 C3 06 CD E1 70 68 FD FD FD 53 EB 54 0A D9 DC 87 4C FB F8 E0 83 0F 6A 80 
F6 E0 83 0F A6 95 D3 EF D9 ED B7 DF 9E 3C 36 DB F7 F6 5C DF 79 A6 CF 8C F6 F6 76 0D D0 3E FC E1 
0F A7 1D F7 FB FD E3 AE C9 F4 F7 2C 10 08 D2 D1 45 BF D8 C8 2B 38 2B 3E 9F 6F DC 31 97 CB 05 90 
E6 A7 9A 69 B9 F9 86 2C CB 3C FA E8 A3 BC F5 AD 6F E5 AA AB AE 9A EB E6 CC 08 6B D6 AC E1 F8 F1 
E3 7C E9 4B 5F 3A E7 77 9F E9 7D CB A6 CE F3 8D 24 49 E3 FC 82 0D 06 03 AB 56 AD 02 60 68 68 28 
79 FC 17 BF F8 05 B1 58 8C AF 7F FD EB 67 6D 77 36 75 CE 37 B2 69 FB 5C FE 4E 1F 7E F8 61 5E 78 
E1 05 56 AE 5C 39 69 19 45 51 D8 B2 65 0B AB 57 AF 66 CD 9A 35 69 E7 36 6E DC 08 C0 53 4F 3D 95 
76 BC AB AB 8B BB EF BE 9B 2F 7C E1 0B 5C 74 D1 45 19 B7 67 D7 AE 5D BC FA EA AB DC 78 E3 8D E4 
E5 E5 65 D1 93 89 C9 F4 3E 64 D3 C7 86 86 06 00 AE BC F2 CA B4 72 D7 5C 73 0D 76 BB 9D BF FD ED 
6F C9 63 B3 79 6F 33 F9 CE B3 7D 66 48 92 94 F6 FF C6 C6 46 00 8A 8B 8B 93 C7 32 FD 3D 0B 04 82 
89 11 A2 5F 90 15 AF BF FE 3A AF BC F2 0A 6F 7E F3 9B 29 29 29 99 B4 9C A6 69 3C F4 D0 43 00 7C 
E4 23 1F 99 AD E6 65 CD A1 43 87 18 1A 1A E2 EA AB AF 06 40 55 55 82 C1 E0 39 AF D3 34 0D 4D D3 
CE 77 F3 A6 84 D5 6A 9D 50 00 64 C2 64 F7 77 3A 75 CE 16 4D 4D 4D 00 2C 5D BA 34 79 EC EF 7F FF 
3B 26 93 29 29 9A 42 A1 10 8A A2 4C AB CE B9 40 55 D5 AC AF C9 A4 ED B3 F9 3B 2D 2D 2D 3D 67 99 
DE DE 5E FA FB FB 59 BF 7E FD B8 73 FA 64 E1 D4 A9 53 69 C7 EF BC F3 4E 6C 36 1B 77 DF 7D 77 56 
ED F9 C1 0F 7E 00 C0 6D B7 DD 96 D5 75 D9 32 F6 3E 64 D3 47 7D 13 77 3C 1E 4F 2B 67 B1 58 28 2A 
2A A2 B9 B9 79 D2 CF 3D 9F F7 36 93 EF 3C D3 67 46 65 65 25 EF 7A D7 BB D8 B6 6D 1B 3F FA D1 8F 
80 C4 A4 E2 AB 5F FD 2A 2E 97 8B 2F 7D E9 4B C9 B2 D3 FD 3D 0B 04 8B 1D 11 BD 47 70 56 64 59 E6 
A1 87 1E 22 1C 0E 73 E4 C8 11 7E F5 AB 5F B1 61 C3 06 7E F5 AB 5F 8D 2B BB 67 CF 1E 5E 7E F9 65 
7A 7B 7B 79 F6 D9 67 69 69 69 E1 FB DF FF 3E D7 5C 73 CD 1C B4 3C 33 F4 01 B9 A5 A5 85 AB AE BA 
8A 5D BB 76 11 8B C5 28 29 29 E1 A3 1F FD 28 F7 DE 7B 6F D2 5A 06 09 6B D4 CE 9D 3B 31 1A 8D 98 
4C 26 AA AB AB B9 FC F2 CB F9 D6 B7 BE 45 65 65 E5 5C 75 63 CA 64 73 7F E7 33 BB 77 EF E6 C8 91 
23 5C 7E F9 E5 69 D1 4A 9A 9A 9A F0 7A BD 7C ED 6B 5F 63 CB 96 2D 9C 3C 79 12 AB D5 4A 7D 7D 3D 
DF FF FE F7 C7 59 50 33 A9 73 B6 D0 2D 9F 57 5C 71 05 B2 2C 93 9F 9F CF D2 A5 4B F9 C2 17 BE C0 
27 3E F1 89 71 96 D1 54 CE D6 F6 F9 FC 3B ED EE EE 06 20 37 37 77 DC B9 DC DC 5C 0C 06 03 7E BF 
3F 79 EC A5 97 5E 62 D3 A6 4D 3C F2 C8 23 E4 E6 E6 32 32 32 92 D1 E7 34 37 37 F3 F4 D3 4F F3 9E 
F7 BC 27 69 89 3F 1F 4C 74 1F B2 E9 A3 DE B6 27 9F 7C 32 6D 55 20 12 89 60 36 9B 09 04 02 69 D7 
CF C6 BD 9D EA 77 7E 36 1E 7F FC 71 AE BD F6 5A 6E BB ED 36 7E FD EB 5F D3 D2 D2 82 CB E5 E2 F9 
E7 9F 67 D9 B2 65 C9 72 D3 F9 3D 0B 04 02 21 FA 05 E7 20 10 08 F0 CD 6F 7E 93 68 34 4A 28 14 C2 
66 B3 51 54 54 44 5F 5F 1F 55 55 55 69 65 9F 7E FA 69 FE FB BF FF 3B 69 7D 59 B1 62 05 91 48 84 
58 2C 86 C5 62 99 A3 1E 9C 9D E1 E1 61 00 9E 78 E2 09 3E F1 89 4F 70 D3 4D 37 A1 69 1A 4F 3E F9 
24 FF F3 3F FF 83 DF EF E7 D7 BF FE 75 B2 FC D7 BE F6 35 4E 9C 38 81 CB E5 A2 BF BF 9F 5D BB 76 
F1 E8 A3 8F B2 6D DB 36 F6 EF DF 7F D6 10 73 F3 91 6C EE EF 7C 45 96 65 BE F8 C5 2F 62 32 99 78 
E0 81 07 D2 CE 0D 0F 0F F3 FF DA BB FF 98 AA EA 3F 8E E3 AF 7B 81 68 20 E2 94 21 42 C6 A5 69 B2 
A4 12 35 AC D9 8F 8D D6 D8 6A 2A 73 35 6A 25 33 6D 60 13 6A 35 37 A7 B3 AD DF 28 B5 26 E6 74 B1 
68 CE 74 41 E1 70 6E 6C EA 98 AD 4D 64 51 51 6A D9 D8 08 34 44 E0 12 10 2A 20 20 7C BE 7F 14 F7 
DB ED 72 81 4B C0 C5 C3 F3 B1 B1 C9 39 9F FB E1 7D CE E7 7E AE 2F 2E E7 7C AE D3 E9 D4 C9 93 27 
95 95 95 A5 B8 B8 38 D5 D4 D4 E8 83 0F 3E D0 13 4F 3C A1 73 E7 CE 0D 19 FA 86 EB 73 B2 24 25 25 
29 27 27 47 E1 E1 E1 AE 25 1B 0F 1D 3A A4 17 5E 78 41 67 CF 9E 55 6E 6E EE 90 8F 1B A9 F6 A9 3C 
4F FF FC F3 4F 49 F2 BA 64 6C 70 70 B0 2B 64 0E 0C 0C 28 2B 2B 4B 49 49 49 7A F1 C5 17 7D FA 39 
79 79 79 1A 18 18 70 7B 17 79 BC 79 1B 07 5F 8E 71 E3 C6 8D CA CD CD D5 5B 6F BD A5 5F 7E F9 45 
09 09 09 AA AF AF 57 69 69 A9 9A 9A 9A 74 FB ED B7 BB 3D 76 A2 C7 F6 BF 9C F3 E1 CC 99 33 47 EF 
BC F3 8E 52 53 53 55 51 51 21 49 4A 48 48 F0 58 82 73 AC F3 19 C0 DF B8 91 17 A3 D5 DE DE 6E 0A 
0A 0A 4C 58 58 98 09 0A 0A F2 BA 94 61 5F 5F 9F 39 7B F6 AC 6B 09 4C 7F 2E ED 38 92 82 82 02 23 
C9 EC DF BF DF 63 DF 92 25 4B 8C CD 66 33 AD AD AD C3 F6 B1 6B D7 2E 23 C9 6C DA B4 69 A2 CA 1C 
B3 F6 F6 F6 51 8F C1 68 C7 D7 97 3E 27 43 46 46 86 91 64 DE 7F FF 7D 8F 7D F3 E7 CF 37 51 51 51 
1E 4B 16 96 94 94 18 49 E6 D5 57 5F F5 B9 4F 7F 6A 6D 6D 35 77 DC 71 87 B1 D9 6C A6 B1 B1 71 C8 
36 A3 AD DD 9F F3 D4 DB 8D BC 3F FE F8 A3 91 64 32 33 33 87 7C 5C 40 40 80 49 4E 4E 36 C6 18 B3 
7F FF 7E 63 B7 DB 4D 65 65 A5 6B 7F 7D 7D FD 88 37 F2 0E AE 5A B5 70 E1 C2 09 5D A6 D4 DB 38 F8 
72 8C C6 18 D3 D4 D4 64 32 33 33 CD F2 E5 CB 4D 5C 5C 9C 79 FC F1 C7 CD EE DD BB CD A2 45 8B 4C 
74 74 F4 90 7D 4C D4 D8 8E F5 9C 8F F4 9A F1 F6 DB 6F 1B 49 66 DD BA 75 A6 BE BE DE EC DB B7 CF 
84 87 87 9B D0 D0 50 B7 1B B7 C7 3A 9F 81 E9 8E D5 7B 30 66 F9 F9 F9 46 92 79 EE B9 E7 86 6D D7 
D3 D3 63 1C 0E 87 91 64 AA AB AB 27 A9 3A DF 7C F9 E5 97 46 92 C9 CD CD F5 D8 B7 79 F3 66 23 C9 
54 55 55 0D DB 47 53 53 93 91 64 1E 7C F0 C1 89 2A 73 CC C6 12 D0 47 1A DF A9 14 FA 07 7F E1 CA 
C8 C8 18 72 FF 3D F7 DC 63 42 42 42 3C B6 B7 B4 B4 18 49 66 F5 EA D5 3E F7 E9 6F 9B 36 6D 32 92 
CC F1 E3 C7 3D F6 8D A5 76 7F CC 53 6F A1 7F 30 40 A6 A5 A5 79 3C E6 8F 3F FE 30 92 CC B3 CF 3E 
6B 8C 31 66 EE DC B9 E6 AE BB EE 32 3B 77 EE 74 7D 6D DB B6 CD 35 17 77 EE DC E9 B6 A4 E5 A0 9C 
9C 1C 23 C9 7C FC F1 C7 13 73 70 66 F8 71 F0 E5 18 87 13 1E 1E 6E 52 52 52 86 6D 33 DE 63 3B D6 
73 3E DC 6B C6 89 13 27 8C 24 93 9D 9D ED B6 BD BA BA DA CC 9C 39 D3 44 45 45 B9 56 EA 19 CB 7C 
06 F0 FF D0 CF E5 3D F0 59 62 62 A2 24 C9 E9 74 0E DB 6E F0 13 21 2F 5E BC 28 A7 D3 E9 76 6D E6 
54 31 78 73 5D 5D 5D 9D C7 BE AE AE 2E 49 52 44 44 C4 B0 7D F4 F4 F4 8C AA DD AD 62 B4 E3 EB 6F 
F9 F9 F9 DA BA 75 AB 52 53 53 B5 6F DF BE 21 DB 2C 5C B8 50 17 2E 5C 50 73 73 B3 E6 CE 9D EB DA 
EE 6D 6C 47 D3 A7 BF 79 7B BE 8D B5 F6 A9 34 4F 23 23 23 35 63 C6 0C 7D F7 DD 77 1E FB AA AA AA 
24 49 4B 96 2C 91 24 F5 F6 F6 AA AD AD 4D 6F BC F1 86 AB 8D F9 FB E6 FA CA CA 4A FD F0 C3 0F 9A 
37 6F 9E DB 8D CC 7D 7D 7D DA BB 77 AF C2 C3 C3 B5 7E FD FA 09 39 86 91 C6 C1 97 63 F4 A6 AC AC 
4C 1D 1D 1D 4A 4E 4E 1E B6 DD 78 8F ED 58 CE F9 48 8E 1E 3D 2A 49 CA C8 C8 70 DB 7E F7 DD 77 6B 
F5 EA D5 3A 74 E8 90 6A 6B 6B B5 68 D1 22 9F E7 33 00 77 AC DE 03 AF 5A 5A 5A 5C 2F A6 FF 54 56 
56 26 C9 FD 3F A6 8B 17 2F 7A B4 EB E8 E8 D0 F7 DF 7F 2F BB DD EE B1 34 DD 54 B1 78 F1 62 CD 99 
33 47 25 25 25 EA ED ED 75 6D BF 7E FD BA 4A 4B 4B 75 E7 9D 77 BA AE D3 F7 B6 82 CA E1 C3 87 25 
49 0F 3D F4 D0 C4 17 3C 8E 7C 19 DF A9 E6 8B 2F BE D0 CB 2F BF AC 94 94 14 15 15 15 29 20 20 60 
C8 76 8F 3E FA A8 24 A9 A8 A8 C8 6D FB E0 F7 2B 57 AE F4 B9 CF C9 32 D4 F3 AD B5 B5 55 C7 8F 1F 
57 58 58 98 12 12 12 5C DB 47 5B FB 54 9F A7 B7 DD 76 9B D6 AC 59 A3 DA DA 5A D7 B5 DD 83 F2 F3 
F3 65 B7 DB F5 FC F3 CF 4B 92 DA DA DA D4 DB DB EB F6 35 F8 CB 7B 66 66 A6 7A 7B 7B 95 9E 9E EE 
D6 47 51 51 91 1A 1A 1A B4 61 C3 06 B7 1B F4 C7 CB 68 C6 C1 97 63 1C 4A 47 47 87 B6 6F DF AE 90 
90 10 6D DC B8 D1 B5 7D 32 C6 76 2C E7 7C 24 A1 A1 A1 92 A4 53 A7 4E B9 6D EF EF EF D7 99 33 67 
14 10 10 E0 BA 09 DA 97 F9 0C C0 13 EF F4 C3 AB C2 C2 42 BD FB EE BB 4A 4F 4F D7 8A 15 2B 14 14 
14 A4 6F BE F9 46 7B F7 EE 55 44 44 84 5E 7F FD 75 57 DB 65 CB 96 69 E9 D2 A5 5A BB 76 AD 1C 0E 
87 AE 5C B9 A2 3D 7B F6 A8 B9 B9 59 DB B6 6D F3 B8 21 6B AA 08 0A 0A 52 76 76 B6 DE 7C F3 4D 3D 
F9 E4 93 CA CE CE D6 8D 1B 37 F4 E1 87 1F CA E9 74 AA A8 A8 C8 B5 4A CA EE DD BB 75 E4 C8 11 A5 
A5 A5 69 C1 82 05 EA EC EC D4 89 13 27 74 E0 C0 01 2D 5E BC 58 AF BD F6 9A 9F 8F E6 2F 3D 3D 3D 
3A 78 F0 A0 06 06 06 5C A1 BE AE AE 4E 9F 7C F2 89 24 29 25 25 45 0E 87 C3 A7 F1 1D 6D 9F 93 E1 
E7 9F 7F 56 7A 7A BA 02 03 03 B5 6C D9 32 8F 1B 5A 63 62 62 5C 37 19 A6 A7 A7 2B 27 27 47 5B B7 
6E D5 CD 9B 37 95 90 90 A0 D3 A7 4F 2B 27 27 47 F7 DE 7B AF 2B A0 F8 D2 E7 64 89 8D 8D 55 6A 6A 
AA 56 AE 5C A9 59 B3 66 A9 A6 A6 46 7B F6 EC 51 63 63 A3 0E 1E 3C E8 BA 11 D4 97 DA FD 39 4F 2B 
2A 2A 74 EE DC 39 49 FF 5F 7F FE AB AF BE 52 45 45 85 22 22 22 5C 6B D4 67 65 65 E9 C8 91 23 5A 
BB 76 AD 76 EC D8 A1 D8 D8 58 95 94 94 A8 B8 B8 58 D9 D9 D9 FF E9 66 F9 8F 3E FA 48 76 BB 5D 59 
59 59 FF FD 80 FE C5 97 71 18 ED 31 9E 3F 7F 5E 9F 7E FA A9 1E 7B EC 31 CD 9A 35 4B 3F FD F4 93 
0A 0A 0A F4 EB AF BF AA B0 B0 D0 6D 49 CC A9 F6 1A 3C DA D7 8C 67 9E 79 46 79 79 79 7A EF BD F7 
E4 74 3A 95 9C 9C AC 86 86 06 95 94 94 A8 B6 B6 56 1B 36 6C 50 48 48 88 A4 D1 CF 67 00 5E 70 4D 
3F BC 69 68 68 30 69 69 69 26 24 24 C4 48 32 92 4C 60 60 A0 79 EA A9 A7 CC 85 0B 17 DC DA 7E F6 
D9 67 26 3E 3E DE D5 4E 92 99 37 6F 9E C9 CB CB 73 7D A4 FC 54 D5 DF DF 6F B6 6C D9 62 82 83 83 
5D B5 2F 58 B0 C0 1C 3B 76 CC AD 5D 55 55 95 49 4A 4A 32 76 BB DD D5 2E 34 34 D4 6C DE BC D9 B4 
B4 B4 F8 A9 7A 4F 75 75 75 C6 66 B3 B9 8D C5 3F BF 0E 1C 38 60 8C F1 6D 7C 47 DB E7 64 38 79 F2 
A4 D7 3A 24 99 F8 F8 78 B7 F6 95 95 95 E6 FE FB EF 77 1B B3 75 EB D6 99 F6 F6 F6 31 F7 39 19 B6 
6C D9 62 66 CF 9E ED AA C1 66 B3 99 FB EE BB CF E3 79 E9 4B ED FE 9C A7 EB D7 AF F7 5A A3 C3 E1 
70 6B 7B EA D4 29 13 1F 1F EF 7A CE C5 C4 C4 98 1D 3B 76 8C F8 33 AE 5C B9 62 24 99 57 5E 79 C5 
63 DF B7 DF 7E 6B 24 99 A7 9F 7E 7A DC 8E E9 9F 7C 7D 0E 8D E6 18 AB AB AB 4D 74 74 B4 AB 0F BB 
DD 6E 96 2F 5F 6E CA CA CA 3C 7E BE BF C6 D6 DB 39 F7 E5 35 A3 B4 B4 D4 6D 8E 4A 32 E1 E1 E1 66 
FB F6 ED A6 BB BB DB AD DF D1 CC 67 00 EE 06 AF E9 B7 E5 E6 E6 2E BD 79 F3 E6 0F AB 56 AD 72 FB 
73 31 30 A8 AF AF 4F F5 F5 F5 1A 18 18 90 C3 E1 50 60 A0 F7 3F 10 B5 B6 B6 BA AE B7 9C EA 1F E6 
F4 6F BD BD BD BA 74 E9 92 22 23 23 87 7D 57 EC DA B5 6B BA 7C F9 B2 66 CE 9C A9 E8 E8 E8 61 D7 
4B BF 15 F8 32 BE B7 B2 96 96 16 5D BD 7A 55 71 71 71 B2 DB 6F 8D 2B 1B 8D 31 AA AF AF 57 67 67 
A7 62 63 63 5D EF 78 FE 57 B7 CA 3C ED E8 E8 D0 B5 6B D7 7C 7A 77 BF BB BB 5B C1 C1 C1 43 8E F1 
F5 EB D7 15 1A 1A 3A A5 E6 EC 48 C7 38 F8 1C E8 EA EA 92 C3 E1 F0 58 A6 F3 DF FC 31 B6 C3 9D 73 
5F 5C BD 7A 55 0D 0D 0D 9A 3D 7B B6 22 23 23 87 1D A7 5B 71 3E 03 FE 52 5C 5C AC DF 7E FB ED 22 
A1 1F 00 00 00 B0 A8 C1 D0 CF AF C7 00 00 00 80 C5 11 FA 01 00 00 00 8B 23 F4 03 00 00 00 16 47 
E8 07 00 00 00 2C 8E D0 0F 00 00 00 58 1C A1 1F 00 00 00 B0 38 42 3F 00 00 00 60 71 84 7E 00 00 
00 C0 E2 08 FD 00 00 00 80 C5 11 FA 01 00 00 00 8B 23 F4 03 00 00 00 16 47 E8 07 00 00 00 2C 8E 
D0 0F 00 00 00 58 1C A1 1F 00 00 00 B0 38 42 3F 00 00 00 60 71 84 7E 00 00 00 C0 E2 08 FD 00 30 
81 5A 5A 5A 54 59 59 A9 C6 C6 46 7F 97 02 00 98 C6 08 FD 00 30 01 FA FB FB 95 9E 9E AE C8 C8 48 
AD 58 B1 42 31 31 31 3A 7F FE BC BF CB 02 00 4C 53 81 FE 2E 00 00 AC A8 B0 B0 50 9F 7F FE B9 24 
29 2A 2A 4A C6 18 75 75 75 F9 B9 2A 00 C0 74 45 E8 07 80 09 F0 F5 D7 5F 4B 92 C2 C2 C2 54 53 53 
A3 D0 D0 50 3F 57 04 00 98 CE B8 BC 07 00 26 C0 E0 35 FC 31 31 31 04 7E 00 80 DF 11 FA 01 60 1C 
5D BA 74 49 8F 3C F2 88 CE 9C 39 23 49 FA FD F7 DF F5 F0 C3 0F EB A5 97 5E F2 73 65 00 80 E9 8C 
CB 7B 00 60 1C 35 37 37 EB F4 E9 D3 AE EF BB BA BA 54 5E 5E 2E A7 D3 E9 C7 AA 00 00 D3 1D EF F4 
03 C0 38 4A 4C 4C D4 B1 63 C7 94 98 98 28 49 9A 3F 7F BE 8E 1E 3D AA C3 87 0F FB B9 32 00 C0 74 
46 E8 07 80 71 14 14 14 A4 55 AB 56 29 32 32 52 D2 5F 37 F2 AE 59 B3 46 0F 3C F0 80 9F 2B 03 00 
4C 67 84 7E 00 00 00 C0 E2 08 FD 00 00 00 80 C5 11 FA 01 00 00 00 8B 23 F4 03 00 00 00 16 47 E8 
07 00 00 00 2C 8E D0 0F 00 13 60 F0 53 78 F9 34 5E 00 C0 54 C0 87 73 01 C0 04 28 2E 2E 56 67 67 
A7 42 42 42 FC 5D 0A 00 00 84 7E 00 98 08 36 9B 4D 33 66 CC F0 77 19 00 00 48 E2 F2 1E 00 00 00 
C0 F2 08 FD 00 00 00 80 C5 11 FA 01 00 00 00 8B 23 F4 03 00 00 00 16 47 E8 07 00 00 00 2C 8E D0 
0F 00 00 00 58 1C A1 1F 00 00 00 B0 38 42 3F 00 00 00 60 71 84 7E 00 00 00 C0 E2 08 FD 00 00 00 
80 C5 11 FA 01 00 00 00 8B 23 F4 03 00 00 00 16 47 E8 07 00 00 00 2C 8E D0 0F 00 00 00 58 1C A1 
1F 00 00 00 B0 38 42 3F 00 00 00 60 71 84 7E 00 00 00 C0 E2 08 FD 00 00 00 80 C5 11 FA 01 00 00 
00 8B 23 F4 03 00 00 00 16 47 E8 07 00 00 00 2C 8E D0 0F 00 00 00 58 1C A1 1F 00 00 00 B0 38 42 
3F 00 00 00 60 71 84 7E 00 00 00 C0 E2 08 FD 00 00 00 80 C5 11 FA 01 00 00 00 8B 23 F4 03 00 00 
00 16 47 E8 07 00 00 00 2C 8E D0 0F 00 00 00 58 5C E0 E0 3F DA DA DA 74 F9 F2 65 7F D6 02 00 00 
00 60 1C 75 77 77 4B 92 02 07 06 06 7A 24 A9 BC BC 5C E5 E5 E5 7E 2D 0A 00 00 00 C0 F8 B2 D9 6C 
37 6C 92 B4 6B D7 AE 27 24 85 F9 B9 1E 00 00 00 00 E3 EF D7 FF 01 B5 06 C8 77 ED 61 FD E0 00 00 
00 00 49 45 4E 44 AE 42 60 82 
EndData
$EndBitmap
$Comp
L 4606X-R2R-103LF R9
U 1 1 598EE458
P 7350 4600
F 0 "R9" H 7350 4100 60  0000 C CNN
F 1 "R=10kΩ" H 7350 5100 60  0000 C CNN
F 2 "Resistors_THT:R_Array_SIP6" H 6700 4000 60  0001 C CNN
F 3 "" H 6700 4000 60  0001 C CNN
	1    7350 4600
	1    0    0    -1  
$EndComp
$Comp
L LED D5
U 1 1 597C7231
P 5350 3900
F 0 "D5" H 5350 4000 50  0000 C CNN
F 1 "LED" H 5350 3800 50  0000 C CNN
F 2 "LEDs:LED_D3.0mm" H 5350 3900 50  0001 C CNN
F 3 "" H 5350 3900 50  0001 C CNN
	1    5350 3900
	-1   0    0    1   
$EndComp
$Comp
L 4605X-101-222LF R8
U 1 1 59906810
P 6350 3450
F 0 "R8" V 7000 3500 60  0000 C CNN
F 1 "4605X-101-222LF" H 6350 3850 60  0001 C CNN
F 2 "Resistors_THT:R_Array_SIP5" V 6100 3300 60  0001 C CNN
F 3 "" V 6100 3300 60  0001 C CNN
	1    6350 3450
	0    1    -1   0   
$EndComp
$Comp
L 74HC595 U39
U 1 1 59983CBF
P 3600 6450
F 0 "U39" H 3750 7050 50  0000 C CNN
F 1 "74HC595" H 3600 5850 50  0000 C CNN
F 2 "Kicad:DIP-16-MvK" H 3600 6450 50  0001 C CNN
F 3 "" H 3600 6450 50  0001 C CNN
	1    3600 6450
	1    0    0    -1  
$EndComp
NoConn ~ 4300 6900
Text GLabel 2900 6600 0    60   Input ~ 0
~IE
Text GLabel 4300 6000 2    60   Input ~ 0
BUS0
Text GLabel 4300 6100 2    60   Input ~ 0
BUS1
Text GLabel 4300 6200 2    60   Input ~ 0
BUS2
Text GLabel 4300 6300 2    60   Input ~ 0
BUS3
Text GLabel 4300 6400 2    60   Input ~ 0
BUS4
Text GLabel 4300 6500 2    60   Input ~ 0
BUS5
Text GLabel 4300 6600 2    60   Input ~ 0
BUS6
Text GLabel 4300 6700 2    60   Input ~ 0
BUS7
Text GLabel 2900 6300 0    60   Input ~ 0
H
Text GLabel 2500 6000 0    60   Input ~ 0
SER_DATA
Text GLabel 1950 5800 2    60   Output ~ 0
SER_LATCH
Text GLabel 1950 5600 2    60   Output ~ 0
SER_PULSE
$Comp
L DB9_MALE_MountingHoles J4
U 1 1 599874D7
P 6250 5800
F 0 "J4" H 6250 6450 50  0000 C CNN
F 1 "DB9_MALE_MountingHoles" H 6250 6375 50  0000 C CNN
F 2 "Connectors:DB9MD" H 6250 5800 50  0001 C CNN
F 3 "" H 6250 5800 50  0001 C CNN
	1    6250 5800
	1    0    0    -1  
$EndComp
Text GLabel 5450 6000 0    60   Input ~ 0
SER_DATA
Text GLabel 5450 5800 0    60   Input ~ 0
SER_LATCH
Text GLabel 5450 5600 0    60   Input ~ 0
SER_PULSE
NoConn ~ 5950 5400
NoConn ~ 5950 6200
$Comp
L GND #PWR016
U 1 1 59A0D7BF
P 6250 6600
F 0 "#PWR016" H 6250 6350 50  0001 C CNN
F 1 "GND" H 6250 6450 50  0000 C CNN
F 2 "" H 6250 6600 50  0001 C CNN
F 3 "" H 6250 6600 50  0001 C CNN
	1    6250 6600
	1    0    0    -1  
$EndComp
NoConn ~ 5950 5500
NoConn ~ 5950 5900
$Comp
L VCC #PWR017
U 1 1 59A0E067
P 5550 5400
F 0 "#PWR017" H 5550 5250 50  0001 C CNN
F 1 "VCC" H 5550 5550 50  0000 C CNN
F 2 "" H 5550 5400 50  0001 C CNN
F 3 "" H 5550 5400 50  0001 C CNN
	1    5550 5400
	1    0    0    -1  
$EndComp
Text Notes 6600 5900 0    60   ~ 0
DB9 connector for a\n"Famiclone" game controller
$Comp
L GND #PWR018
U 1 1 598F5F86
P 6700 4100
F 0 "#PWR018" H 6700 3850 50  0001 C CNN
F 1 "GND" H 6700 3950 50  0000 C CNN
F 2 "" H 6700 4100 50  0001 C CNN
F 3 "" H 6700 4100 50  0001 C CNN
	1    6700 4100
	1    0    0    -1  
$EndComp
$Comp
L R R19
U 1 1 59C297B1
P 2800 5750
F 0 "R19" V 2880 5750 50  0000 C CNN
F 1 "2.2k" V 2800 5750 50  0000 C CNN
F 2 "Resistors_THT:R_Axial_DIN0207_L6.3mm_D2.5mm_P10.16mm_Horizontal" V 2730 5750 50  0001 C CNN
F 3 "" H 2800 5750 50  0001 C CNN
	1    2800 5750
	1    0    0    -1  
$EndComp
$Comp
L VCC #PWR019
U 1 1 59C29A02
P 2800 5600
F 0 "#PWR019" H 2800 5450 50  0001 C CNN
F 1 "VCC" H 2800 5750 50  0000 C CNN
F 2 "" H 2800 5600 50  0001 C CNN
F 3 "" H 2800 5600 50  0001 C CNN
	1    2800 5600
	1    0    0    -1  
$EndComp
Text Notes 9600 5400 0    60   ~ 0
3.5mm stereo audio connector\nfor PC speakers or amplifier
Wire Wire Line
	1400 1300 1650 1300
Wire Wire Line
	1400 1500 1650 1500
Wire Wire Line
	1400 2500 1650 2500
Wire Wire Line
	1550 2500 1550 6500
Wire Wire Line
	1550 4500 2900 4500
Connection ~ 1550 2500
Wire Wire Line
	1950 1300 2150 1300
Wire Wire Line
	2150 1300 2150 1500
Wire Wire Line
	2150 1500 1950 1500
Wire Wire Line
	1950 1700 2150 1700
Wire Wire Line
	2150 1700 2150 1900
Wire Wire Line
	2150 1900 1950 1900
Wire Wire Line
	1950 2100 2150 2100
Wire Wire Line
	2150 2100 2150 2300
Wire Wire Line
	2150 2300 1950 2300
Wire Wire Line
	2150 1400 3300 1400
Connection ~ 2150 1400
Wire Wire Line
	2150 1800 2600 1800
Connection ~ 2150 1800
Wire Wire Line
	2150 2200 2800 2200
Connection ~ 2150 2200
Wire Wire Line
	1400 1700 1650 1700
Wire Wire Line
	1400 1900 1650 1900
Wire Wire Line
	1400 2100 1650 2100
Wire Wire Line
	1400 2300 1650 2300
Wire Wire Line
	2600 1800 2600 1600
Wire Wire Line
	2600 1600 3300 1600
Wire Wire Line
	2800 2200 2800 1800
Wire Wire Line
	2800 1800 3300 1800
Wire Wire Line
	3100 2200 3300 2200
Wire Wire Line
	3100 1300 3100 2550
Wire Wire Line
	3100 2550 3600 2550
Wire Wire Line
	3300 1300 3100 1300
Connection ~ 3100 2200
Wire Wire Line
	3300 1500 3100 1500
Connection ~ 3100 1500
Wire Wire Line
	3300 1700 3100 1700
Connection ~ 3100 1700
Wire Wire Line
	3300 2100 3100 2100
Connection ~ 3100 2100
Wire Wire Line
	3350 2550 3350 2650
Connection ~ 3350 2550
Wire Wire Line
	2500 2500 2500 2950
Wire Wire Line
	1850 2950 4000 2950
Wire Wire Line
	4000 2950 4000 1800
Wire Wire Line
	4000 1800 3900 1800
Wire Wire Line
	2350 2700 2350 3100
Wire Wire Line
	1700 3100 4100 3100
Wire Wire Line
	4100 3100 4100 2000
Wire Wire Line
	4100 2000 3900 2000
Wire Wire Line
	4300 3900 5200 3900
Wire Wire Line
	4600 3700 4300 3700
Wire Wire Line
	4400 3600 4300 3600
Wire Wire Line
	4800 3800 4300 3800
Wire Wire Line
	8800 4300 9600 4300
Wire Wire Line
	8200 4300 8200 4450
Wire Wire Line
	8900 4300 8900 4450
Connection ~ 8200 4300
Wire Wire Line
	7900 4900 9500 4900
Wire Wire Line
	8900 4900 8900 4750
Connection ~ 8900 4900
Wire Wire Line
	8200 4750 8200 4900
Connection ~ 8200 4900
Connection ~ 8900 4300
Wire Wire Line
	7900 4300 8500 4300
Wire Wire Line
	5500 3600 5900 3600
Wire Wire Line
	5500 3000 5900 3000
Wire Wire Line
	6800 4900 4800 4900
Wire Wire Line
	4800 4900 4800 4000
Wire Wire Line
	4400 4200 4400 4500
Wire Wire Line
	4800 3800 4800 3600
Wire Wire Line
	4800 3600 5200 3600
Wire Wire Line
	4600 3700 4600 3300
Wire Wire Line
	4600 3300 5200 3300
Wire Wire Line
	4400 3600 4400 3000
Wire Wire Line
	4400 3000 5200 3000
Wire Wire Line
	4300 4300 6800 4300
Wire Wire Line
	2500 6000 2900 6000
Wire Wire Line
	1550 6200 2900 6200
Connection ~ 1550 4500
Wire Wire Line
	5950 5700 5650 5700
Wire Wire Line
	5650 5700 5650 6500
Wire Wire Line
	5650 6500 6250 6500
Wire Wire Line
	6250 6400 6250 6600
Connection ~ 6250 6500
Wire Wire Line
	5950 6100 5550 6100
Wire Wire Line
	5550 6100 5550 5400
Wire Wire Line
	5450 5800 5950 5800
Wire Wire Line
	5450 5600 5950 5600
Wire Wire Line
	5450 6000 5950 6000
Wire Wire Line
	1550 6500 2900 6500
Connection ~ 1550 6200
Wire Wire Line
	4400 4500 6800 4500
Wire Wire Line
	4600 4700 6800 4700
Wire Wire Line
	4400 4200 4300 4200
Wire Wire Line
	4600 4700 4600 4100
Wire Wire Line
	4600 4100 4300 4100
Wire Wire Line
	4800 4000 4300 4000
Wire Wire Line
	6500 4200 6600 4200
Wire Wire Line
	6600 4200 6600 4100
Wire Wire Line
	6600 4100 6700 4100
Wire Wire Line
	5850 3800 5850 3300
Wire Wire Line
	5750 3800 5750 3300
Wire Wire Line
	2800 5900 2800 6000
Connection ~ 2800 6000
Wire Wire Line
	3600 2550 3600 2500
Wire Wire Line
	1700 5800 1950 5800
Wire Wire Line
	1950 2700 2350 2700
Wire Wire Line
	1700 3100 1700 5800
Connection ~ 2350 3100
Wire Wire Line
	1850 2950 1850 5600
Wire Wire Line
	1850 5600 1950 5600
Connection ~ 2500 2950
Wire Wire Line
	1950 2500 2500 2500
Wire Wire Line
	5750 3900 5850 3800
Wire Wire Line
	5500 3900 5750 3900
Wire Wire Line
	5750 3800 5850 3900
Wire Wire Line
	5850 3900 5900 3900
Wire Wire Line
	5750 3300 5500 3300
Wire Wire Line
	5850 3300 5900 3300
Wire Wire Line
	1400 2700 1650 2700
$Comp
L CONN-JACK-STEREO-R/A-3PIN-3.5MM J2
U 1 1 59E7A583
P 9600 4450
F 0 "J2" H 9600 4700 50  0000 L CNN
F 1 "CONN-JACK-STEREO-R/A-3PIN-3.5MM" H 9600 4100 50  0000 L CNN
F 2 "Kicad:SJ1-3523N-MvK" H 9600 4100 50  0001 C CIN
F 3 "http://www.cui.com/product/resource/digikeypdf/sj1-352xn_series.pdf" H 9600 4450 5   0001 C CNN
F 4 "CONN JACK STEREO R/A 3PIN 3.5MM" H 9600 4100 50  0001 C CIN "Description"
F 5 "CUI" H 9600 4100 50  0001 C CIN "MF_Name"
F 6 "SJ1-3523N" H 9600 4100 50  0001 C CIN "MF_PN"
F 7 "Digikey" H 9600 4100 50  0001 C CIN "S1_Name"
F 8 "CP1-3523N-ND" H 9600 4100 50  0001 C CIN "S1_PN"
	1    9600 4450
	1    0    0    -1  
$EndComp
Wire Wire Line
	9400 4300 9400 4600
Connection ~ 9400 4300
Connection ~ 9400 4900
Wire Wire Line
	9400 4600 9600 4600
Wire Wire Line
	9400 4900 9400 4700
Wire Wire Line
	9400 4700 9600 4700
NoConn ~ 9600 4400
NoConn ~ 9600 4500
$EndSCHEMATC
